/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;

public class DropwizardRowIngestionMeters
implements RowIngestionMeters {
    private static final String ONE_MINUTE_NAME = "1m";
    private static final String FIVE_MINUTE_NAME = "5m";
    private static final String FIFTEEN_MINUTE_NAME = "15m";
    private final Meter processed;
    private final Meter processedWithError;
    private final Meter unparseable;
    private final Meter thrownAway;

    public DropwizardRowIngestionMeters() {
        MetricRegistry metricRegistry = new MetricRegistry();
        this.processed = metricRegistry.meter("processed");
        this.processedWithError = metricRegistry.meter("processedWithError");
        this.unparseable = metricRegistry.meter("unparseable");
        this.thrownAway = metricRegistry.meter("thrownAway");
    }

    public long getProcessed() {
        return this.processed.getCount();
    }

    public void incrementProcessed() {
        this.processed.mark();
    }

    public long getProcessedWithError() {
        return this.processedWithError.getCount();
    }

    public void incrementProcessedWithError() {
        this.processedWithError.mark();
    }

    public long getUnparseable() {
        return this.unparseable.getCount();
    }

    public void incrementUnparseable() {
        this.unparseable.mark();
    }

    public long getThrownAway() {
        return this.thrownAway.getCount();
    }

    public void incrementThrownAway() {
        this.thrownAway.mark();
    }

    public RowIngestionMetersTotals getTotals() {
        return new RowIngestionMetersTotals(this.processed.getCount(), this.processedWithError.getCount(), this.thrownAway.getCount(), this.unparseable.getCount());
    }

    public Map<String, Object> getMovingAverages() {
        HashMap<String, Object> movingAverages = new HashMap<String, Object>();
        HashMap<String, Double> oneMinute = new HashMap<String, Double>();
        oneMinute.put("processed", this.processed.getOneMinuteRate());
        oneMinute.put("processedWithError", this.processedWithError.getOneMinuteRate());
        oneMinute.put("unparseable", this.unparseable.getOneMinuteRate());
        oneMinute.put("thrownAway", this.thrownAway.getOneMinuteRate());
        HashMap<String, Double> fiveMinute = new HashMap<String, Double>();
        fiveMinute.put("processed", this.processed.getFiveMinuteRate());
        fiveMinute.put("processedWithError", this.processedWithError.getFiveMinuteRate());
        fiveMinute.put("unparseable", this.unparseable.getFiveMinuteRate());
        fiveMinute.put("thrownAway", this.thrownAway.getFiveMinuteRate());
        HashMap<String, Double> fifteenMinute = new HashMap<String, Double>();
        fifteenMinute.put("processed", this.processed.getFifteenMinuteRate());
        fifteenMinute.put("processedWithError", this.processedWithError.getFifteenMinuteRate());
        fifteenMinute.put("unparseable", this.unparseable.getFifteenMinuteRate());
        fifteenMinute.put("thrownAway", this.thrownAway.getFifteenMinuteRate());
        movingAverages.put(ONE_MINUTE_NAME, oneMinute);
        movingAverages.put(FIVE_MINUTE_NAME, fiveMinute);
        movingAverages.put(FIFTEEN_MINUTE_NAME, fifteenMinute);
        return movingAverages;
    }
}

