/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;
import org.apache.druid.segment.transform.TransformingInputEntityReader;

class SettableByteEntityReader
implements InputEntityReader {
    private final InputFormat inputFormat;
    private final InputRowSchema inputRowSchema;
    private final Transformer transformer;
    private final File indexingTmpDir;
    private InputEntityReader delegate;

    SettableByteEntityReader(InputFormat inputFormat, InputRowSchema inputRowSchema, TransformSpec transformSpec, File indexingTmpDir) {
        this.inputFormat = (InputFormat)Preconditions.checkNotNull((Object)inputFormat, (Object)"inputFormat");
        this.inputRowSchema = inputRowSchema;
        this.transformer = transformSpec.toTransformer();
        this.indexingTmpDir = indexingTmpDir;
    }

    void setEntity(ByteEntity entity) {
        InputFormat format = this.inputFormat instanceof JsonInputFormat ? ((JsonInputFormat)this.inputFormat).withLineSplittable(false) : this.inputFormat;
        this.delegate = new TransformingInputEntityReader(format.createReader(this.inputRowSchema, (InputEntity)entity, this.indexingTmpDir), this.transformer);
    }

    public CloseableIterator<InputRow> read() throws IOException {
        return this.delegate.read();
    }

    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        return this.delegate.sample();
    }
}

