/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexing.common.TaskReport;

public class IngestionStatsAndErrorsTaskReportData {
    @JsonProperty
    private IngestionState ingestionState;
    @JsonProperty
    private Map<String, Object> unparseableEvents;
    @JsonProperty
    private Map<String, Object> rowStats;
    @JsonProperty
    @Nullable
    private String errorMsg;
    @JsonProperty
    private boolean segmentAvailabilityConfirmed;

    public IngestionStatsAndErrorsTaskReportData(@JsonProperty(value="ingestionState") IngestionState ingestionState, @JsonProperty(value="unparseableEvents") Map<String, Object> unparseableEvents, @JsonProperty(value="rowStats") Map<String, Object> rowStats, @JsonProperty(value="errorMsg") @Nullable String errorMsg, @JsonProperty(value="segmentAvailabilityConfirmed") boolean segmentAvailabilityConfirmed) {
        this.ingestionState = ingestionState;
        this.unparseableEvents = unparseableEvents;
        this.rowStats = rowStats;
        this.errorMsg = errorMsg;
        this.segmentAvailabilityConfirmed = segmentAvailabilityConfirmed;
    }

    @JsonProperty
    public IngestionState getIngestionState() {
        return this.ingestionState;
    }

    @JsonProperty
    public Map<String, Object> getUnparseableEvents() {
        return this.unparseableEvents;
    }

    @JsonProperty
    public Map<String, Object> getRowStats() {
        return this.rowStats;
    }

    @JsonProperty
    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty
    public boolean isSegmentAvailabilityConfirmed() {
        return this.segmentAvailabilityConfirmed;
    }

    public static IngestionStatsAndErrorsTaskReportData getPayloadFromTaskReports(Map<String, TaskReport> taskReports) {
        return (IngestionStatsAndErrorsTaskReportData)taskReports.get("ingestionStatsAndErrors").getPayload();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestionStatsAndErrorsTaskReportData that = (IngestionStatsAndErrorsTaskReportData)o;
        return this.getIngestionState() == that.getIngestionState() && Objects.equals(this.getUnparseableEvents(), that.getUnparseableEvents()) && Objects.equals(this.getRowStats(), that.getRowStats()) && Objects.equals(this.getErrorMsg(), that.getErrorMsg()) && Objects.equals(this.isSegmentAvailabilityConfirmed(), that.isSegmentAvailabilityConfirmed());
    }

    public int hashCode() {
        return Objects.hash(this.getIngestionState(), this.getUnparseableEvents(), this.getRowStats(), this.getErrorMsg(), this.isSegmentAvailabilityConfirmed());
    }

    public String toString() {
        return "IngestionStatsAndErrorsTaskReportData{ingestionState=" + this.ingestionState + ", unparseableEvents=" + this.unparseableEvents + ", rowStats=" + this.rowStats + ", errorMsg='" + this.errorMsg + '\'' + ", segmentAvailabilityConfirmed=" + this.segmentAvailabilityConfirmed + '}';
    }
}

