/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.java.util.common.logger.Logger;

public class SingleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(SingleFileTaskReportFileWriter.class);
    private final File reportsFile;
    private ObjectMapper objectMapper;

    public SingleFileTaskReportFileWriter(File reportsFile) {
        this.reportsFile = reportsFile;
    }

    @Override
    public void write(String taskId, Map<String, TaskReport> reports) {
        try {
            File reportsFileParent = this.reportsFile.getParentFile();
            if (reportsFileParent != null) {
                FileUtils.forceMkdir((File)reportsFileParent);
            }
            this.objectMapper.writeValue(this.reportsFile, reports);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in write().", new Object[0]);
        }
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

