/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Parent;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.security.AuthorizerMapper;

public class TaskToolboxFactory {
    private final TaskConfig config;
    private final DruidNode taskExecutorNode;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final QueryProcessingPool queryProcessingPool;
    private final JoinableFactory joinableFactory;
    private final Provider<MonitorScheduler> monitorSchedulerProvider;
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9 indexMergerV9;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;
    private final TaskReportFileWriter taskReportFileWriter;
    private final AuthorizerMapper authorizerMapper;
    private final ChatHandlerProvider chatHandlerProvider;
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final AppenderatorsManager appenderatorsManager;
    private final IndexingServiceClient indexingServiceClient;
    private final CoordinatorClient coordinatorClient;
    private final IntermediaryDataManager intermediaryDataManager;
    private final IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> supervisorTaskClientFactory;
    private final ShuffleClient shuffleClient;

    @Inject
    public TaskToolboxFactory(TaskConfig config, @Parent DruidNode taskExecutorNode, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, QueryProcessingPool queryProcessingPool, JoinableFactory joinableFactory, Provider<MonitorScheduler> monitorSchedulerProvider, SegmentCacheManagerFactory segmentCacheManagerFactory, @Json ObjectMapper jsonMapper, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, @RemoteChatHandler DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter, IntermediaryDataManager intermediaryDataManager, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, AppenderatorsManager appenderatorsManager, IndexingServiceClient indexingServiceClient, CoordinatorClient coordinatorClient, IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> supervisorTaskClientFactory, ShuffleClient shuffleClient) {
        this.config = config;
        this.taskExecutorNode = taskExecutorNode;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryProcessingPool = queryProcessingPool;
        this.joinableFactory = joinableFactory;
        this.monitorSchedulerProvider = monitorSchedulerProvider;
        this.segmentCacheManagerFactory = segmentCacheManagerFactory;
        this.jsonMapper = jsonMapper;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9 = indexMergerV9;
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.intermediaryDataManager = intermediaryDataManager;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.appenderatorsManager = appenderatorsManager;
        this.indexingServiceClient = indexingServiceClient;
        this.coordinatorClient = coordinatorClient;
        this.supervisorTaskClientFactory = supervisorTaskClientFactory;
        this.shuffleClient = shuffleClient;
    }

    public TaskToolbox build(Task task) {
        File taskWorkDir = this.config.getTaskWorkDir(task.getId());
        return new TaskToolbox(this.config, this.taskExecutorNode, this.taskActionClientFactory.create(task), this.emitter, this.segmentPusher, this.dataSegmentKiller, this.dataSegmentMover, this.dataSegmentArchiver, this.segmentAnnouncer, this.serverAnnouncer, this.handoffNotifierFactory, this.queryRunnerFactoryConglomerateProvider, this.queryProcessingPool, this.joinableFactory, this.monitorSchedulerProvider, this.segmentCacheManagerFactory.manufacturate(taskWorkDir), this.jsonMapper, taskWorkDir, this.indexIO, this.cache, this.cacheConfig, this.cachePopulatorStats, this.indexMergerV9, this.druidNodeAnnouncer, this.druidNode, this.lookupNodeService, this.dataNodeService, this.taskReportFileWriter, this.intermediaryDataManager, this.authorizerMapper, this.chatHandlerProvider, this.rowIngestionMetersFactory, this.appenderatorsManager, this.indexingServiceClient, this.coordinatorClient, this.supervisorTaskClientFactory, this.shuffleClient);
    }
}

