/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.java.util.common.ISE;
import org.joda.time.Interval;

public abstract class AbstractFixedIntervalTask
extends AbstractTask {
    @JsonIgnore
    private final Interval interval;

    protected AbstractFixedIntervalTask(String id, String dataSource, Interval interval, Map<String, Object> context) {
        this(id, id, new TaskResource(id, 1), dataSource, interval, context);
    }

    protected AbstractFixedIntervalTask(String id, String groupId, String dataSource, Interval interval, Map<String, Object> context) {
        this(id, groupId, new TaskResource(id, 1), dataSource, interval, context);
    }

    protected AbstractFixedIntervalTask(String id, String groupId, TaskResource taskResource, String dataSource, Interval interval, Map<String, Object> context) {
        super(id, groupId, taskResource, dataSource, context);
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        Preconditions.checkArgument((interval.toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return taskActionClient.submit(new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, this.interval)) != null;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public void stopGracefully(TaskConfig taskConfig) {
    }

    TaskLock getAndCheckLock(TaskToolbox toolbox) throws IOException {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(AbstractFixedIntervalTask.getTaskLocks(toolbox.getTaskActionClient()));
        if (!myLock.getDataSource().equals(this.getDataSource())) {
            throw new ISE("Lock dataSource[%s] != task dataSource[%s]", new Object[]{myLock.getDataSource(), this.getDataSource()});
        }
        if (!myLock.getInterval().equals((Object)this.getInterval())) {
            throw new ISE("Lock interval[%s] != task interval[%s]", new Object[]{myLock.getInterval(), this.getInterval()});
        }
        return myLock;
    }
}

