/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.IOException;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.LinearlyPartitionedSequenceNameFunction;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;

public class SupervisorTaskCoordinatingSegmentAllocator
implements SegmentAllocatorForBatch {
    private final String supervisorTaskId;
    private final ParallelIndexSupervisorTaskClient taskClient;
    private final SequenceNameFunction sequenceNameFunction;
    private final boolean useLineageBasedSegmentAllocation;

    SupervisorTaskCoordinatingSegmentAllocator(String taskId, SupervisorTaskAccess supervisorTaskAccess, boolean useLineageBasedSegmentAllocation) {
        this.supervisorTaskId = supervisorTaskAccess.getSupervisorTaskId();
        this.taskClient = supervisorTaskAccess.getTaskClient();
        this.sequenceNameFunction = new LinearlyPartitionedSequenceNameFunction(taskId);
        this.useLineageBasedSegmentAllocation = useLineageBasedSegmentAllocation;
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        if (this.useLineageBasedSegmentAllocation) {
            return this.taskClient.allocateSegment(this.supervisorTaskId, row.getTimestamp(), sequenceName, previousSegmentId);
        }
        return this.taskClient.allocateSegment(this.supervisorTaskId, row.getTimestamp());
    }

    @Override
    public SequenceNameFunction getSequenceNameFunction() {
        return this.sequenceNameFunction;
    }
}

