/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;

public class DeepStorageShuffleClient
implements ShuffleClient<DeepStoragePartitionLocation> {
    private static final Logger LOG = new Logger(DeepStorageShuffleClient.class);
    private final ObjectMapper objectMapper;

    @Inject
    public DeepStorageShuffleClient(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public File fetchSegmentFile(File partitionDir, String supervisorTaskId, DeepStoragePartitionLocation location) throws IOException {
        LoadSpec loadSpec = (LoadSpec)this.objectMapper.convertValue(location.getLoadSpec(), LoadSpec.class);
        File unzippedDir = new File(partitionDir, StringUtils.format((String)"unzipped_%s", (Object[])new Object[]{location.getSubTaskId()}));
        FileUtils.forceMkdir((File)unzippedDir);
        try {
            loadSpec.loadSegment(unzippedDir);
        }
        catch (SegmentLoadingException e) {
            LOG.error((Throwable)e, "Failed to load segment", new Object[0]);
            throw new IOException(e);
        }
        return unzippedDir;
    }
}

