/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.utils.CompressionUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class HttpShuffleClient
implements ShuffleClient<GenericPartitionLocation> {
    private static final Logger LOG = new Logger(HttpShuffleClient.class);
    @VisibleForTesting
    static final int NUM_FETCH_RETRIES = 3;
    private static final int BUFFER_SIZE = 4096;
    private final HttpClient httpClient;

    @Inject
    public HttpShuffleClient(@EscalatedClient HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public File fetchSegmentFile(File partitionDir, String supervisorTaskId, GenericPartitionLocation location) throws IOException {
        byte[] buffer = new byte[4096];
        File zippedFile = new File(partitionDir, StringUtils.format((String)"temp_%s", (Object[])new Object[]{location.getSubTaskId()}));
        URI uri = location.toIntermediaryDataServerURI(supervisorTaskId);
        org.apache.druid.java.util.common.FileUtils.copyLarge((Object)uri, u -> {
            try {
                return (InputStream)this.httpClient.go(new Request(HttpMethod.GET, u.toURL()), (HttpResponseHandler)new InputStreamResponseHandler()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }, (File)zippedFile, (byte[])buffer, t -> t instanceof IOException, (int)3, (String)StringUtils.format((String)"Failed to fetch file[%s]", (Object[])new Object[]{uri}));
        File unzippedDir = new File(partitionDir, StringUtils.format((String)"unzipped_%s", (Object[])new Object[]{location.getSubTaskId()}));
        try {
            FileUtils.forceMkdir((File)unzippedDir);
            CompressionUtils.unzip((File)zippedFile, (File)unzippedDir);
            if (zippedFile.delete()) return unzippedDir;
        }
        catch (Throwable throwable) {
            if (zippedFile.delete()) throw throwable;
            LOG.warn("Failed to delete temp file[%s]", new Object[]{zippedFile});
            throw throwable;
        }
        LOG.warn("Failed to delete temp file[%s]", new Object[]{zippedFile});
        return unzippedDir;
    }
}

