/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.Rows;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.ClientBasedTaskInfoProvider;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionDistributionReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketch;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.RangePartitionIndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.Interval;

public class PartialDimensionDistributionTask
extends PerfectRollupWorkerTask {
    public static final String TYPE = "partial_dimension_distribution";
    private static final boolean SKIP_NULL = true;
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;
    private final String subtaskSpecId;
    private final Supplier<DedupInputRowFilter> dedupInputRowFilterSupplier;

    @JsonCreator
    PartialDimensionDistributionTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        this(id, groupId, taskResource, supervisorTaskId, subtaskSpecId, numAttempts, ingestionSchema, context, () -> new DedupInputRowFilter(ingestionSchema.getDataSchema().getGranularitySpec().getQueryGranularity()));
    }

    @VisibleForTesting
    PartialDimensionDistributionTask(@Nullable String id, String groupId, TaskResource taskResource, String supervisorTaskId, @Nullable String subtaskSpecId, int numAttempts, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, Supplier<DedupInputRowFilter> dedupRowDimValueFilterSupplier) {
        super(PartialDimensionDistributionTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, ingestionSchema.getDataSchema(), ingestionSchema.getTuningConfig(), context);
        Preconditions.checkArgument((boolean)(ingestionSchema.getTuningConfig().getPartitionsSpec() instanceof SingleDimensionPartitionsSpec), (String)"%s partitionsSpec required", (Object[])new Object[]{"single_dim"});
        this.subtaskSpecId = subtaskSpecId;
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.dedupInputRowFilterSupplier = dedupRowDimValueFilterSupplier;
    }

    @JsonProperty
    private int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    private ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    private String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @Override
    @JsonProperty
    public String getSubtaskSpecId() {
        return this.subtaskSpecId;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        if (!this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals().isEmpty()) {
            return this.tryTimeChunkLock(new SurrogateTaskActionClient(this.supervisorTaskId, taskActionClient), this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
        }
        return true;
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        DataSchema dataSchema = this.ingestionSchema.getDataSchema();
        GranularitySpec granularitySpec = dataSchema.getGranularitySpec();
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        SingleDimensionPartitionsSpec partitionsSpec = (SingleDimensionPartitionsSpec)tuningConfig.getPartitionsSpec();
        Preconditions.checkNotNull((Object)partitionsSpec, (Object)"partitionsSpec required in tuningConfig");
        String partitionDimension = partitionsSpec.getPartitionDimension();
        Preconditions.checkNotNull((Object)partitionDimension, (Object)"partitionDimension required in partitionsSpec");
        boolean isAssumeGrouped = partitionsSpec.isAssumeGrouped();
        InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(this.ingestionSchema.getDataSchema().getParser());
        InputFormat inputFormat = inputSource.needsFormat() ? ParallelIndexSupervisorTask.getInputFormat(this.ingestionSchema) : null;
        RowIngestionMeters buildSegmentsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler(buildSegmentsMeters, tuningConfig.isLogParseExceptions(), tuningConfig.getMaxParseExceptions(), tuningConfig.getMaxSavedParseExceptions());
        boolean determineIntervals = granularitySpec.inputIntervals().isEmpty();
        try (FilteringCloseableInputRowIterator inputRowIterator = AbstractBatchIndexTask.inputSourceReader(toolbox.getIndexingTmpDir(), dataSchema, inputSource, inputFormat, determineIntervals ? Objects::nonNull : AbstractBatchIndexTask.defaultRowFilter(granularitySpec), buildSegmentsMeters, parseExceptionHandler);
             HandlingInputRowIterator iterator = new RangePartitionIndexTaskInputRowIteratorBuilder(partitionDimension, true).delegate(inputRowIterator).granularitySpec(granularitySpec).build();){
            Map<Interval, StringDistribution> distribution = this.determineDistribution(iterator, granularitySpec, partitionDimension, isAssumeGrouped);
            this.sendReport(toolbox, new DimensionDistributionReport(this.getId(), distribution));
        }
        return TaskStatus.success((String)this.getId());
    }

    private Map<Interval, StringDistribution> determineDistribution(HandlingInputRowIterator inputRowIterator, GranularitySpec granularitySpec, String partitionDimension, boolean isAssumeGrouped) {
        PassthroughInputRowFilter inputRowFilter;
        HashMap<Interval, StringDistribution> intervalToDistribution = new HashMap<Interval, StringDistribution>();
        InputRowFilter inputRowFilter2 = inputRowFilter = !isAssumeGrouped && granularitySpec.isRollup() ? (InputRowFilter)this.dedupInputRowFilterSupplier.get() : new PassthroughInputRowFilter();
        while (inputRowIterator.hasNext()) {
            String partitionDimensionValue;
            Interval interval2;
            InputRow inputRow = inputRowIterator.next();
            if (inputRow == null) continue;
            if (granularitySpec.inputIntervals().isEmpty()) {
                interval2 = granularitySpec.getSegmentGranularity().bucket(inputRow.getTimestamp());
            } else {
                Optional optInterval = granularitySpec.bucketInterval(inputRow.getTimestamp());
                assert (optInterval.isPresent());
                interval2 = (Interval)optInterval.get();
            }
            if (!inputRowFilter.accept(interval2, partitionDimensionValue = (String)Iterables.getOnlyElement((Iterable)inputRow.getDimension(partitionDimension)), inputRow)) continue;
            StringDistribution stringDistribution = intervalToDistribution.computeIfAbsent(interval2, k -> new StringSketch());
            stringDistribution.put(partitionDimensionValue);
        }
        inputRowFilter.getIntervalToMinPartitionDimensionValue().forEach((interval, min) -> ((StringDistribution)intervalToDistribution.get(interval)).putIfNewMin((String)min));
        inputRowFilter.getIntervalToMaxPartitionDimensionValue().forEach((interval, max) -> ((StringDistribution)intervalToDistribution.get(interval)).putIfNewMax((String)max));
        return intervalToDistribution;
    }

    private void sendReport(TaskToolbox toolbox, DimensionDistributionReport report) {
        ParallelIndexSupervisorTaskClient taskClient = toolbox.getSupervisorTaskClientFactory().build(new ClientBasedTaskInfoProvider(toolbox.getIndexingServiceClient()), this.getId(), 1, this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        taskClient.report(this.supervisorTaskId, report);
    }

    private static class PassthroughInputRowFilter
    implements InputRowFilter {
        private final Map<Interval, String> intervalToMinDimensionValue = new HashMap<Interval, String>();
        private final Map<Interval, String> intervalToMaxDimensionValue = new HashMap<Interval, String>();

        PassthroughInputRowFilter() {
        }

        @Override
        public boolean accept(Interval interval, String partitionDimensionValue, InputRow inputRow) {
            this.updateMinDimensionValue(interval, partitionDimensionValue);
            this.updateMaxDimensionValue(interval, partitionDimensionValue);
            return true;
        }

        private void updateMinDimensionValue(Interval interval, String dimensionValue) {
            this.intervalToMinDimensionValue.compute(interval, (intervalKey, currentMinValue) -> {
                if (currentMinValue == null || dimensionValue.compareTo((String)currentMinValue) < 0) {
                    return dimensionValue;
                }
                return currentMinValue;
            });
        }

        private void updateMaxDimensionValue(Interval interval, String dimensionValue) {
            this.intervalToMaxDimensionValue.compute(interval, (intervalKey, currentMaxValue) -> {
                if (currentMaxValue == null || dimensionValue.compareTo((String)currentMaxValue) > 0) {
                    return dimensionValue;
                }
                return currentMaxValue;
            });
        }

        @Override
        public Map<Interval, String> getIntervalToMinPartitionDimensionValue() {
            return this.intervalToMinDimensionValue;
        }

        @Override
        public Map<Interval, String> getIntervalToMaxPartitionDimensionValue() {
            return this.intervalToMaxDimensionValue;
        }
    }

    @VisibleForTesting
    static class DedupInputRowFilter
    implements InputRowFilter {
        private static final int BLOOM_FILTER_EXPECTED_INSERTIONS = 100000000;
        private static final double BLOOM_FILTER_EXPECTED_FALSE_POSITIVE_PROBABILTY = 0.001;
        private final PassthroughInputRowFilter delegate = new PassthroughInputRowFilter();
        private final Granularity queryGranularity;
        private final BloomFilter<CharSequence> groupingBloomFilter;

        DedupInputRowFilter(Granularity queryGranularity) {
            this(queryGranularity, 100000000, 0.001);
        }

        @VisibleForTesting
        DedupInputRowFilter(Granularity queryGranularity, int bloomFilterExpectedInsertions, double bloomFilterFalsePositiveProbability) {
            this.queryGranularity = queryGranularity;
            this.groupingBloomFilter = BloomFilter.create((Funnel)Funnels.unencodedCharsFunnel(), (int)bloomFilterExpectedInsertions, (double)bloomFilterFalsePositiveProbability);
        }

        @Override
        public boolean accept(Interval interval, String partitionDimensionValue, InputRow inputRow) {
            this.delegate.accept(interval, partitionDimensionValue, inputRow);
            long bucketTimestamp = this.getBucketTimestamp(inputRow);
            List groupKey = Rows.toGroupKey((long)bucketTimestamp, (InputRow)inputRow);
            String serializedGroupKey = groupKey.toString();
            if (this.groupingBloomFilter.mightContain((Object)serializedGroupKey)) {
                return false;
            }
            this.groupingBloomFilter.put((Object)serializedGroupKey);
            return true;
        }

        private long getBucketTimestamp(InputRow inputRow) {
            long timestamp = inputRow.getTimestampFromEpoch();
            return this.queryGranularity.bucketStart(timestamp);
        }

        @Override
        public Map<Interval, String> getIntervalToMinPartitionDimensionValue() {
            return this.delegate.getIntervalToMinPartitionDimensionValue();
        }

        @Override
        public Map<Interval, String> getIntervalToMaxPartitionDimensionValue() {
            return this.delegate.getIntervalToMaxPartitionDimensionValue();
        }
    }

    private static interface InputRowFilter {
        public boolean accept(Interval var1, String var2, InputRow var3);

        public Map<Interval, String> getIntervalToMinPartitionDimensionValue();

        public Map<Interval, String> getIntervalToMaxPartitionDimensionValue();
    }
}

