/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.timeline.DataSegment;

public class PushedSegmentsReport
implements SubTaskReport {
    public static final String TYPE = "pushed_segments";
    private final String taskId;
    private final Set<DataSegment> oldSegments;
    private final Set<DataSegment> newSegments;

    @JsonCreator
    public PushedSegmentsReport(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="oldSegments") Set<DataSegment> oldSegments, @JsonProperty(value="segments") Set<DataSegment> newSegments) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.oldSegments = (Set)Preconditions.checkNotNull(oldSegments, (Object)"oldSegments");
        this.newSegments = (Set)Preconditions.checkNotNull(newSegments, (Object)"newSegments");
    }

    @Override
    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public Set<DataSegment> getOldSegments() {
        return this.oldSegments;
    }

    @JsonProperty(value="segments")
    public Set<DataSegment> getNewSegments() {
        return this.newSegments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushedSegmentsReport that = (PushedSegmentsReport)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.oldSegments, that.oldSegments) && Objects.equals(this.newSegments, that.newSegments);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.oldSegments, this.newSegments);
    }
}

