/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.curator.cache.PathChildrenCacheFactory;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.indexing.overlord.RemoteTaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.initialization.IndexerZkConfig;

public class RemoteTaskRunnerFactory
implements TaskRunnerFactory<RemoteTaskRunner> {
    public static final String TYPE_NAME = "remote";
    private final CuratorFramework curator;
    private final RemoteTaskRunnerConfig remoteTaskRunnerConfig;
    private final IndexerZkConfig zkPaths;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ProvisioningSchedulerConfig provisioningSchedulerConfig;
    private final ProvisioningStrategy provisioningStrategy;

    @Inject
    public RemoteTaskRunnerFactory(CuratorFramework curator, RemoteTaskRunnerConfig remoteTaskRunnerConfig, IndexerZkConfig zkPaths, ObjectMapper jsonMapper, @EscalatedGlobal HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningSchedulerConfig provisioningSchedulerConfig, ProvisioningStrategy provisioningStrategy) {
        this.curator = curator;
        this.remoteTaskRunnerConfig = remoteTaskRunnerConfig;
        this.zkPaths = zkPaths;
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.workerConfigRef = workerConfigRef;
        this.provisioningSchedulerConfig = provisioningSchedulerConfig;
        this.provisioningStrategy = provisioningStrategy;
    }

    @Override
    public RemoteTaskRunner build() {
        return new RemoteTaskRunner(this.jsonMapper, this.remoteTaskRunnerConfig, this.zkPaths, this.curator, new PathChildrenCacheFactory.Builder().withCompressed(true), this.httpClient, this.workerConfigRef, this.provisioningSchedulerConfig.isDoAutoscale() ? this.provisioningStrategy : new NoopProvisioningStrategy());
    }
}

