/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.Interval;

public class TimeChunkLockRequest
implements LockRequest {
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    @Nullable
    private final String preferredVersion;
    private final int priority;
    private final boolean revoked;

    public TimeChunkLockRequest(TaskLockType lockType, Task task, Interval interval, @Nullable String preferredVersion) {
        this(lockType, task.getGroupId(), task.getDataSource(), interval, preferredVersion, task.getPriority(), false);
    }

    public TimeChunkLockRequest(LockRequestForNewSegment lockRequestForNewSegment) {
        this(lockRequestForNewSegment.getType(), lockRequestForNewSegment.getGroupId(), lockRequestForNewSegment.getDataSource(), lockRequestForNewSegment.getInterval(), lockRequestForNewSegment.getVersion(), lockRequestForNewSegment.getPriority(), lockRequestForNewSegment.isRevoked());
    }

    public TimeChunkLockRequest(TaskLockType lockType, String groupId, String dataSource, Interval interval, @Nullable String preferredVersion, int priority, boolean revoked) {
        this.lockType = lockType;
        this.groupId = groupId;
        this.dataSource = dataSource;
        this.interval = interval;
        this.preferredVersion = preferredVersion;
        this.priority = priority;
        this.revoked = revoked;
    }

    @Override
    public LockGranularity getGranularity() {
        return LockGranularity.TIME_CHUNK;
    }

    @Override
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getVersion() {
        return this.preferredVersion == null ? DateTimes.nowUtc().toString() : this.preferredVersion;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isRevoked() {
        return this.revoked;
    }

    @Override
    public TaskLock toLock() {
        return new TimeChunkLock(this.lockType, this.groupId, this.dataSource, this.interval, this.getVersion(), this.priority, this.revoked);
    }

    public String toString() {
        return "TimeChunkLockRequest{lockType=" + (Object)((Object)this.lockType) + ", groupId='" + this.groupId + '\'' + ", dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", preferredVersion='" + this.preferredVersion + '\'' + ", priority=" + this.priority + ", revoked=" + this.revoked + '}';
    }
}

