/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIngestionSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.NoopTaskAutoScaler;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.metrics.DruidMonitorSchedulerConfig;

public abstract class SeekableStreamSupervisorSpec
implements SupervisorSpec {
    protected final TaskStorage taskStorage;
    protected final TaskMaster taskMaster;
    protected final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    protected final SeekableStreamIndexTaskClientFactory indexTaskClientFactory;
    protected final ObjectMapper mapper;
    protected final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final SeekableStreamSupervisorIngestionSpec ingestionSchema;
    @Nullable
    private final Map<String, Object> context;
    protected final ServiceEmitter emitter;
    protected final DruidMonitorSchedulerConfig monitorSchedulerConfig;
    private final boolean suspended;
    protected final SupervisorStateManagerConfig supervisorStateManagerConfig;

    private static SeekableStreamSupervisorIngestionSpec checkIngestionSchema(SeekableStreamSupervisorIngestionSpec ingestionSchema) {
        Preconditions.checkNotNull((Object)ingestionSchema, (Object)"ingestionSchema");
        Preconditions.checkNotNull((Object)ingestionSchema.getDataSchema(), (Object)"dataSchema");
        Preconditions.checkNotNull((Object)ingestionSchema.getIOConfig(), (Object)"ioConfig");
        return ingestionSchema;
    }

    @JsonCreator
    public SeekableStreamSupervisorSpec(@JsonProperty(value="spec") SeekableStreamSupervisorIngestionSpec ingestionSchema, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JsonProperty(value="suspended") Boolean suspended, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject SeekableStreamIndexTaskClientFactory indexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper, @JacksonInject ServiceEmitter emitter, @JacksonInject DruidMonitorSchedulerConfig monitorSchedulerConfig, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject SupervisorStateManagerConfig supervisorStateManagerConfig) {
        this.ingestionSchema = SeekableStreamSupervisorSpec.checkIngestionSchema(ingestionSchema);
        this.context = context;
        this.taskStorage = taskStorage;
        this.taskMaster = taskMaster;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.indexTaskClientFactory = indexTaskClientFactory;
        this.mapper = mapper;
        this.emitter = emitter;
        this.monitorSchedulerConfig = monitorSchedulerConfig;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.suspended = suspended != null ? suspended : false;
        this.supervisorStateManagerConfig = supervisorStateManagerConfig;
    }

    @JsonProperty
    public SeekableStreamSupervisorIngestionSpec getSpec() {
        return this.ingestionSchema;
    }

    @Deprecated
    @JsonProperty
    public DataSchema getDataSchema() {
        return this.ingestionSchema.getDataSchema();
    }

    @JsonProperty
    public SeekableStreamSupervisorTuningConfig getTuningConfig() {
        return this.ingestionSchema.getTuningConfig();
    }

    @JsonProperty
    public SeekableStreamSupervisorIOConfig getIoConfig() {
        return this.ingestionSchema.getIOConfig();
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public String getId() {
        return this.ingestionSchema.getDataSchema().getDataSource();
    }

    public DruidMonitorSchedulerConfig getMonitorSchedulerConfig() {
        return this.monitorSchedulerConfig;
    }

    public abstract Supervisor createSupervisor();

    public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
        AutoScalerConfig autoScalerConfig = this.ingestionSchema.getIOConfig().getAutoscalerConfig();
        if (autoScalerConfig != null && autoScalerConfig.getEnableTaskAutoScaler() && supervisor instanceof SeekableStreamSupervisor) {
            return autoScalerConfig.createAutoScaler(supervisor, this);
        }
        return new NoopTaskAutoScaler();
    }

    public List<String> getDataSources() {
        return ImmutableList.of((Object)this.getDataSchema().getDataSource());
    }

    public SeekableStreamSupervisorSpec createSuspendedSpec() {
        return this.toggleSuspend(true);
    }

    public SeekableStreamSupervisorSpec createRunningSpec() {
        return this.toggleSuspend(false);
    }

    public SupervisorStateManagerConfig getSupervisorStateManagerConfig() {
        return this.supervisorStateManagerConfig;
    }

    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    protected abstract SeekableStreamSupervisorSpec toggleSuspend(boolean var1);
}

