/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.IndexTaskClient;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.easymock.EasyMock;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IndexTaskClientTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper objectMapper = new DefaultObjectMapper();
    private final int numRetries = 2;

    @Test
    public void failOnMalformedURLException() throws IOException {
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient((HttpClient)EasyMock.createNiceMock(HttpClient.class), id -> TaskLocation.create((String)id, (int)-2, (int)-2));){
            this.expectedException.expect(MalformedURLException.class);
            this.expectedException.expectMessage("Invalid port number :-2");
            indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, true);
        }
    }

    @Test
    public void retryOnChannelException() throws IOException {
        HttpClient httpClient = (HttpClient)EasyMock.createNiceMock(HttpClient.class);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFailedFuture((Throwable)new ChannelException("IndexTaskClientTest"))).times(2);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.value((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), StandardCharsets.UTF_8)))).once();
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            StringFullResponseHolder response = indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, true);
            Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.getStatus());
        }
    }

    @Test
    public void retryOnServerError() throws IOException {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.error((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR), StandardCharsets.UTF_8).addChunk("Error")))).times(2);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.value((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), StandardCharsets.UTF_8)))).once();
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            StringFullResponseHolder response = indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, true);
            Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.getStatus());
        }
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void retryIfNotFoundWithIncorrectTaskId() throws IOException {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        String taskId = "taskId";
        String incorrectTaskId = "incorrectTaskId";
        DefaultHttpResponse incorrectResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        incorrectResponse.headers().add("X-Druid-Task-Id", (Object)"incorrectTaskId");
        DefaultHttpResponse correctResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        correctResponse.headers().add("X-Druid-Task-Id", (Object)"taskId");
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.error((Object)new StringFullResponseHolder((HttpResponse)incorrectResponse, StandardCharsets.UTF_8)))).times(2);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.value((Object)new StringFullResponseHolder((HttpResponse)correctResponse, StandardCharsets.UTF_8)))).once();
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            StringFullResponseHolder response = indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, true);
            Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.getStatus());
        }
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void dontRetryOnBadRequest() {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.error((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST), StandardCharsets.UTF_8).addChunk("Error")))).times(1);
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, true));
            Assert.assertEquals((Object)"Received server error with status [400 Bad Request]; first 1KB of body: Error", (Object)e.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void dontRetryIfRetryFalse() {
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.error((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR), StandardCharsets.UTF_8).addChunk("Error")))).times(1);
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            IOException e = (IOException)Assert.assertThrows(IOException.class, () -> indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, false));
            Assert.assertEquals((Object)"Received server error with status [500 Internal Server Error]; first 1KB of body: Error", (Object)e.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    @Test
    public void dontRetryIfNotFoundWithCorrectTaskId() {
        String taskId = "taskId";
        HttpClient httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        response.headers().add("X-Druid-Task-Id", (Object)"taskId");
        EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)Either.error((Object)new StringFullResponseHolder((HttpResponse)response, StandardCharsets.UTF_8).addChunk("Error")))).times(1);
        EasyMock.replay((Object[])new Object[]{httpClient});
        try (IndexTaskClient indexTaskClient = this.buildIndexTaskClient(httpClient, id -> TaskLocation.create((String)id, (int)8000, (int)-1));){
            IOException e = (IOException)Assert.assertThrows(IOException.class, () -> indexTaskClient.submitRequestWithEmptyContent("taskId", HttpMethod.GET, "test", null, false));
            Assert.assertEquals((Object)"Received server error with status [404 Not Found]; first 1KB of body: Error", (Object)e.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{httpClient});
    }

    private IndexTaskClient buildIndexTaskClient(HttpClient httpClient, final Function<String, TaskLocation> taskLocationProvider) {
        TaskInfoProvider taskInfoProvider = new TaskInfoProvider(){

            public TaskLocation getTaskLocation(String id) {
                return (TaskLocation)taskLocationProvider.apply(id);
            }

            public Optional<TaskStatus> getTaskStatus(String id) {
                return Optional.of((Object)TaskStatus.running((String)id));
            }
        };
        return new TestIndexTaskClient(httpClient, this.objectMapper, taskInfoProvider, new Duration(1000L), "indexTaskClientTest", 1, 2L);
    }

    private static class TestIndexTaskClient
    extends IndexTaskClient {
        private TestIndexTaskClient(HttpClient httpClient, ObjectMapper objectMapper, TaskInfoProvider taskInfoProvider, Duration httpTimeout, String callerId, int numThreads, long numRetries) {
            super(httpClient, objectMapper, taskInfoProvider, httpTimeout, callerId, numThreads, numRetries);
        }

        protected void checkConnection(String host, int port) {
        }
    }
}

