/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TaskLockTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    @Test
    public void testSerdeTimeChunkLock() throws IOException {
        TimeChunkLock lock = new TimeChunkLock(TaskLockType.EXCLUSIVE, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 100);
        String json = this.objectMapper.writeValueAsString((Object)lock);
        TaskLock fromJson = (TaskLock)this.objectMapper.readValue(json, TaskLock.class);
        Assert.assertEquals((Object)lock, (Object)fromJson);
    }

    @Test
    public void testDeserializeTimeChunkLockWithoutType() throws IOException {
        TimeChunkLock expected = new TimeChunkLock(TaskLockType.EXCLUSIVE, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 100);
        String json = "{\n  \"type\" : \"EXCLUSIVE\",\n  \"groupId\" : \"groupId\",\n  \"dataSource\" : \"dataSource\",\n  \"interval\" : \"2019-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\",\n  \"version\" : \"version\",\n  \"priority\" : 100,\n  \"revoked\" : false\n}";
        Assert.assertEquals((Object)expected, (Object)this.objectMapper.readValue("{\n  \"type\" : \"EXCLUSIVE\",\n  \"groupId\" : \"groupId\",\n  \"dataSource\" : \"dataSource\",\n  \"interval\" : \"2019-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\",\n  \"version\" : \"version\",\n  \"priority\" : 100,\n  \"revoked\" : false\n}", TaskLock.class));
    }

    @Test
    public void testSerdeSegmentLock() throws IOException {
        SegmentLock lock = new SegmentLock(TaskLockType.EXCLUSIVE, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 0, 100);
        String json = this.objectMapper.writeValueAsString((Object)lock);
        TaskLock fromJson = (TaskLock)this.objectMapper.readValue(json, TaskLock.class);
        Assert.assertEquals((Object)lock, (Object)fromJson);
    }

    @Test
    public void testSerdeOldLock() throws IOException {
        OldTaskLock oldTaskLock = new OldTaskLock(TaskLockType.EXCLUSIVE, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 10, true);
        byte[] json = this.objectMapper.writeValueAsBytes((Object)oldTaskLock);
        TaskLock fromJson = (TaskLock)this.objectMapper.readValue(json, TaskLock.class);
        Assert.assertEquals((Object)LockGranularity.TIME_CHUNK, (Object)fromJson.getGranularity());
        Assert.assertEquals((Object)TaskLockType.EXCLUSIVE, (Object)fromJson.getType());
        Assert.assertEquals((Object)"groupId", (Object)fromJson.getGroupId());
        Assert.assertEquals((Object)"dataSource", (Object)fromJson.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2019/2020"), (Object)fromJson.getInterval());
        Assert.assertEquals((Object)"version", (Object)fromJson.getVersion());
        Assert.assertEquals((long)10L, (long)fromJson.getPriority().intValue());
        Assert.assertTrue((boolean)fromJson.isRevoked());
    }

    private static class OldTaskLock {
        private final TaskLockType type;
        private final String groupId;
        private final String dataSource;
        private final Interval interval;
        private final String version;
        private final Integer priority;
        private final boolean revoked;

        @JsonCreator
        public OldTaskLock(@JsonProperty(value="type") @Nullable TaskLockType type, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="priority") @Nullable Integer priority, @JsonProperty(value="revoked") boolean revoked) {
            this.type = type == null ? TaskLockType.EXCLUSIVE : type;
            this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
            this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            this.priority = priority;
            this.revoked = revoked;
        }

        @JsonProperty
        public TaskLockType getType() {
            return this.type;
        }

        @JsonProperty
        public String getGroupId() {
            return this.groupId;
        }

        @JsonProperty
        public String getDataSource() {
            return this.dataSource;
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        @JsonProperty
        @Nullable
        public Integer getPriority() {
            return this.priority;
        }

        @JsonProperty
        public boolean isRevoked() {
            return this.revoked;
        }
    }
}

