/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.easymock.EasyMock;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RemoteTaskActionClientTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DruidLeaderClient druidLeaderClient;
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
    }

    @Test
    public void testSubmitSimple() throws Exception {
        Request request = new Request(HttpMethod.POST, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/action")).andReturn((Object)request);
        HashMap<String, List<TimeChunkLock>> responseBody = new HashMap<String, List<TimeChunkLock>>();
        List<TimeChunkLock> expectedLocks = Collections.singletonList(new TimeChunkLock(TaskLockType.SHARED, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 0));
        responseBody.put("result", expectedLocks);
        String strResult = this.objectMapper.writeValueAsString(responseBody);
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        NoopTask task = NoopTask.create((String)"id", (int)0);
        RemoteTaskActionClient client = new RemoteTaskActionClient((Task)task, this.druidLeaderClient, new RetryPolicyFactory(new RetryPolicyConfig()), this.objectMapper);
        List locks = (List)client.submit((TaskAction)new LockListAction());
        Assert.assertEquals(expectedLocks, (Object)locks);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient});
    }

    @Test
    public void testSubmitWithIllegalStatusCode() throws Exception {
        Request request = new Request(HttpMethod.POST, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/action")).andReturn((Object)request);
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.BAD_REQUEST).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk("testSubmitWithIllegalStatusCode");
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        NoopTask task = NoopTask.create((String)"id", (int)0);
        RemoteTaskActionClient client = new RemoteTaskActionClient((Task)task, this.druidLeaderClient, new RetryPolicyFactory((RetryPolicyConfig)this.objectMapper.readValue("{\"maxRetryCount\":0}", RetryPolicyConfig.class)), this.objectMapper);
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Error with status[400 Bad Request] and message[testSubmitWithIllegalStatusCode]. Check overlord logs for details.");
        client.submit((TaskAction)new LockListAction());
    }
}

