/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SegmentAllocateActionSerdeTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();
    private final SegmentAllocateAction target;

    public SegmentAllocateActionSerdeTest() {
        this.objectMapper.registerSubtypes(new Class[]{NumberedPartialShardSpec.class});
        this.target = new SegmentAllocateAction("datasource", DateTimes.nowUtc(), Granularities.MINUTE, Granularities.HOUR, "s1", "prev", false, (PartialShardSpec)NumberedPartialShardSpec.instance(), LockGranularity.SEGMENT, null);
    }

    @Test
    public void testSerde() throws Exception {
        SegmentAllocateAction fromJson = (SegmentAllocateAction)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)this.target), TaskAction.class);
        Assert.assertEquals((Object)this.target.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((Object)this.target.getTimestamp(), (Object)fromJson.getTimestamp());
        Assert.assertEquals((Object)this.target.getQueryGranularity(), (Object)fromJson.getQueryGranularity());
        Assert.assertEquals((Object)this.target.getPreferredSegmentGranularity(), (Object)fromJson.getPreferredSegmentGranularity());
        Assert.assertEquals((Object)this.target.getSequenceName(), (Object)fromJson.getSequenceName());
        Assert.assertEquals((Object)this.target.getPreviousSegmentId(), (Object)fromJson.getPreviousSegmentId());
        Assert.assertEquals((Object)this.target.isSkipSegmentLineageCheck(), (Object)fromJson.isSkipSegmentLineageCheck());
        Assert.assertEquals((Object)TaskLockType.EXCLUSIVE, (Object)this.target.getTaskLockType());
    }

    @Test
    public void testJsonPropertyNames() throws IOException {
        Map fromJson = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)this.target), Map.class);
        Assert.assertEquals((long)11L, (long)fromJson.size());
        Assert.assertEquals((Object)"segmentAllocate", fromJson.get("type"));
        Assert.assertEquals((Object)this.target.getDataSource(), fromJson.get("dataSource"));
        Assert.assertEquals((Object)this.target.getTimestamp(), (Object)DateTimes.of((String)((String)fromJson.get("timestamp"))));
        Assert.assertEquals((Object)this.target.getQueryGranularity(), (Object)Granularity.fromString((String)((String)fromJson.get("queryGranularity"))));
        Assert.assertEquals((Object)this.target.getPreferredSegmentGranularity(), (Object)Granularity.fromString((String)((String)fromJson.get("preferredSegmentGranularity"))));
        Assert.assertEquals((Object)this.target.getSequenceName(), fromJson.get("sequenceName"));
        Assert.assertEquals((Object)this.target.getPreviousSegmentId(), fromJson.get("previousSegmentId"));
        Assert.assertEquals((Object)this.target.isSkipSegmentLineageCheck(), fromJson.get("skipSegmentLineageCheck"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered"), fromJson.get("shardSpecFactory"));
        Assert.assertEquals((Object)this.target.getLockGranularity(), (Object)LockGranularity.valueOf((String)((String)fromJson.get("lockGranularity"))));
        Assert.assertEquals((Object)this.target.getTaskLockType(), (Object)TaskLockType.valueOf((String)((String)fromJson.get("taskLockType"))));
    }
}

