/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SegmentTransactionalInsertActionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TaskActionTestKit actionTestKit = new TaskActionTestKit();
    private static final String DATA_SOURCE = "none";
    private static final Interval INTERVAL = Intervals.of((String)"2020/2020T01");
    private static final String PARTY_YEAR = "1999";
    private static final String THE_DISTANT_FUTURE = "3000";
    private static final DataSegment SEGMENT1 = new DataSegment("none", INTERVAL, "1999", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 1024L);
    private static final DataSegment SEGMENT2 = new DataSegment("none", INTERVAL, "1999", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 1024L);
    private static final DataSegment SEGMENT3 = new DataSegment("none", INTERVAL, "3000", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 1024L);

    private LockResult acquireTimeChunkLock(TaskLockType lockType, Task task, Interval interval, long timeoutMs) throws InterruptedException {
        return this.actionTestKit.getTaskLockbox().lock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null), timeoutMs);
    }

    @Test
    public void testTransactionalUpdateDataSourceMetadata() throws Exception {
        NoopTask task = NoopTask.create();
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        SegmentPublishResult result1 = SegmentTransactionalInsertAction.appendAction((Set)ImmutableSet.of((Object)SEGMENT1), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableList.of((Object)1))).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SEGMENT1)), (Object)result1);
        SegmentPublishResult result2 = SegmentTransactionalInsertAction.appendAction((Set)ImmutableSet.of((Object)SEGMENT2), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableList.of((Object)1)), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableList.of((Object)2))).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SEGMENT2)), (Object)result2);
        Assertions.assertThat((Iterable)this.actionTestKit.getMetadataStorageCoordinator().retrieveUsedSegmentsForInterval(DATA_SOURCE, INTERVAL, Segments.ONLY_VISIBLE)).containsExactlyInAnyOrder((Object[])new DataSegment[]{SEGMENT1, SEGMENT2});
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableList.of((Object)2)), (Object)this.actionTestKit.getMetadataStorageCoordinator().retrieveDataSourceMetadata(DATA_SOURCE));
    }

    @Test
    public void testTransactionalDropSegments() throws Exception {
        NoopTask task = NoopTask.create();
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        SegmentPublishResult result1 = SegmentTransactionalInsertAction.overwriteAction(null, null, (Set)ImmutableSet.of((Object)SEGMENT1)).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SEGMENT1)), (Object)result1);
        SegmentPublishResult result2 = SegmentTransactionalInsertAction.overwriteAction(null, (Set)ImmutableSet.of((Object)SEGMENT1), (Set)ImmutableSet.of((Object)SEGMENT2)).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SEGMENT2)), (Object)result2);
        Assertions.assertThat((Iterable)this.actionTestKit.getMetadataStorageCoordinator().retrieveUsedSegmentsForInterval(DATA_SOURCE, INTERVAL, Segments.ONLY_VISIBLE)).containsExactlyInAnyOrder((Object[])new DataSegment[]{SEGMENT2});
    }

    @Test
    public void testFailTransactionalUpdateDataSourceMetadata() throws Exception {
        NoopTask task = NoopTask.create();
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        SegmentPublishResult result = SegmentTransactionalInsertAction.appendAction((Set)ImmutableSet.of((Object)SEGMENT1), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableList.of((Object)1)), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableList.of((Object)2))).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Aborting transaction!"), (Object)result);
    }

    @Test
    public void testFailTransactionalDropSegment() throws Exception {
        NoopTask task = NoopTask.create();
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        SegmentPublishResult result = SegmentTransactionalInsertAction.overwriteAction(null, (Set)ImmutableSet.of((Object)SEGMENT1), (Set)ImmutableSet.of((Object)SEGMENT2)).perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"org.apache.druid.metadata.RetryTransactionException: Aborting transaction!"), (Object)result);
    }

    @Test
    public void testFailBadVersion() throws Exception {
        NoopTask task = NoopTask.create();
        SegmentTransactionalInsertAction action = SegmentTransactionalInsertAction.overwriteAction(null, null, (Set)ImmutableSet.of((Object)SEGMENT3));
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"are not covered by locks"));
        SegmentPublishResult result = action.perform((Task)task, this.actionTestKit.getTaskActionToolbox());
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SEGMENT3)), (Object)result);
    }
}

