/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.indexing.test.TestIndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskLocksTest {
    private TaskLockbox lockbox;
    private Task task;

    @Before
    public void setup() {
        this.lockbox = new TaskLockbox((TaskStorage)new HeapMemoryTaskStorage(new TaskStorageConfig(null)), (IndexerMetadataStorageCoordinator)new TestIndexerMetadataStorageCoordinator());
        this.task = NoopTask.create();
        this.lockbox.add(this.task);
    }

    private Set<DataSegment> createTimeChunkedSegments() {
        return ImmutableSet.of((Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(DateTimes.nowUtc().toString()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(2))).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-02/2017-01-03")).version(DateTimes.nowUtc().toString()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(2))).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-03/2017-01-04")).version(DateTimes.nowUtc().toString()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(2))).size(0L).build());
    }

    private Set<DataSegment> createNumberedPartitionedSegments() {
        String version = DateTimes.nowUtc().toString();
        return ImmutableSet.of((Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(version).shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(version).shardSpec((ShardSpec)new NumberedShardSpec(1, 0)).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(version).shardSpec((ShardSpec)new NumberedShardSpec(2, 0)).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(version).shardSpec((ShardSpec)new NumberedShardSpec(3, 0)).size(0L).build(), (Object)new DataSegment.Builder().dataSource(this.task.getDataSource()).interval(Intervals.of((String)"2017-01-01/2017-01-02")).version(version).shardSpec((ShardSpec)new NumberedShardSpec(4, 0)).size(0L).build());
    }

    private LockResult tryTimeChunkLock(Task task, Interval interval) {
        return this.lockbox.tryLock(task, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, task, interval, null));
    }

    private LockResult trySegmentLock(Task task, Interval interval, String version, int partitonId) {
        return this.lockbox.tryLock(task, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, task, interval, version, partitonId));
    }

    @Test
    public void testCheckLockCoversSegments() {
        Set<DataSegment> segments = this.createTimeChunkedSegments();
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2017-01-01/2017-01-02"), (Object)Intervals.of((String)"2017-01-02/2017-01-03"), (Object)Intervals.of((String)"2017-01-03/2017-01-04"));
        Map locks = intervals.stream().collect(Collectors.toMap(Function.identity(), interval -> {
            TaskLock lock = this.tryTimeChunkLock(this.task, (Interval)interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }));
        Assert.assertEquals((long)3L, (long)locks.size());
        Assert.assertTrue((boolean)TaskLocks.isLockCoversSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    @Test
    public void testCheckSegmentLockCoversSegments() {
        Set<DataSegment> segments = this.createNumberedPartitionedSegments();
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        String version = DateTimes.nowUtc().toString();
        List locks = IntStream.range(0, 5).mapToObj(partitionId -> {
            TaskLock lock = this.trySegmentLock(this.task, interval, version, partitionId).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)locks.size());
        Assert.assertTrue((boolean)TaskLocks.isLockCoversSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    @Test
    public void testCheckLargeLockCoversSegments() {
        Set<DataSegment> segments = this.createTimeChunkedSegments();
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2017-01-01/2017-01-04"));
        Map locks = intervals.stream().collect(Collectors.toMap(Function.identity(), interval -> {
            TaskLock lock = this.tryTimeChunkLock(this.task, (Interval)interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }));
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertTrue((boolean)TaskLocks.isLockCoversSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    @Test
    public void testCheckLockCoversSegmentsWithOverlappedIntervals() {
        Set<DataSegment> segments = this.createTimeChunkedSegments();
        ImmutableList lockIntervals = ImmutableList.of((Object)Intervals.of((String)"2016-12-31/2017-01-01"), (Object)Intervals.of((String)"2017-01-01/2017-01-02"), (Object)Intervals.of((String)"2017-01-02/2017-01-03"));
        Map locks = lockIntervals.stream().collect(Collectors.toMap(Function.identity(), interval -> {
            TaskLock lock = this.tryTimeChunkLock(this.task, (Interval)interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }));
        Assert.assertEquals((long)3L, (long)locks.size());
        Assert.assertFalse((boolean)TaskLocks.isLockCoversSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    @Test
    public void testFindLocksForSegments() {
        Set<DataSegment> segments = this.createTimeChunkedSegments();
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2017-01-01/2017-01-02"), (Object)Intervals.of((String)"2017-01-02/2017-01-03"), (Object)Intervals.of((String)"2017-01-03/2017-01-04"));
        Map locks = intervals.stream().collect(Collectors.toMap(Function.identity(), interval -> {
            TaskLock lock = this.tryTimeChunkLock(this.task, (Interval)interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }));
        Assert.assertEquals((long)3L, (long)locks.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.newTimeChunkLock((Interval)intervals.get(0), locks.get(intervals.get(0)).getVersion()), (Object)this.newTimeChunkLock((Interval)intervals.get(1), locks.get(intervals.get(1)).getVersion()), (Object)this.newTimeChunkLock((Interval)intervals.get(2), locks.get(intervals.get(2)).getVersion())), (Object)TaskLocks.findLocksForSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    @Test
    public void testFindSegmentLocksForSegments() {
        Set<DataSegment> segments = this.createNumberedPartitionedSegments();
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        String version = DateTimes.nowUtc().toString();
        List locks = IntStream.range(0, 5).mapToObj(partitionId -> {
            TaskLock lock = this.trySegmentLock(this.task, interval, version, partitionId).getTaskLock();
            Assert.assertNotNull((Object)lock);
            return lock;
        }).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)locks.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.newSegmentLock(interval, ((TaskLock)locks.get(0)).getVersion(), 0), (Object)this.newSegmentLock(interval, ((TaskLock)locks.get(0)).getVersion(), 1), (Object)this.newSegmentLock(interval, ((TaskLock)locks.get(0)).getVersion(), 2), (Object)this.newSegmentLock(interval, ((TaskLock)locks.get(0)).getVersion(), 3), (Object)this.newSegmentLock(interval, ((TaskLock)locks.get(0)).getVersion(), 4)), (Object)TaskLocks.findLocksForSegments((Task)this.task, (TaskLockbox)this.lockbox, segments));
    }

    private TimeChunkLock newTimeChunkLock(Interval interval, String version) {
        return new TimeChunkLock(TaskLockType.EXCLUSIVE, this.task.getGroupId(), this.task.getDataSource(), interval, version, this.task.getPriority());
    }

    private SegmentLock newSegmentLock(Interval interval, String version, int partitionId) {
        return new SegmentLock(TaskLockType.EXCLUSIVE, this.task.getGroupId(), this.task.getDataSource(), interval, version, partitionId, this.task.getPriority());
    }
}

