/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompactionInputSpecTest {
    private static final String DATASOURCE = "datasource";
    private static final List<DataSegment> SEGMENTS = CompactionInputSpecTest.prepareSegments();
    private static Interval INTERVAL = JodaUtils.umbrellaInterval((Iterable)SEGMENTS.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
    private final CompactionInputSpec inputSpec;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new CompactionIntervalSpec(INTERVAL, SegmentUtils.hashIds(SEGMENTS))}, (Object)new Object[]{new SpecificSegmentsSpec(SEGMENTS.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList()))});
    }

    private static List<DataSegment> prepareSegments() {
        return IntStream.range(0, 20).mapToObj(i -> CompactionInputSpecTest.newSegment(Intervals.of((String)"2019-01-%02d/2019-01-%02d", (Object[])new Object[]{i + 1, i + 2}))).collect(Collectors.toList());
    }

    private static DataSegment newSegment(Interval interval) {
        return new DataSegment(DATASOURCE, interval, "version", null, null, null, null, Integer.valueOf(9), 10L);
    }

    public CompactionInputSpecTest(CompactionInputSpec inputSpec) {
        this.inputSpec = inputSpec;
    }

    @Test
    public void testFindInterval() {
        Assert.assertEquals((Object)INTERVAL, (Object)this.inputSpec.findInterval(DATASOURCE));
    }

    @Test
    public void testValidateSegments() {
        Assert.assertTrue((boolean)this.inputSpec.validateSegments(LockGranularity.TIME_CHUNK, SEGMENTS));
        Assert.assertTrue((boolean)this.inputSpec.validateSegments(LockGranularity.SEGMENT, SEGMENTS));
        Assert.assertFalse((boolean)this.inputSpec.validateSegments(LockGranularity.SEGMENT, SEGMENTS.subList(0, SEGMENTS.size() - 1)));
    }

    @Test
    public void testValidateWrongSegments() {
        ArrayList<DataSegment> someSegmentIsMissing = new ArrayList<DataSegment>(SEGMENTS);
        someSegmentIsMissing.remove(0);
        Assert.assertFalse((boolean)this.inputSpec.validateSegments(LockGranularity.TIME_CHUNK, someSegmentIsMissing));
        ArrayList<DataSegment> someSegmentIsUnknown = new ArrayList<DataSegment>(SEGMENTS);
        someSegmentIsUnknown.add(CompactionInputSpecTest.newSegment(Intervals.of((String)"2018-01-01/2018-01-02")));
        Assert.assertFalse((boolean)this.inputSpec.validateSegments(LockGranularity.TIME_CHUNK, someSegmentIsUnknown));
    }
}

