/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.apache.druid.guice.GuiceInjectableValues;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.IndexingServiceTuningConfigModule;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.NoopTestTaskReportFileWriter;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DoubleDimensionHandler;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CompactionTaskTest {
    private static final long SEGMENT_SIZE_BYTES = 100L;
    private static final int NUM_ROWS_PER_SEGMENT = 10;
    private static final String DATA_SOURCE = "dataSource";
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final String MIXED_TYPE_COLUMN = "string_to_double";
    private static final Interval COMPACTION_INTERVAL = Intervals.of((String)"2017-01-01/2017-07-01");
    private static final List<Interval> SEGMENT_INTERVALS = ImmutableList.of((Object)Intervals.of((String)"2017-01-01/2017-02-01"), (Object)Intervals.of((String)"2017-02-01/2017-03-01"), (Object)Intervals.of((String)"2017-03-01/2017-04-01"), (Object)Intervals.of((String)"2017-04-01/2017-05-01"), (Object)Intervals.of((String)"2017-05-01/2017-06-01"), (Object)Intervals.of((String)"2017-06-01/2017-07-01"), (Object)Intervals.of((String)"2017-06-01/2017-06-02"), (Object)Intervals.of((String)"2017-06-15/2017-06-16"), (Object)Intervals.of((String)"2017-06-30/2017-07-01"));
    private static final Map<Interval, DimensionSchema> MIXED_TYPE_COLUMN_MAP = new HashMap<Interval, DimensionSchema>();
    private static final CompactionTask.CompactionTuningConfig TUNING_CONFIG = CompactionTaskTest.createTuningConfig();
    private static final TestUtils TEST_UTILS = new TestUtils();
    private static final Map<DataSegment, File> SEGMENT_MAP = new HashMap<DataSegment, File>();
    private static final CoordinatorClient COORDINATOR_CLIENT = new TestCoordinatorClient(SEGMENT_MAP);
    private static final IndexingServiceClient INDEXING_SERVICE_CLIENT = new NoopIndexingServiceClient();
    private static final ObjectMapper OBJECT_MAPPER = CompactionTaskTest.setupInjectablesInObjectMapper((ObjectMapper)new DefaultObjectMapper());
    private static final RetryPolicyFactory RETRY_POLICY_FACTORY = new RetryPolicyFactory(new RetryPolicyConfig());
    private static final String CONFLICTING_SEGMENT_GRANULARITY_FORMAT = "Conflicting segment granularities found %s(segmentGranularity) and %s(granularitySpec.segmentGranularity).\nRemove `segmentGranularity` and set the `granularitySpec.segmentGranularity` to the expected granularity";
    private static Map<String, DimensionSchema> DIMENSIONS;
    private static List<AggregatorFactory> AGGREGATORS;
    private static List<DataSegment> SEGMENTS;
    private TaskToolbox toolbox;
    private SegmentCacheManagerFactory segmentCacheManagerFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setupClass() {
        StringDimensionSchema schema;
        int i;
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-01-01/2017-02-01"), (DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-02-01/2017-03-01"), (DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-03-01/2017-04-01"), (DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-04-01/2017-05-01"), (DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-05-01/2017-06-01"), (DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-06-01/2017-07-01"), (DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-06-01/2017-06-02"), (DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-06-15/2017-06-16"), (DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN));
        MIXED_TYPE_COLUMN_MAP.put(Intervals.of((String)"2017-06-30/2017-07-01"), (DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN));
        DIMENSIONS = new HashMap<String, DimensionSchema>();
        AGGREGATORS = new ArrayList<AggregatorFactory>();
        DIMENSIONS.put("__time", (DimensionSchema)new LongDimensionSchema("__time"));
        DIMENSIONS.put(TIMESTAMP_COLUMN, (DimensionSchema)new LongDimensionSchema(TIMESTAMP_COLUMN));
        int numUmbrellaIntervals = 6;
        for (i = 0; i < numUmbrellaIntervals; ++i) {
            schema = new StringDimensionSchema("string_dim_" + i, null, null);
            DIMENSIONS.put(schema.getName(), (DimensionSchema)schema);
        }
        for (i = 0; i < numUmbrellaIntervals; ++i) {
            schema = new LongDimensionSchema("long_dim_" + i);
            DIMENSIONS.put(schema.getName(), (DimensionSchema)schema);
        }
        for (i = 0; i < numUmbrellaIntervals; ++i) {
            schema = new FloatDimensionSchema("float_dim_" + i);
            DIMENSIONS.put(schema.getName(), (DimensionSchema)schema);
        }
        for (i = 0; i < numUmbrellaIntervals; ++i) {
            schema = new DoubleDimensionSchema("double_dim_" + i);
            DIMENSIONS.put(schema.getName(), (DimensionSchema)schema);
        }
        AGGREGATORS.add((AggregatorFactory)new CountAggregatorFactory("agg_0"));
        AGGREGATORS.add((AggregatorFactory)new LongSumAggregatorFactory("agg_1", "long_dim_1"));
        AGGREGATORS.add((AggregatorFactory)new LongMaxAggregatorFactory("agg_2", "long_dim_2"));
        AGGREGATORS.add((AggregatorFactory)new FloatFirstAggregatorFactory("agg_3", "float_dim_3", null));
        AGGREGATORS.add((AggregatorFactory)new DoubleLastAggregatorFactory("agg_4", "double_dim_4", null));
        for (i = 0; i < SEGMENT_INTERVALS.size(); ++i) {
            SEGMENT_MAP.put(new DataSegment(DATA_SOURCE, SEGMENT_INTERVALS.get(i), "version_" + i, (Map)ImmutableMap.of(), CompactionTaskTest.findDimensions(i, SEGMENT_INTERVALS.get(i)), AGGREGATORS.stream().map(AggregatorFactory::getName).collect(Collectors.toList()), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(0), 100L), new File("file_" + i));
        }
        SEGMENTS = new ArrayList<DataSegment>(SEGMENT_MAP.keySet());
    }

    private static ObjectMapper setupInjectablesInObjectMapper(ObjectMapper objectMapper) {
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        objectMapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, objectMapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, objectMapper.getDeserializationConfig().getAnnotationIntrospector()));
        GuiceInjectableValues injectableValues = new GuiceInjectableValues(GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
            binder.bind(ChatHandlerProvider.class).toInstance((Object)new NoopChatHandlerProvider());
            binder.bind(RowIngestionMetersFactory.class).toInstance((Object)TEST_UTILS.getRowIngestionMetersFactory());
            binder.bind(CoordinatorClient.class).toInstance((Object)COORDINATOR_CLIENT);
            binder.bind(SegmentCacheManagerFactory.class).toInstance((Object)new SegmentCacheManagerFactory(objectMapper));
            binder.bind(AppenderatorsManager.class).toInstance((Object)new TestAppenderatorsManager());
            binder.bind(IndexingServiceClient.class).toInstance((Object)INDEXING_SERVICE_CLIENT);
        })));
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        objectMapper.registerModule((Module)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(NumberedShardSpec.class, "NumberedShardSpec")}));
        objectMapper.registerModules((Iterable)new IndexingServiceTuningConfigModule().getJacksonModules());
        return objectMapper;
    }

    private static List<String> findDimensions(int startIndex, Interval segmentInterval) {
        ArrayList<String> dimensions = new ArrayList<String>();
        dimensions.add(TIMESTAMP_COLUMN);
        for (int i = 0; i < 6; ++i) {
            int postfix = i + startIndex;
            dimensions.add("string_dim_" + (postfix %= 6));
            dimensions.add("long_dim_" + postfix);
            dimensions.add("float_dim_" + postfix);
            dimensions.add("double_dim_" + postfix);
        }
        dimensions.add(MIXED_TYPE_COLUMN_MAP.get(segmentInterval).getName());
        return dimensions;
    }

    private static CompactionTask.CompactionTuningConfig createTuningConfig() {
        return new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Before
    public void setup() {
        TestIndexIO testIndexIO = new TestIndexIO(OBJECT_MAPPER, SEGMENT_MAP);
        this.toolbox = new TestTaskToolbox(new TestTaskActionClient(new ArrayList<DataSegment>(SEGMENT_MAP.keySet())), testIndexIO, SEGMENT_MAP);
        this.segmentCacheManagerFactory = new SegmentCacheManagerFactory(OBJECT_MAPPER);
    }

    @Test
    public void testCreateCompactionTaskWithGranularitySpec() {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.segmentGranularity(Granularities.HOUR);
        CompactionTask taskCreatedWithSegmentGranularity = builder.build();
        CompactionTask.Builder builder2 = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder2.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder2.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder2.granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.HOUR, Granularities.DAY, null));
        CompactionTask taskCreatedWithGranularitySpec = builder2.build();
        Assert.assertEquals((Object)taskCreatedWithGranularitySpec.getSegmentGranularity(), (Object)taskCreatedWithSegmentGranularity.getSegmentGranularity());
    }

    @Test(expected=IAE.class)
    public void testCreateCompactionTaskWithConflictingGranularitySpecAndSegmentGranularityShouldThrowIAE() {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.segmentGranularity(Granularities.HOUR);
        builder.granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.MINUTE, Granularities.DAY, null));
        try {
            builder.build();
        }
        catch (IAE iae) {
            Assert.assertEquals((Object)StringUtils.format((String)CONFLICTING_SEGMENT_GRANULARITY_FORMAT, (Object[])new Object[]{Granularities.HOUR, Granularities.MINUTE}), (Object)iae.getMessage());
            throw iae;
        }
        Assert.fail((String)"Should not have reached here!");
    }

    @Test
    public void testCreateCompactionTaskWithTransformSpec() {
        ClientCompactionTaskTransformSpec transformSpec = new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null));
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.transformSpec(transformSpec);
        CompactionTask taskCreatedWithTransformSpec = builder.build();
        Assert.assertEquals((Object)transformSpec, (Object)taskCreatedWithTransformSpec.getTransformSpec());
    }

    @Test
    public void testCreateCompactionTaskWithMetricsSpec() {
        Object[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("cnt")};
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.metricsSpec((AggregatorFactory[])aggregatorFactories);
        CompactionTask taskCreatedWithTransformSpec = builder.build();
        Assert.assertArrayEquals((Object[])aggregatorFactories, (Object[])taskCreatedWithTransformSpec.getMetricsSpec());
    }

    @Test(expected=IAE.class)
    public void testCreateCompactionTaskWithNullSegmentGranularityInGranularitySpecAndSegmentGranularityShouldSucceed() {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.segmentGranularity(Granularities.HOUR);
        builder.granularitySpec(new ClientCompactionTaskGranularitySpec(null, Granularities.DAY, null));
        try {
            builder.build();
        }
        catch (IAE iae) {
            Assert.assertEquals((Object)StringUtils.format((String)CONFLICTING_SEGMENT_GRANULARITY_FORMAT, (Object[])new Object[]{Granularities.HOUR, null}), (Object)iae.getMessage());
            throw iae;
        }
        Assert.fail((String)"Should not have reached here!");
    }

    @Test
    public void testCreateCompactionTaskWithSameGranularitySpecAndSegmentGranularityShouldSucceed() {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS)));
        builder.tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig());
        builder.segmentGranularity(Granularities.HOUR);
        builder.granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.HOUR, Granularities.DAY, null));
        CompactionTask taskCreatedWithSegmentGranularity = builder.build();
        Assert.assertEquals((Object)Granularities.HOUR, (Object)taskCreatedWithSegmentGranularity.getSegmentGranularity());
    }

    @Test
    public void testSerdeWithInterval() throws IOException {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask task = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, SegmentUtils.hashIds(SEGMENTS))).tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig()).context((Map)ImmutableMap.of((Object)"testKey", (Object)"testContext")).build();
        byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)task);
        CompactionTask fromJson = (CompactionTask)OBJECT_MAPPER.readValue(bytes, CompactionTask.class);
        CompactionTaskTest.assertEquals(task, fromJson);
    }

    @Test
    public void testSerdeWithSegments() throws IOException {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask task = builder.segments(SEGMENTS).tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig()).context((Map)ImmutableMap.of((Object)"testKey", (Object)"testContext")).build();
        byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)task);
        CompactionTask fromJson = (CompactionTask)OBJECT_MAPPER.readValue(bytes, CompactionTask.class);
        CompactionTaskTest.assertEquals(task, fromJson);
    }

    @Test
    public void testSerdeWithDimensions() throws IOException {
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask task = builder.segments(SEGMENTS).dimensionsSpec(new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dim1"), (Object)new StringDimensionSchema("dim2"), (Object)new StringDimensionSchema("dim3")))).tuningConfig((TuningConfig)CompactionTaskTest.createTuningConfig()).context((Map)ImmutableMap.of((Object)"testKey", (Object)"testVal")).build();
        byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)task);
        CompactionTask fromJson = (CompactionTask)OBJECT_MAPPER.readValue(bytes, CompactionTask.class);
        CompactionTaskTest.assertEquals(task, fromJson);
    }

    @Test
    public void testSerdeWithOldTuningConfigSuccessfullyDeserializeToNewOne() throws IOException {
        OldCompactionTaskWithAnyTuningConfigType oldTask = new OldCompactionTaskWithAnyTuningConfigType(null, null, DATA_SOURCE, null, SEGMENTS, null, null, null, null, null, (TuningConfig)new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null), null, this.toolbox.getJsonMapper(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, this.toolbox.getChatHandlerProvider(), this.toolbox.getRowIngestionMetersFactory(), COORDINATOR_CLIENT, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY, this.toolbox.getAppenderatorsManager());
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask expectedFromJson = builder.segments(SEGMENTS).tuningConfig((TuningConfig)CompactionTask.getTuningConfig((TuningConfig)oldTask.getTuningConfig())).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper((DefaultObjectMapper)OBJECT_MAPPER);
        mapper.registerSubtypes(new NamedType[]{new NamedType(OldCompactionTaskWithAnyTuningConfigType.class, "compact")});
        byte[] bytes = mapper.writeValueAsBytes((Object)oldTask);
        CompactionTask fromJson = (CompactionTask)mapper.readValue(bytes, CompactionTask.class);
        CompactionTaskTest.assertEquals(expectedFromJson, fromJson);
    }

    @Test
    public void testGetTuningConfigWithIndexTuningConfig() {
        IndexTask.IndexTuningConfig indexTuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, null, null, null, null, null, null);
        CompactionTask.CompactionTuningConfig compactionTuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        Assert.assertEquals((Object)compactionTuningConfig, (Object)CompactionTask.getTuningConfig((TuningConfig)indexTuningConfig));
    }

    @Test
    public void testGetTuningConfigWithParallelIndexTuningConfig() {
        ParallelIndexTuningConfig parallelIndexTuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        CompactionTask.CompactionTuningConfig compactionTuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        Assert.assertEquals((Object)compactionTuningConfig, (Object)CompactionTask.getTuningConfig((TuningConfig)parallelIndexTuningConfig));
    }

    @Test
    public void testSerdeWithUnknownTuningConfigThrowingError() throws IOException {
        OldCompactionTaskWithAnyTuningConfigType taskWithUnknownTuningConfig = new OldCompactionTaskWithAnyTuningConfigType(null, null, DATA_SOURCE, null, SEGMENTS, null, null, null, null, null, (TuningConfig)RealtimeTuningConfig.makeDefaultTuningConfig(null), null, OBJECT_MAPPER, AuthTestUtils.TEST_AUTHORIZER_MAPPER, null, this.toolbox.getRowIngestionMetersFactory(), COORDINATOR_CLIENT, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY, this.toolbox.getAppenderatorsManager());
        DefaultObjectMapper mapper = new DefaultObjectMapper((DefaultObjectMapper)OBJECT_MAPPER);
        mapper.registerSubtypes(new NamedType[]{new NamedType(OldCompactionTaskWithAnyTuningConfigType.class, "compact"), new NamedType(RealtimeTuningConfig.class, "realtime")});
        byte[] bytes = mapper.writeValueAsBytes((Object)taskWithUnknownTuningConfig);
        this.expectedException.expect(ValueInstantiationException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("Unknown tuningConfig type: [org.apache.druid.segment.indexing.RealtimeTuningConfig]");
        mapper.readValue(bytes, CompactionTask.class);
    }

    private static void assertEquals(CompactionTask expected, CompactionTask actual) {
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((Object)expected.getDataSource(), (Object)actual.getDataSource());
        Assert.assertEquals((Object)expected.getIoConfig(), (Object)actual.getIoConfig());
        Assert.assertEquals((Object)expected.getDimensionsSpec(), (Object)actual.getDimensionsSpec());
        Assert.assertArrayEquals((Object[])expected.getMetricsSpec(), (Object[])actual.getMetricsSpec());
        Assert.assertEquals((Object)expected.getTuningConfig(), (Object)actual.getTuningConfig());
        Assert.assertEquals((Object)expected.getContext(), (Object)actual.getContext());
    }

    @Test
    public void testSegmentProviderFindSegmentsWithEmptySegmentsThrowException() {
        CompactionTask.SegmentProvider provider = new CompactionTask.SegmentProvider("datasource", (CompactionInputSpec)new CompactionIntervalSpec(Intervals.of((String)"2021-01-01/P1D"), null));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("No segments found for compaction. Please check that datasource name and interval are correct.");
        provider.checkSegments(LockGranularity.TIME_CHUNK, (List)ImmutableList.of());
    }

    @Test
    public void testCreateIngestionSchema() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithTargetPartitionSize() throws IOException, SegmentLoadingException {
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(Integer.valueOf(100000), null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, null, Integer.valueOf(10), null, null, null, null, null, null, null, null, null, null, null);
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(tuningConfig), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, tuningConfig, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithMaxTotalRows() throws IOException, SegmentLoadingException {
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, Long.valueOf(1000000L), null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(false), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(tuningConfig), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, tuningConfig, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithNumShards() throws IOException, SegmentLoadingException {
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, Integer.valueOf(10), null, null, null, null, null, null, null, null, null, null, null);
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(tuningConfig), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, tuningConfig, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithCustomDimensionsSpec() throws IOException, SegmentLoadingException {
        DimensionsSpec customSpec = new DimensionsSpec((List)Lists.newArrayList((Object[])new DimensionSchema[]{new LongDimensionSchema(TIMESTAMP_COLUMN), new StringDimensionSchema("string_dim_0"), new StringDimensionSchema("string_dim_1"), new StringDimensionSchema("string_dim_2"), new StringDimensionSchema("string_dim_3"), new StringDimensionSchema("string_dim_4"), new LongDimensionSchema("long_dim_0"), new LongDimensionSchema("long_dim_1"), new LongDimensionSchema("long_dim_2"), new LongDimensionSchema("long_dim_3"), new LongDimensionSchema("long_dim_4"), new FloatDimensionSchema("float_dim_0"), new FloatDimensionSchema("float_dim_1"), new FloatDimensionSchema("float_dim_2"), new FloatDimensionSchema("float_dim_3"), new FloatDimensionSchema("float_dim_4"), new DoubleDimensionSchema("double_dim_0"), new DoubleDimensionSchema("double_dim_1"), new DoubleDimensionSchema("double_dim_2"), new DoubleDimensionSchema("double_dim_3"), new DoubleDimensionSchema("double_dim_4"), new StringDimensionSchema(MIXED_TYPE_COLUMN)}));
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), (DimensionsSpec)customSpec, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        ArrayList<DimensionsSpec> dimensionsSpecs = new ArrayList<DimensionsSpec>(6);
        IntStream.range(0, 6).forEach(i -> dimensionsSpecs.add(customSpec));
        this.assertIngestionSchema(ingestionSpecs, dimensionsSpecs, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithCustomMetricsSpec() throws IOException, SegmentLoadingException {
        AggregatorFactory[] customMetricsSpec = new AggregatorFactory[]{new CountAggregatorFactory("custom_count"), new LongSumAggregatorFactory("custom_long_sum", "agg_1"), new FloatMinAggregatorFactory("custom_float_min", "agg_3"), new DoubleMaxAggregatorFactory("custom_double_max", "agg_4")};
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, (AggregatorFactory[])customMetricsSpec, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, Arrays.asList(customMetricsSpec), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithCustomSegments() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)SpecificSegmentsSpec.fromSegments(SEGMENTS)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testCreateIngestionSchemaWithDifferentSegmentSet() throws IOException, SegmentLoadingException {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"are different from the current used segments"));
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(SEGMENTS);
        Collections.sort(segments);
        segments.remove(segments.size() / 2);
        CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)SpecificSegmentsSpec.fromSegments(segments)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
    }

    @Test
    public void testMissingMetadata() throws IOException, SegmentLoadingException {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage(CoreMatchers.startsWith((String)"Index metadata doesn't exist for segment"));
        TestIndexIO indexIO = (TestIndexIO)this.toolbox.getIndexIO();
        indexIO.removeMetadata((File)Iterables.getFirst(indexIO.getQueryableIndexMap().keySet(), null));
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(SEGMENTS);
        CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)SpecificSegmentsSpec.fromSegments(segments)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
    }

    @Test
    public void testEmptyInterval() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"must specify a nonempty interval"));
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.segmentCacheManagerFactory, RETRY_POLICY_FACTORY);
        CompactionTask task = builder.interval(Intervals.of((String)"2000-01-01/2000-01-01")).build();
    }

    @Test
    public void testSegmentGranularityAndNullQueryGranularity() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec((Granularity)new PeriodGranularity(Period.months((int)3), null, null), null, null), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        ImmutableList expectedDimensionsSpec = ImmutableList.of((Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN))));
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)1L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, (List<DimensionsSpec>)expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), Collections.singletonList(COMPACTION_INTERVAL), (Granularity)new PeriodGranularity(Period.months((int)3), null, null), Granularities.NONE, false);
    }

    @Test
    public void testQueryGranularityAndNullSegmentGranularity() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec(null, (Granularity)new PeriodGranularity(Period.months((int)3), null, null), null), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, (Granularity)new PeriodGranularity(Period.months((int)3), null, null), false);
    }

    @Test
    public void testQueryGranularityAndSegmentGranularityNonNull() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec((Granularity)new PeriodGranularity(Period.months((int)3), null, null), (Granularity)new PeriodGranularity(Period.months((int)3), null, null), null), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        ImmutableList expectedDimensionsSpec = ImmutableList.of((Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN))));
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)1L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, (List<DimensionsSpec>)expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), Collections.singletonList(COMPACTION_INTERVAL), (Granularity)new PeriodGranularity(Period.months((int)3), null, null), (Granularity)new PeriodGranularity(Period.months((int)3), null, null), false);
    }

    @Test
    public void testNullGranularitySpec() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, null, (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testGranularitySpecWithNullQueryGranularityAndNullSegmentGranularity() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec(null, null, null), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        List<DimensionsSpec> expectedDimensionsSpec = CompactionTaskTest.getExpectedDimensionsSpecForAutoGeneration();
        ingestionSpecs.sort((s1, s2) -> Comparators.intervalsByStartThenEnd().compare(s1.getDataSchema().getGranularitySpec().inputIntervals().get(0), s2.getDataSchema().getGranularitySpec().inputIntervals().get(0)));
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        this.assertIngestionSchema(ingestionSpecs, expectedDimensionsSpec, AGGREGATORS.stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList()), SEGMENT_INTERVALS, Granularities.MONTH, Granularities.NONE, false);
    }

    @Test
    public void testGranularitySpecWithNotNullRollup() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec(null, null, Boolean.valueOf(true)), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        for (ParallelIndexIngestionSpec indexIngestionSpec : ingestionSpecs) {
            Assert.assertTrue((boolean)indexIngestionSpec.getDataSchema().getGranularitySpec().isRollup());
        }
    }

    @Test
    public void testGranularitySpecWithNullRollup() throws IOException, SegmentLoadingException {
        List ingestionSpecs = CompactionTask.createIngestionSchema((TaskToolbox)this.toolbox, (LockGranularity)LockGranularity.TIME_CHUNK, (CompactionTask.SegmentProvider)new CompactionTask.SegmentProvider(DATA_SOURCE, (CompactionInputSpec)new CompactionIntervalSpec(COMPACTION_INTERVAL, null)), (CompactionTask.PartitionConfigurationManager)new CompactionTask.PartitionConfigurationManager(TUNING_CONFIG), null, null, null, (ClientCompactionTaskGranularitySpec)new ClientCompactionTaskGranularitySpec(null, null, null), (CoordinatorClient)COORDINATOR_CLIENT, (SegmentCacheManagerFactory)this.segmentCacheManagerFactory, (RetryPolicyFactory)RETRY_POLICY_FACTORY, (boolean)false);
        Assert.assertEquals((long)6L, (long)ingestionSpecs.size());
        for (ParallelIndexIngestionSpec indexIngestionSpec : ingestionSpecs) {
            Assert.assertFalse((boolean)indexIngestionSpec.getDataSchema().getGranularitySpec().isRollup());
        }
    }

    @Test
    public void testChooseFinestGranularityWithNulls() {
        List<Granularity> input = Arrays.asList(Granularities.DAY, Granularities.SECOND, Granularities.MINUTE, Granularities.SIX_HOUR, Granularities.DAY, null, Granularities.ALL, Granularities.MINUTE);
        Assert.assertTrue((boolean)Granularities.SECOND.equals(this.chooseFinestGranularityHelper(input)));
    }

    @Test
    public void testChooseFinestGranularityNone() {
        ImmutableList input = ImmutableList.of((Object)Granularities.DAY, (Object)Granularities.SECOND, (Object)Granularities.MINUTE, (Object)Granularities.SIX_HOUR, (Object)Granularities.NONE, (Object)Granularities.DAY, (Object)Granularities.NONE, (Object)Granularities.MINUTE);
        Assert.assertTrue((boolean)Granularities.NONE.equals(this.chooseFinestGranularityHelper((List<Granularity>)input)));
    }

    @Test
    public void testChooseFinestGranularityAllNulls() {
        List<Granularity> input = Arrays.asList(null, null, null, null);
        Assert.assertNull((Object)this.chooseFinestGranularityHelper(input));
    }

    @Test
    public void testCreateDimensionSchema() {
        String dimensionName = "dim";
        DimensionHandlerUtils.registerDimensionHandlerProvider((String)"extension-double", d -> new ExtensionDimensionHandler(d));
        DimensionSchema stringSchema = CompactionTask.createDimensionSchema((String)"dim", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesUnique(true), (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
        Assert.assertTrue((boolean)(stringSchema instanceof StringDimensionSchema));
        DimensionSchema floatSchema = CompactionTask.createDimensionSchema((String)"dim", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT), null);
        Assert.assertTrue((boolean)(floatSchema instanceof FloatDimensionSchema));
        DimensionSchema doubleSchema = CompactionTask.createDimensionSchema((String)"dim", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE), null);
        Assert.assertTrue((boolean)(doubleSchema instanceof DoubleDimensionSchema));
        DimensionSchema longSchema = CompactionTask.createDimensionSchema((String)"dim", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG), null);
        Assert.assertTrue((boolean)(longSchema instanceof LongDimensionSchema));
        DimensionSchema extensionSchema = CompactionTask.createDimensionSchema((String)"dim", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.ofComplex((String)"extension-double")), null);
        Assert.assertTrue((boolean)(extensionSchema instanceof ExtensionDimensionSchema));
    }

    @Test
    public void testCreateDimensionSchemaIllegalFloat() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("multi-value dimension [foo] is not supported for float type yet");
        CompactionTask.createDimensionSchema((String)"foo", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT), (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
    }

    @Test
    public void testCreateDimensionSchemaIllegalDouble() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("multi-value dimension [foo] is not supported for double type yet");
        CompactionTask.createDimensionSchema((String)"foo", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE), (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
    }

    @Test
    public void testCreateDimensionSchemaIllegalLong() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("multi-value dimension [foo] is not supported for long type yet");
        CompactionTask.createDimensionSchema((String)"foo", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG), (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
    }

    @Test
    public void testCreateDimensionSchemaIllegalComplex() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Can't find DimensionHandlerProvider for typeName [unknown]");
        CompactionTask.createDimensionSchema((String)"foo", (ColumnCapabilities)ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.ofComplex((String)"unknown")), (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
    }

    private Granularity chooseFinestGranularityHelper(List<Granularity> granularities) {
        SettableSupplier queryGranularity = new SettableSupplier();
        for (Granularity current : granularities) {
            queryGranularity.set((Object)CompactionTask.compareWithCurrent((Granularity)((Granularity)queryGranularity.get()), (Granularity)current));
        }
        return (Granularity)queryGranularity.get();
    }

    private static List<DimensionsSpec> getExpectedDimensionsSpecForAutoGeneration() {
        return ImmutableList.of((Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN))), (Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN))), (Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN))), (Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new StringDimensionSchema(MIXED_TYPE_COLUMN))), (Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN))), (Object)new DimensionsSpec(CompactionTaskTest.getDimensionSchema((DimensionSchema)new DoubleDimensionSchema(MIXED_TYPE_COLUMN))));
    }

    private static List<DimensionSchema> getDimensionSchema(DimensionSchema mixedTypeColumn) {
        return Lists.newArrayList((Object[])new DimensionSchema[]{new LongDimensionSchema(TIMESTAMP_COLUMN), new StringDimensionSchema("string_dim_4"), new LongDimensionSchema("long_dim_4"), new FloatDimensionSchema("float_dim_4"), new DoubleDimensionSchema("double_dim_4"), new StringDimensionSchema("string_dim_0"), new LongDimensionSchema("long_dim_0"), new FloatDimensionSchema("float_dim_0"), new DoubleDimensionSchema("double_dim_0"), new StringDimensionSchema("string_dim_1"), new LongDimensionSchema("long_dim_1"), new FloatDimensionSchema("float_dim_1"), new DoubleDimensionSchema("double_dim_1"), new StringDimensionSchema("string_dim_2"), new LongDimensionSchema("long_dim_2"), new FloatDimensionSchema("float_dim_2"), new DoubleDimensionSchema("double_dim_2"), new StringDimensionSchema("string_dim_3"), new LongDimensionSchema("long_dim_3"), new FloatDimensionSchema("float_dim_3"), new DoubleDimensionSchema("double_dim_3"), new StringDimensionSchema("string_dim_5"), new LongDimensionSchema("long_dim_5"), new FloatDimensionSchema("float_dim_5"), new DoubleDimensionSchema("double_dim_5"), mixedTypeColumn});
    }

    private void assertIngestionSchema(List<ParallelIndexIngestionSpec> ingestionSchemas, List<DimensionsSpec> expectedDimensionsSpecs, List<AggregatorFactory> expectedMetricsSpec, List<Interval> expectedSegmentIntervals, Granularity expectedSegmentGranularity, Granularity expectedQueryGranularity, boolean expectedDropExisting) {
        this.assertIngestionSchema(ingestionSchemas, expectedDimensionsSpecs, expectedMetricsSpec, expectedSegmentIntervals, new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(500000), Long.valueOf(1000000L), null, Long.valueOf(Long.MAX_VALUE), null, null, (PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(5000000), null, null), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), Boolean.valueOf(false), Long.valueOf(5000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null), expectedSegmentGranularity, expectedQueryGranularity, expectedDropExisting);
    }

    private void assertIngestionSchema(List<ParallelIndexIngestionSpec> ingestionSchemas, List<DimensionsSpec> expectedDimensionsSpecs, List<AggregatorFactory> expectedMetricsSpec, List<Interval> expectedSegmentIntervals, CompactionTask.CompactionTuningConfig expectedTuningConfig, Granularity expectedSegmentGranularity, Granularity expectedQueryGranularity, boolean expectedDropExisting) {
        Preconditions.checkArgument((ingestionSchemas.size() == expectedDimensionsSpecs.size() ? 1 : 0) != 0, (String)"ingesionSchemas.size()[%s] should be same with expectedDimensionsSpecs.size()[%s]", (Object[])new Object[]{ingestionSchemas.size(), expectedDimensionsSpecs.size()});
        for (int i = 0; i < ingestionSchemas.size(); ++i) {
            ParallelIndexIngestionSpec ingestionSchema = ingestionSchemas.get(i);
            DimensionsSpec expectedDimensionsSpec = expectedDimensionsSpecs.get(i);
            DataSchema dataSchema = ingestionSchema.getDataSchema();
            Assert.assertEquals((Object)DATA_SOURCE, (Object)dataSchema.getDataSource());
            Assert.assertEquals((Object)new TimestampSpec("__time", "millis", null), (Object)dataSchema.getTimestampSpec());
            Assert.assertEquals(new HashSet(expectedDimensionsSpec.getDimensions()), new HashSet(dataSchema.getDimensionsSpec().getDimensions()));
            Assert.assertEquals(expectedMetricsSpec, Arrays.asList(dataSchema.getAggregators()));
            Assert.assertEquals((Object)new UniformGranularitySpec(expectedSegmentGranularity, expectedQueryGranularity, Boolean.valueOf(false), Collections.singletonList(expectedSegmentIntervals.get(i))), (Object)dataSchema.getGranularitySpec());
            ParallelIndexIOConfig ioConfig = ingestionSchema.getIOConfig();
            Assert.assertFalse((boolean)ioConfig.isAppendToExisting());
            Assert.assertEquals((Object)expectedDropExisting, (Object)ioConfig.isDropExisting());
            InputSource inputSource = ioConfig.getInputSource();
            Assert.assertTrue((boolean)(inputSource instanceof DruidInputSource));
            DruidInputSource druidInputSource = (DruidInputSource)inputSource;
            Assert.assertEquals((Object)DATA_SOURCE, (Object)druidInputSource.getDataSource());
            Assert.assertEquals((Object)expectedSegmentIntervals.get(i), (Object)druidInputSource.getInterval());
            Assert.assertNull((Object)druidInputSource.getDimFilter());
            Assert.assertEquals((Object)expectedTuningConfig, (Object)ingestionSchema.getTuningConfig());
        }
    }

    private static ColumnHolder createColumn(DimensionSchema dimensionSchema) {
        return new TestColumn(dimensionSchema.getColumnType());
    }

    private static ColumnHolder createColumn(AggregatorFactory aggregatorFactory) {
        return new TestColumn(aggregatorFactory.getIntermediateType());
    }

    private static class ExtensionDimensionSchema
    extends DimensionSchema {
        protected ExtensionDimensionSchema(String name, DimensionSchema.MultiValueHandling multiValueHandling, boolean createBitmapIndex) {
            super(name, multiValueHandling, createBitmapIndex);
        }

        public String getTypeName() {
            return "extension-double";
        }

        public ColumnType getColumnType() {
            return ColumnType.ofComplex((String)"extension-double");
        }
    }

    private static class ExtensionDimensionHandler
    extends DoubleDimensionHandler {
        private static final String TYPE_NAME = "extension-double";

        public ExtensionDimensionHandler(String dimensionName) {
            super(dimensionName);
        }

        public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
            return new ExtensionDimensionSchema(this.getDimensionName(), this.getMultivalueHandling(), capabilities.hasBitmapIndexes());
        }
    }

    private static class OldCompactionTaskWithAnyTuningConfigType
    extends AbstractTask {
        private final Interval interval;
        private final List<DataSegment> segments;
        @Nullable
        private final DimensionsSpec dimensionsSpec;
        @Nullable
        private final AggregatorFactory[] metricsSpec;
        @Nullable
        private final Granularity segmentGranularity;
        @Nullable
        private final Long targetCompactionSizeBytes;
        @Nullable
        private final TuningConfig tuningConfig;

        @JsonCreator
        public OldCompactionTaskWithAnyTuningConfigType(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Nullable Interval interval, @JsonProperty(value="segments") @Nullable List<DataSegment> segments, @JsonProperty(value="dimensions") @Nullable DimensionsSpec dimensions, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") @Nullable AggregatorFactory[] metricsSpec, @JsonProperty(value="segmentGranularity") @Nullable Granularity segmentGranularity, @JsonProperty(value="targetCompactionSizeBytes") @Nullable Long targetCompactionSizeBytes, @JsonProperty(value="tuningConfig") @Nullable TuningConfig tuningConfig, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JacksonInject ObjectMapper jsonMapper, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject CoordinatorClient coordinatorClient, @JacksonInject SegmentCacheManagerFactory segmentCacheManagerFactory, @JacksonInject RetryPolicyFactory retryPolicyFactory, @JacksonInject AppenderatorsManager appenderatorsManager) {
            super(OldCompactionTaskWithAnyTuningConfigType.getOrMakeId((String)id, (String)"compact", (String)dataSource), null, taskResource, dataSource, context);
            this.interval = interval;
            this.segments = segments;
            this.dimensionsSpec = dimensionsSpec;
            this.metricsSpec = metricsSpec;
            this.segmentGranularity = segmentGranularity;
            this.targetCompactionSizeBytes = targetCompactionSizeBytes;
            this.tuningConfig = tuningConfig;
        }

        public String getType() {
            return "compact";
        }

        @JsonProperty
        public Interval getInterval() {
            return this.interval;
        }

        @JsonProperty
        public List<DataSegment> getSegments() {
            return this.segments;
        }

        @JsonProperty
        @Nullable
        public DimensionsSpec getDimensionsSpec() {
            return this.dimensionsSpec;
        }

        @JsonProperty
        @Nullable
        public AggregatorFactory[] getMetricsSpec() {
            return this.metricsSpec;
        }

        @JsonProperty
        @Nullable
        public Granularity getSegmentGranularity() {
            return this.segmentGranularity;
        }

        @Nullable
        @JsonProperty
        public Long getTargetCompactionSizeBytes() {
            return this.targetCompactionSizeBytes;
        }

        @Nullable
        @JsonProperty
        public TuningConfig getTuningConfig() {
            return this.tuningConfig;
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            throw new UnsupportedOperationException();
        }

        public void stopGracefully(TaskConfig taskConfig) {
            throw new UnsupportedOperationException();
        }

        public TaskStatus run(TaskToolbox toolbox) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestColumn
    implements ColumnHolder {
        private final ColumnCapabilities columnCapabilities;

        TestColumn(ColumnType type) {
            this.columnCapabilities = new ColumnCapabilitiesImpl().setType(type).setDictionaryEncoded(type.is((TypeDescriptor)ValueType.STRING)).setHasBitmapIndexes(type.is((TypeDescriptor)ValueType.STRING)).setHasSpatialIndexes(false).setHasMultipleValues(false);
        }

        public ColumnCapabilities getCapabilities() {
            return this.columnCapabilities;
        }

        public int getLength() {
            return 10;
        }

        public BaseColumn getColumn() {
            return null;
        }

        public SettableColumnValueSelector<?> makeNewSettableColumnValueSelector() {
            return null;
        }

        public BitmapIndex getBitmapIndex() {
            return null;
        }

        public SpatialIndex getSpatialIndex() {
            return null;
        }
    }

    private static class TestIndexIO
    extends IndexIO {
        private final Map<File, QueryableIndex> queryableIndexMap;

        TestIndexIO(ObjectMapper mapper, Map<DataSegment, File> segmentFileMap) {
            super(mapper, () -> 0);
            this.queryableIndexMap = Maps.newHashMapWithExpectedSize((int)segmentFileMap.size());
            for (Map.Entry<DataSegment, File> entry : segmentFileMap.entrySet()) {
                DataSegment segment = entry.getKey();
                ArrayList<String> columnNames = new ArrayList<String>(segment.getDimensions().size() + segment.getMetrics().size());
                columnNames.add("__time");
                columnNames.addAll(segment.getDimensions());
                columnNames.addAll(segment.getMetrics());
                HashMap columnMap = Maps.newHashMapWithExpectedSize((int)columnNames.size());
                ArrayList<AggregatorFactory> aggregatorFactories = new ArrayList<AggregatorFactory>(segment.getMetrics().size());
                for (String columnName : columnNames) {
                    ColumnHolder columnHolder;
                    if (CompactionTaskTest.MIXED_TYPE_COLUMN.equals(columnName)) {
                        columnHolder = CompactionTaskTest.createColumn((DimensionSchema)MIXED_TYPE_COLUMN_MAP.get(segment.getInterval()));
                        columnMap.put(columnName, () -> columnHolder);
                        continue;
                    }
                    if (DIMENSIONS.containsKey(columnName)) {
                        columnHolder = CompactionTaskTest.createColumn((DimensionSchema)DIMENSIONS.get(columnName));
                        columnMap.put(columnName, () -> columnHolder);
                        continue;
                    }
                    Optional<AggregatorFactory> maybeMetric = AGGREGATORS.stream().filter(agg -> agg.getName().equals(columnName)).findAny();
                    if (!maybeMetric.isPresent()) continue;
                    ColumnHolder columnHolder2 = CompactionTaskTest.createColumn(maybeMetric.get());
                    columnMap.put(columnName, () -> columnHolder2);
                    aggregatorFactories.add(maybeMetric.get());
                }
                Metadata metadata = new Metadata(null, aggregatorFactories.toArray(new AggregatorFactory[0]), null, null, null);
                this.queryableIndexMap.put(entry.getValue(), (QueryableIndex)new SimpleQueryableIndex(segment.getInterval(), (Indexed)new ListIndexed(segment.getDimensions()), null, (Map)columnMap, null, metadata, false));
            }
        }

        public QueryableIndex loadIndex(File file) {
            return this.queryableIndexMap.get(file);
        }

        void removeMetadata(File file) {
            SimpleQueryableIndex index = (SimpleQueryableIndex)this.queryableIndexMap.get(file);
            if (index != null) {
                this.queryableIndexMap.put(file, (QueryableIndex)new SimpleQueryableIndex(index.getDataInterval(), index.getColumnNames(), index.getAvailableDimensions(), index.getBitmapFactoryForDimensions(), index.getColumns(), index.getFileMapper(), null, () -> index.getDimensionHandlers()));
            }
        }

        Map<File, QueryableIndex> getQueryableIndexMap() {
            return this.queryableIndexMap;
        }
    }

    private static class TestTaskActionClient
    implements TaskActionClient {
        private final List<DataSegment> segments;

        TestTaskActionClient(List<DataSegment> segments) {
            this.segments = segments;
        }

        public <RetType> RetType submit(TaskAction<RetType> taskAction) {
            if (!(taskAction instanceof RetrieveUsedSegmentsAction)) {
                throw new ISE("action[%s] is not supported", new Object[]{taskAction});
            }
            return (RetType)this.segments;
        }
    }

    private static class TestTaskToolbox
    extends TaskToolbox {
        private final Map<DataSegment, File> segmentFileMap;

        TestTaskToolbox(TaskActionClient taskActionClient, IndexIO indexIO, Map<DataSegment, File> segmentFileMap) {
            super(new TaskConfig(null, null, null, null, null, false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), null, taskActionClient, null, null, null, null, null, null, null, null, null, null, (JoinableFactory)NoopJoinableFactory.INSTANCE, null, null, null, null, indexIO, null, null, null, new IndexMergerV9(OBJECT_MAPPER, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), true), null, null, null, null, (TaskReportFileWriter)new NoopTestTaskReportFileWriter(), null, AuthTestUtils.TEST_AUTHORIZER_MAPPER, (ChatHandlerProvider)new NoopChatHandlerProvider(), TEST_UTILS.getRowIngestionMetersFactory(), (AppenderatorsManager)new TestAppenderatorsManager(), INDEXING_SERVICE_CLIENT, COORDINATOR_CLIENT, null, null);
            this.segmentFileMap = segmentFileMap;
        }

        public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) {
            HashMap submap = Maps.newHashMapWithExpectedSize((int)segments.size());
            for (DataSegment segment : segments) {
                File file = (File)Preconditions.checkNotNull((Object)this.segmentFileMap.get(segment));
                submap.put(segment, file);
            }
            return submap;
        }
    }

    private static class TestCoordinatorClient
    extends CoordinatorClient {
        private final Map<DataSegment, File> segmentMap;

        TestCoordinatorClient(Map<DataSegment, File> segmentMap) {
            super(null, null);
            this.segmentMap = segmentMap;
        }

        public Collection<DataSegment> fetchUsedSegmentsInDataSourceForIntervals(String dataSource, List<Interval> intervals) {
            return ImmutableSet.copyOf(this.segmentMap.keySet());
        }
    }
}

