/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilteringCloseableInputRowIteratorTest {
    private static final List<String> DIMENSIONS = ImmutableList.of((Object)"dim1", (Object)"dim2");
    private static final List<InputRow> ROWS = ImmutableList.of((Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 10, 200), (Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 10, 400), (Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 20, 400), (Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 10, 800), (Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 30, 200), (Object)FilteringCloseableInputRowIteratorTest.newRow(DateTimes.of((String)"2020-01-01"), 10, 300));
    private RowIngestionMeters rowIngestionMeters;
    private ParseExceptionHandler parseExceptionHandler;

    @Before
    public void setup() {
        this.rowIngestionMeters = new SimpleRowIngestionMeters();
        this.parseExceptionHandler = new ParseExceptionHandler(this.rowIngestionMeters, false, Integer.MAX_VALUE, 1024);
    }

    @Test
    public void testFilterOutRows() {
        Predicate<InputRow> filter = row -> (Integer)row.getRaw("dim1") == 10;
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator(CloseableIterators.withEmptyBaggage(ROWS.iterator()), filter, this.rowIngestionMeters, this.parseExceptionHandler);
        ArrayList filteredRows = new ArrayList();
        rowIterator.forEachRemaining(filteredRows::add);
        Assert.assertEquals(ROWS.stream().filter(filter).collect(Collectors.toList()), filteredRows);
        Assert.assertEquals((long)2L, (long)this.rowIngestionMeters.getThrownAway());
    }

    @Test
    public void testParseExceptionInDelegateNext() {
        CloseableIterator<InputRow> parseExceptionThrowingIterator = new CloseableIterator<InputRow>(){
            final int numRowsToIterate = FilteringCloseableInputRowIteratorTest.access$000().size() * 2;
            int nextIdx = 0;

            public boolean hasNext() {
                return this.nextIdx < this.numRowsToIterate;
            }

            public InputRow next() {
                int currentIdx;
                if ((currentIdx = this.nextIdx++) % 2 == 0) {
                    return (InputRow)ROWS.get(currentIdx / 2);
                }
                throw new ParseException(null, "Parse exception at ", new Object[]{currentIdx});
            }

            public void close() {
            }
        };
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator((CloseableIterator)parseExceptionThrowingIterator, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        ArrayList filteredRows = new ArrayList();
        rowIterator.forEachRemaining(filteredRows::add);
        Assert.assertEquals(ROWS, filteredRows);
        Assert.assertEquals((long)ROWS.size(), (long)this.rowIngestionMeters.getUnparseable());
    }

    @Test
    public void testParseExceptionInPredicateTest() {
        CloseableIterator parseExceptionThrowingIterator = CloseableIterators.withEmptyBaggage(ROWS.iterator());
        Predicate<InputRow> filter = new Predicate<InputRow>(){
            boolean throwParseException = false;

            @Override
            public boolean test(InputRow inputRow) {
                if (this.throwParseException) {
                    this.throwParseException = false;
                    throw new ParseException(null, "test", new Object[0]);
                }
                this.throwParseException = true;
                return true;
            }
        };
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator(parseExceptionThrowingIterator, (Predicate)filter, this.rowIngestionMeters, this.parseExceptionHandler);
        ArrayList filteredRows = new ArrayList();
        rowIterator.forEachRemaining(filteredRows::add);
        ImmutableList expectedRows = ImmutableList.of((Object)ROWS.get(0), (Object)ROWS.get(2), (Object)ROWS.get(4));
        Assert.assertEquals((Object)expectedRows, filteredRows);
        Assert.assertEquals((long)(ROWS.size() - expectedRows.size()), (long)this.rowIngestionMeters.getUnparseable());
    }

    @Test
    public void testParseExceptionInDelegateHasNext() {
        CloseableIterator<InputRow> parseExceptionThrowingIterator = new CloseableIterator<InputRow>(){
            final int numRowsToIterate = FilteringCloseableInputRowIteratorTest.access$000().size() * 2;
            int currentIndex = 0;
            int nextIndex = 0;

            public boolean hasNext() {
                this.currentIndex = this.nextIndex++;
                if (this.currentIndex % 2 == 0) {
                    return this.currentIndex < this.numRowsToIterate;
                }
                throw new ParseException(null, "Parse exception at ", new Object[]{this.currentIndex});
            }

            public InputRow next() {
                return (InputRow)ROWS.get(this.currentIndex / 2);
            }

            public void close() {
            }
        };
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator((CloseableIterator)parseExceptionThrowingIterator, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        ArrayList filteredRows = new ArrayList();
        rowIterator.forEachRemaining(filteredRows::add);
        Assert.assertEquals(ROWS, filteredRows);
        Assert.assertEquals((long)ROWS.size(), (long)this.rowIngestionMeters.getUnparseable());
    }

    @Test(expected=RuntimeException.class)
    public void testNonParseExceptionInDelegateHasNext() {
        CloseableIterator<InputRow> parseExceptionThrowingIterator = new CloseableIterator<InputRow>(){
            final int numRowsToIterate = FilteringCloseableInputRowIteratorTest.access$000().size() * 2;
            int currentIndex = 0;
            int nextIndex = 0;

            public boolean hasNext() {
                this.currentIndex = this.nextIndex++;
                if (this.currentIndex % 2 == 0) {
                    return this.currentIndex < this.numRowsToIterate;
                }
                throw new RuntimeException("should explode");
            }

            public InputRow next() {
                return (InputRow)ROWS.get(this.currentIndex / 2);
            }

            public void close() {
            }
        };
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator((CloseableIterator)parseExceptionThrowingIterator, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        while (rowIterator.hasNext()) {
            rowIterator.next();
        }
        Assert.fail((String)"you never should have come here");
    }

    @Test
    public void testCloseDelegateIsClosed() throws IOException {
        MutableBoolean closed = new MutableBoolean(false);
        CloseableIterator delegate = CloseableIterators.wrap(Collections.emptyIterator(), () -> ((MutableBoolean)closed).setTrue());
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator(delegate, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        rowIterator.close();
        Assert.assertTrue((boolean)closed.isTrue());
    }

    private static InputRow newRow(DateTime timestamp, Object dim1Val, Object dim2Val) {
        return new MapBasedInputRow(timestamp, DIMENSIONS, (Map)ImmutableMap.of((Object)"dim1", (Object)dim1Val, (Object)"dim2", (Object)dim2Val));
    }
}

