/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.HadoopTask;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.JvmUtils;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopTaskTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBuildClassLoader() throws Exception {
        HadoopTask task = new HadoopTask("taskId", "dataSource", (List)ImmutableList.of(), (Map)ImmutableMap.of()){

            public String getType() {
                return null;
            }

            public boolean isReady(TaskActionClient taskActionClient) {
                return false;
            }

            public void stopGracefully(TaskConfig taskConfig) {
            }

            public boolean requireLockExistingSegments() {
                return true;
            }

            public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) {
                return Collections.emptyList();
            }

            public boolean isPerfectRollup() {
                return true;
            }

            @Nullable
            public Granularity getSegmentGranularity() {
                return null;
            }

            public TaskStatus runTask(TaskToolbox toolbox) {
                return null;
            }
        };
        TaskToolbox toolbox = (TaskToolbox)EasyMock.createStrictMock(TaskToolbox.class);
        EasyMock.expect((Object)toolbox.getConfig()).andReturn((Object)new TaskConfig(this.temporaryFolder.newFolder().toString(), null, null, null, (List)ImmutableList.of((Object)"something:hadoop:1"), false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null)).once();
        EasyMock.replay((Object[])new Object[]{toolbox});
        ClassLoader classLoader = task.buildClassLoader(toolbox);
        HadoopTaskTest.assertClassLoaderIsSingular(classLoader);
        Class<?> hadoopClazz = Class.forName("org.apache.hadoop.fs.FSDataInputStream", false, classLoader);
        HadoopTaskTest.assertClassLoaderIsSingular(hadoopClazz.getClassLoader());
        Class<?> druidHadoopConfigClazz = Class.forName("org.apache.druid.indexer.HadoopDruidIndexerConfig", false, classLoader);
        HadoopTaskTest.assertClassLoaderIsSingular(druidHadoopConfigClazz.getClassLoader());
    }

    public static void assertClassLoaderIsSingular(ClassLoader classLoader) {
        if (JvmUtils.isIsJava9Compatible()) {
            Assert.assertEquals((Object)"PlatformClassLoader", (Object)classLoader.getParent().getClass().getSimpleName());
        } else {
            Assert.assertNull((Object)classLoader.getParent());
        }
        Assert.assertFalse((boolean)classLoader.getClass().getSimpleName().equals("ApplicationClassLoader"));
        Assert.assertTrue((boolean)(classLoader instanceof URLClassLoader));
        ClassLoader appLoader = HadoopDruidIndexerConfig.class.getClassLoader();
        Assert.assertNotEquals((String)StringUtils.format((String)"ClassLoader [%s] is not isolated!", (Object[])new Object[]{classLoader}), (Object)appLoader, (Object)classLoader);
    }
}

