/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.handoff.SegmentHandoffNotifier;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.LocalFirehoseFactory;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.segment.realtime.plumber.NoopSegmentHandoffNotifierFactory;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexTaskTest
extends IngestionTestBase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String DATASOURCE = "test";
    private static final TimestampSpec DEFAULT_TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DEFAULT_DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim")));
    private static final ParseSpec DEFAULT_PARSE_SPEC = new CSVParseSpec(DEFAULT_TIMESTAMP_SPEC, DEFAULT_DIMENSIONS_SPEC, null, Arrays.asList("ts", "dim", "val"), false, 0);
    private static final InputFormat DEFAULT_INPUT_FORMAT = new CsvInputFormat(Arrays.asList("ts", "dim", "val"), null, null, Boolean.valueOf(false), 0);
    private static final IndexSpec INDEX_SPEC = new IndexSpec();
    private final ObjectMapper jsonMapper = this.getObjectMapper();
    private final IndexIO indexIO = this.getIndexIO();
    private final RowIngestionMetersFactory rowIngestionMetersFactory = this.getRowIngestionMetersFactory();
    private final LockGranularity lockGranularity;
    private final boolean useInputFormatApi;
    private AppenderatorsManager appenderatorsManager;
    private SegmentCacheManager segmentCacheManager;
    private IngestionTestBase.TestTaskRunner taskRunner;

    @Parameterized.Parameters(name="{0}, useInputFormatApi={1}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.TIME_CHUNK, false}, (Object)new Object[]{LockGranularity.TIME_CHUNK, true}, (Object)new Object[]{LockGranularity.SEGMENT, true});
    }

    public IndexTaskTest(LockGranularity lockGranularity, boolean useInputFormatApi) {
        this.lockGranularity = lockGranularity;
        this.useInputFormatApi = useInputFormatApi;
    }

    @Before
    public void setup() throws IOException {
        this.appenderatorsManager = new TestAppenderatorsManager();
        final File cacheDir = this.temporaryFolder.newFolder();
        this.segmentCacheManager = new SegmentLocalCacheManager(new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(cacheDir, null, null));
            }
        }, this.jsonMapper);
        this.taskRunner = new IngestionTestBase.TestTaskRunner(this);
    }

    @Test
    public void testIngestNullOnlyColumns() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,,\n");
            writer.write("2014-01-01T01:00:20Z,,\n");
            writer.write("2014-01-01T02:00:30Z,,\n");
        }
        IndexTask indexTask = new IndexTask(null, null, new IndexTask.IndexIngestionSpec(new DataSchema("test-json", DEFAULT_TIMESTAMP_SPEC, new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("ts"), (Object)new StringDimensionSchema("dim"), (Object)new LongDimensionSchema("valDim"))), new AggregatorFactory[]{new LongSumAggregatorFactory("valMet", "val")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014/P1D"))), null), new IndexTask.IndexIOConfig(null, (InputSource)new LocalInputSource(tmpDir, "druid*"), DEFAULT_INPUT_FORMAT, Boolean.valueOf(false), Boolean.valueOf(false)), IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true)), null);
        Assert.assertFalse((boolean)indexTask.supportsQueries());
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"ts", (Object)"dim", (Object)"valDim"), (Object)((DataSegment)segments.get(0)).getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"valMet"), (Object)((DataSegment)segments.get(0)).getMetrics());
    }

    @Test
    public void testIngestNullOnlyColumns_storeEmptyColumnsOff_shouldNotStoreEmptyColumns() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,,\n");
            writer.write("2014-01-01T01:00:20Z,,\n");
            writer.write("2014-01-01T02:00:30Z,,\n");
        }
        IndexTask indexTask = new IndexTask(null, null, new IndexTask.IndexIngestionSpec(new DataSchema("test-json", DEFAULT_TIMESTAMP_SPEC, new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("ts"), (Object)new StringDimensionSchema("dim"), (Object)new LongDimensionSchema("valDim"))), new AggregatorFactory[]{new LongSumAggregatorFactory("valMet", "val")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014/P1D"))), null), new IndexTask.IndexIOConfig(null, (InputSource)new LocalInputSource(tmpDir, "druid*"), DEFAULT_INPUT_FORMAT, Boolean.valueOf(false), Boolean.valueOf(false)), IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true)), (Map)ImmutableMap.of((Object)"storeEmptyColumns", (Object)false));
        Assert.assertFalse((boolean)indexTask.supportsQueries());
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"ts", (Object)"valDim"), (Object)((DataSegment)segments.get(0)).getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"valMet"), (Object)((DataSegment)segments.get(0)).getMetrics());
    }

    @Test
    public void testDeterminePartitions() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        Assert.assertFalse((boolean)indexTask.supportsQueries());
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)2L, (long)segments.size());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
        Assert.assertEquals((long)2L, (long)((DataSegment)segments.get(0)).getShardSpec().getNumCorePartitions());
        Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)((HashBasedNumberedShardSpec)((DataSegment)segments.get(0)).getShardSpec()).getPartitionFunction());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(1)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(1)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(1)).getShardSpec().getClass());
        Assert.assertEquals((long)1L, (long)((DataSegment)segments.get(1)).getShardSpec().getPartitionNum());
        Assert.assertEquals((long)2L, (long)((DataSegment)segments.get(1)).getShardSpec().getNumCorePartitions());
        Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)((HashBasedNumberedShardSpec)((DataSegment)segments.get(1)).getShardSpec()).getPartitionFunction());
    }

    @Test
    public void testTransformSpec() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,an|array,1|2|3,1\n");
            writer.write("2014-01-01T01:00:20Z,b,another|array,3|4,1\n");
            writer.write("2014-01-01T02:00:30Z,c,and|another,0|1,1\n");
        }
        DimensionsSpec dimensionsSpec = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim", "dim_array", "dim_num_array", "dimt", "dimtarray1", "dimtarray2", "dimtnum_array")));
        List<String> columns = Arrays.asList("ts", "dim", "dim_array", "dim_num_array", "val");
        String listDelimiter = "|";
        TransformSpec transformSpec = new TransformSpec((DimFilter)new SelectorDimFilter("dim", "b", null), (List)ImmutableList.of((Object)new ExpressionTransform("dimt", "concat(dim,dim)", ExprMacroTable.nil()), (Object)new ExpressionTransform("dimtarray1", "array(dim, dim)", ExprMacroTable.nil()), (Object)new ExpressionTransform("dimtarray2", "map(d -> concat(d, 'foo'), dim_array)", ExprMacroTable.nil()), (Object)new ExpressionTransform("dimtnum_array", "map(d -> d + 3, dim_num_array)", ExprMacroTable.nil())));
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, false);
        IndexTask.IndexIngestionSpec indexIngestionSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, DEFAULT_TIMESTAMP_SPEC, dimensionsSpec, (InputFormat)new CsvInputFormat(columns, "|", null, Boolean.valueOf(false), 0), transformSpec, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(DEFAULT_TIMESTAMP_SPEC, dimensionsSpec, "|", columns, false, 0), transformSpec, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, indexIngestionSpec, null);
        Assert.assertEquals((Object)indexTask.getId(), (Object)indexTask.getGroupId());
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        DataSegment segment = (DataSegment)segments.get(0);
        File segmentFile = this.segmentCacheManager.getSegmentFiles(segment);
        WindowedStorageAdapter adapter = new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(this.indexIO.loadIndex(segmentFile)), segment.getInterval());
        Sequence cursorSequence = adapter.getAdapter().makeCursors(null, segment.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        List transforms = cursorSequence.map(cursor -> {
            DimensionSelector selector1 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dimt", "dimt"));
            DimensionSelector selector2 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dimtarray1", "dimtarray1"));
            DimensionSelector selector3 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dimtarray2", "dimtarray2"));
            DimensionSelector selector4 = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dimtnum_array", "dimtnum_array"));
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("dimt", selector1.defaultGetObject());
            row.put("dimtarray1", selector2.defaultGetObject());
            row.put("dimtarray2", selector3.defaultGetObject());
            row.put("dimtnum_array", selector4.defaultGetObject());
            cursor.advance();
            return row;
        }).toList();
        Assert.assertEquals((long)1L, (long)transforms.size());
        Assert.assertEquals((Object)"bb", ((Map)transforms.get(0)).get("dimt"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"b", (Object)"b"), ((Map)transforms.get(0)).get("dimtarray1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"anotherfoo", (Object)"arrayfoo"), ((Map)transforms.get(0)).get("dimtarray2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"6.0", (Object)"7.0"), ((Map)transforms.get(0)).get("dimtnum_array"));
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(NumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
    }

    @Test
    public void testWithArbitraryGranularity() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
    }

    @Test
    public void testIntervalBucketing() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T07:59:59.977Z,a,1\n");
            writer.write("2014-01-01T08:00:00.000Z,b,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.HOUR, Collections.singletonList(Intervals.of((String)"2014-01-01T08:00:00Z/2014-01-01T09:00:00Z"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(50, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
    }

    @Test
    public void testNumShardsProvided() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithPartitionsSpec((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(1), null), true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
        Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)((HashBasedNumberedShardSpec)((DataSegment)segments.get(0)).getShardSpec()).getPartitionFunction());
    }

    @Test
    public void testNumShardsAndHashPartitionFunctionProvided() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithPartitionsSpec((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(1), null, HashPartitionFunction.MURMUR3_32_ABS), true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
        Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)((HashBasedNumberedShardSpec)((DataSegment)segments.get(0)).getShardSpec()).getPartitionFunction());
    }

    @Test
    public void testNumShardsAndPartitionDimensionsProvided() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithPartitionsSpec((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(2), (List)ImmutableList.of((Object)"dim")), true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)2L, (long)segments.size());
        for (DataSegment segment : segments) {
            Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
            Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)segment.getInterval());
            Assert.assertEquals(HashBasedNumberedShardSpec.class, segment.getShardSpec().getClass());
            HashBasedNumberedShardSpec hashBasedNumberedShardSpec = (HashBasedNumberedShardSpec)segment.getShardSpec();
            Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)hashBasedNumberedShardSpec.getPartitionFunction());
            File segmentFile = this.segmentCacheManager.getSegmentFiles(segment);
            WindowedStorageAdapter adapter = new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(this.indexIO.loadIndex(segmentFile)), segment.getInterval());
            Sequence cursorSequence = adapter.getAdapter().makeCursors(null, segment.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            List hashes = cursorSequence.map(cursor -> {
                DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("dim", "dim"));
                int hash = HashPartitionFunction.MURMUR3_32_ABS.hash(HashBasedNumberedShardSpec.serializeGroupKey((ObjectMapper)this.jsonMapper, Collections.singletonList(selector.getObject())), hashBasedNumberedShardSpec.getNumBuckets());
                cursor.advance();
                return hash;
            }).toList();
            Assert.assertTrue((boolean)hashes.stream().allMatch(h -> h.intValue() == ((Integer)hashes.get(0)).intValue()));
        }
    }

    @Test
    public void testWriteNewSegmentsWithAppendToExistingWithLinearPartitioningSuccessfullyAppend() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, false), true, false), null);
        Assert.assertEquals((Object)"index_append_test", (Object)indexTask.getGroupId());
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)2L, (long)this.taskRunner.getTaskActionClient().getActionCount(SegmentAllocateAction.class));
        Assert.assertEquals((long)2L, (long)segments.size());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(NumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(1)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(1)).getInterval());
        Assert.assertEquals(NumberedShardSpec.class, ((DataSegment)segments.get(1)).getShardSpec().getClass());
        Assert.assertEquals((long)1L, (long)((DataSegment)segments.get(1)).getShardSpec().getPartitionNum());
    }

    @Test
    public void testIntervalNotSpecified() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(0)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T00/PT1H"), (Object)((DataSegment)segments.get(0)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(0)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(0)).getShardSpec().getPartitionNum());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(1)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T01/PT1H"), (Object)((DataSegment)segments.get(1)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(1)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(1)).getShardSpec().getPartitionNum());
        Assert.assertEquals((Object)DATASOURCE, (Object)((DataSegment)segments.get(2)).getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2014-01-01T02/PT1H"), (Object)((DataSegment)segments.get(2)).getInterval());
        Assert.assertEquals(HashBasedNumberedShardSpec.class, ((DataSegment)segments.get(2)).getShardSpec().getClass());
        Assert.assertEquals((long)0L, (long)((DataSegment)segments.get(2)).getShardSpec().getPartitionNum());
    }

    @Test
    public void testIntervalNotSpecifiedWithReplace() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("GranularitySpec's intervals cannot be empty when setting dropExisting to true.");
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, true), null);
    }

    @Test
    public void testCSVFileWithHeader() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,d,val\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true);
        IndexTask.IndexIngestionSpec ingestionSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, DimensionsSpec.EMPTY, null, null, true, 0), null, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(null, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals(Collections.singletonList("d"), (Object)((DataSegment)segments.get(0)).getDimensions());
        Assert.assertEquals(Collections.singletonList("val"), (Object)((DataSegment)segments.get(0)).getMetrics());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
    }

    @Test
    public void testCSVFileWithHeaderColumnOverride() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,d,val\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        List<String> columns = Arrays.asList("time", "dim", "val");
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true);
        IndexTask.IndexIngestionSpec ingestionSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, DimensionsSpec.EMPTY, null, columns, true, 0), null, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals(Collections.singletonList("d"), (Object)((DataSegment)segments.get(0)).getDimensions());
        Assert.assertEquals(Collections.singletonList("val"), (Object)((DataSegment)segments.get(0)).getMetrics());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
    }

    @Test
    public void testWithSmallMaxTotalRows() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T00:00:10Z,b,2\n");
            writer.write("2014-01-01T00:00:10Z,c,3\n");
            writer.write("2014-01-01T01:00:20Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,2\n");
            writer.write("2014-01-01T01:00:20Z,c,3\n");
            writer.write("2014-01-01T02:00:30Z,a,1\n");
            writer.write("2014-01-01T02:00:30Z,b,2\n");
            writer.write("2014-01-01T02:00:30Z,c,3\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfig(2, 2, null, 2L, null, false, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)6L, (long)segments.size());
        for (int i = 0; i < 6; ++i) {
            DataSegment segment = (DataSegment)segments.get(i);
            Interval expectedInterval = Intervals.of((String)StringUtils.format((String)"2014-01-01T0%d/PT1H", (Object[])new Object[]{i / 2}));
            int expectedPartitionNum = i % 2;
            Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
            Assert.assertEquals((Object)expectedInterval, (Object)segment.getInterval());
            Assert.assertEquals(NumberedShardSpec.class, segment.getShardSpec().getClass());
            Assert.assertEquals((long)expectedPartitionNum, (long)segment.getShardSpec().getPartitionNum());
        }
    }

    @Test
    public void testPerfectRollup() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        IndexTaskTest.populateRollupTestData(tmpFile);
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.DAY, Boolean.valueOf(true), null), null, IndexTaskTest.createTuningConfig(3, 2, null, 2L, null, true, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        for (int i = 0; i < 3; ++i) {
            DataSegment segment = (DataSegment)segments.get(i);
            Interval expectedInterval = Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z");
            Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
            Assert.assertEquals((Object)expectedInterval, (Object)segment.getInterval());
            Assert.assertTrue((boolean)segment.getShardSpec().getClass().equals(HashBasedNumberedShardSpec.class));
            Assert.assertEquals((long)i, (long)segment.getShardSpec().getPartitionNum());
        }
    }

    @Test
    public void testBestEffortRollup() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        IndexTaskTest.populateRollupTestData(tmpFile);
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.DAY, Boolean.valueOf(true), null), null, IndexTaskTest.createTuningConfig(3, 2, null, 2L, null, false, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)5L, (long)segments.size());
        Interval expectedInterval = Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z");
        for (int i = 0; i < 5; ++i) {
            DataSegment segment = (DataSegment)segments.get(i);
            Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
            Assert.assertEquals((Object)expectedInterval, (Object)segment.getInterval());
            Assert.assertEquals(NumberedShardSpec.class, segment.getShardSpec().getClass());
            Assert.assertEquals((long)i, (long)segment.getShardSpec().getPartitionNum());
        }
    }

    @Test
    public void testWaitForSegmentAvailabilityNoSegments() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        TaskToolbox mockToolbox = (TaskToolbox)EasyMock.createMock(TaskToolbox.class);
        ArrayList segmentsToWaitFor = new ArrayList();
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        EasyMock.replay((Object[])new Object[]{mockToolbox});
        Assert.assertTrue((boolean)indexTask.waitForSegmentAvailability(mockToolbox, segmentsToWaitFor, 1000L));
        EasyMock.verify((Object[])new Object[]{mockToolbox});
    }

    @Test
    public void testWaitForSegmentAvailabilityInvalidWaitTimeout() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        TaskToolbox mockToolbox = (TaskToolbox)EasyMock.createMock(TaskToolbox.class);
        ArrayList<Object> segmentsToWaitFor = new ArrayList<Object>();
        segmentsToWaitFor.add(EasyMock.createMock(DataSegment.class));
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        EasyMock.replay((Object[])new Object[]{mockToolbox});
        Assert.assertFalse((boolean)indexTask.waitForSegmentAvailability(mockToolbox, segmentsToWaitFor, -1L));
        EasyMock.verify((Object[])new Object[]{mockToolbox});
    }

    @Test
    public void testWaitForSegmentAvailabilityMultipleSegmentsTimeout() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        TaskToolbox mockToolbox = (TaskToolbox)EasyMock.createMock(TaskToolbox.class);
        SegmentHandoffNotifierFactory mockFactory = (SegmentHandoffNotifierFactory)EasyMock.createMock(SegmentHandoffNotifierFactory.class);
        SegmentHandoffNotifier mockNotifier = (SegmentHandoffNotifier)EasyMock.createMock(SegmentHandoffNotifier.class);
        DataSegment mockDataSegment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DataSegment mockDataSegment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        ArrayList<DataSegment> segmentsToWaitFor = new ArrayList<DataSegment>();
        segmentsToWaitFor.add(mockDataSegment1);
        segmentsToWaitFor.add(mockDataSegment2);
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        EasyMock.expect((Object)mockDataSegment1.getInterval()).andReturn((Object)Intervals.of((String)"1970-01-01/2100-01-01")).once();
        EasyMock.expect((Object)mockDataSegment1.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment1.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockDataSegment2.getInterval()).andReturn((Object)Intervals.of((String)"1970-01-01/2100-01-01")).once();
        EasyMock.expect((Object)mockDataSegment2.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment2.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockToolbox.getSegmentHandoffNotifierFactory()).andReturn((Object)mockFactory).once();
        EasyMock.expect((Object)mockToolbox.getEmitter()).andReturn((Object)new NoopServiceEmitter()).anyTimes();
        EasyMock.expect((Object)mockDataSegment1.getDataSource()).andReturn((Object)"MockDataSource").once();
        EasyMock.expect((Object)mockFactory.createSegmentHandoffNotifier("MockDataSource")).andReturn((Object)mockNotifier).once();
        mockNotifier.start();
        EasyMock.expectLastCall().once();
        mockNotifier.registerSegmentHandoffCallback((SegmentDescriptor)EasyMock.anyObject(), (Executor)EasyMock.anyObject(), (Runnable)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn((Object)true).times(2);
        mockNotifier.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{mockToolbox});
        EasyMock.replay((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
        EasyMock.replay((Object[])new Object[]{mockFactory, mockNotifier});
        Assert.assertFalse((boolean)indexTask.waitForSegmentAvailability(mockToolbox, segmentsToWaitFor, 1000L));
        EasyMock.verify((Object[])new Object[]{mockToolbox});
        EasyMock.verify((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
        EasyMock.verify((Object[])new Object[]{mockFactory, mockNotifier});
    }

    @Test
    public void testWaitForSegmentAvailabilityMultipleSegmentsSuccess() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder();
        TaskToolbox mockToolbox = (TaskToolbox)EasyMock.createMock(TaskToolbox.class);
        DataSegment mockDataSegment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DataSegment mockDataSegment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        ArrayList<DataSegment> segmentsToWaitFor = new ArrayList<DataSegment>();
        segmentsToWaitFor.add(mockDataSegment1);
        segmentsToWaitFor.add(mockDataSegment2);
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        EasyMock.expect((Object)mockDataSegment1.getInterval()).andReturn((Object)Intervals.of((String)"1970-01-01/1971-01-01")).once();
        EasyMock.expect((Object)mockDataSegment1.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment1.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockDataSegment1.getId()).andReturn((Object)SegmentId.dummy((String)"MockDataSource")).once();
        EasyMock.expect((Object)mockDataSegment2.getInterval()).andReturn((Object)Intervals.of((String)"1971-01-01/1972-01-01")).once();
        EasyMock.expect((Object)mockDataSegment2.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment2.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockDataSegment2.getId()).andReturn((Object)SegmentId.dummy((String)"MockDataSource")).once();
        EasyMock.expect((Object)mockToolbox.getSegmentHandoffNotifierFactory()).andReturn((Object)new NoopSegmentHandoffNotifierFactory()).once();
        EasyMock.expect((Object)mockToolbox.getEmitter()).andReturn((Object)new NoopServiceEmitter()).anyTimes();
        EasyMock.expect((Object)mockDataSegment1.getDataSource()).andReturn((Object)"MockDataSource").once();
        EasyMock.replay((Object[])new Object[]{mockToolbox});
        EasyMock.replay((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
        Assert.assertTrue((boolean)indexTask.waitForSegmentAvailability(mockToolbox, segmentsToWaitFor, 30000L));
        EasyMock.verify((Object[])new Object[]{mockToolbox});
        EasyMock.verify((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
    }

    @Test
    public void testWaitForSegmentAvailabilityEmitsExpectedMetric() throws IOException, InterruptedException {
        File tmpDir = this.temporaryFolder.newFolder();
        LatchableServiceEmitter latchEmitter = new LatchableServiceEmitter();
        latchEmitter.latch = new CountDownLatch(1);
        TaskToolbox mockToolbox = (TaskToolbox)EasyMock.createMock(TaskToolbox.class);
        DataSegment mockDataSegment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DataSegment mockDataSegment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        ArrayList<DataSegment> segmentsToWaitFor = new ArrayList<DataSegment>();
        segmentsToWaitFor.add(mockDataSegment1);
        segmentsToWaitFor.add(mockDataSegment2);
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(2, true), false, false), null);
        EasyMock.expect((Object)mockDataSegment1.getInterval()).andReturn((Object)Intervals.of((String)"1970-01-01/1971-01-01")).once();
        EasyMock.expect((Object)mockDataSegment1.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment1.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockDataSegment1.getId()).andReturn((Object)SegmentId.dummy((String)"MockDataSource")).once();
        EasyMock.expect((Object)mockDataSegment2.getInterval()).andReturn((Object)Intervals.of((String)"1971-01-01/1972-01-01")).once();
        EasyMock.expect((Object)mockDataSegment2.getVersion()).andReturn((Object)"dummyString").once();
        EasyMock.expect((Object)mockDataSegment2.getShardSpec()).andReturn(EasyMock.createMock(ShardSpec.class)).once();
        EasyMock.expect((Object)mockDataSegment2.getId()).andReturn((Object)SegmentId.dummy((String)"MockDataSource")).once();
        EasyMock.expect((Object)mockToolbox.getSegmentHandoffNotifierFactory()).andReturn((Object)new NoopSegmentHandoffNotifierFactory()).once();
        EasyMock.expect((Object)mockToolbox.getEmitter()).andReturn((Object)latchEmitter).anyTimes();
        EasyMock.expect((Object)mockDataSegment1.getDataSource()).andReturn((Object)"MockDataSource").once();
        EasyMock.replay((Object[])new Object[]{mockToolbox});
        EasyMock.replay((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
        Assert.assertTrue((boolean)indexTask.waitForSegmentAvailability(mockToolbox, segmentsToWaitFor, 30000L));
        latchEmitter.latch.await(300000L, TimeUnit.MILLISECONDS);
        EasyMock.verify((Object[])new Object[]{mockToolbox});
        EasyMock.verify((Object[])new Object[]{mockDataSegment1, mockDataSegment2});
    }

    private static void populateRollupTestData(File tmpFile) throws IOException {
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,a,1\n");
            writer.write("2014-01-01T00:00:10Z,b,2\n");
            writer.write("2014-01-01T00:00:10Z,c,3\n");
            writer.write("2014-01-01T01:00:20Z,b,2\n");
            writer.write("2014-01-01T02:00:30Z,a,1\n");
            writer.write("2014-01-01T02:00:30Z,b,2\n");
            writer.write("2014-01-01T01:00:20Z,c,3\n");
            writer.write("2014-01-01T02:00:30Z,c,3\n");
        }
    }

    @Test
    public void testIgnoreParseException() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,d,val\n");
            writer.write("unparseable,a,1\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        List<String> columns = Arrays.asList("time", "dim", "val");
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfig(2, null, null, null, null, false, false);
        IndexTask.IndexIngestionSpec parseExceptionIgnoreSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, DimensionsSpec.EMPTY, null, columns, true, 0), null, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, parseExceptionIgnoreSpec, null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals(Collections.singletonList("d"), (Object)((DataSegment)segments.get(0)).getDimensions());
        Assert.assertEquals(Collections.singletonList("val"), (Object)((DataSegment)segments.get(0)).getMetrics());
        Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)((DataSegment)segments.get(0)).getInterval());
    }

    @Test
    public void testReportParseException() throws Exception {
        ImmutableList expectedMessages;
        IndexTask.IndexIngestionSpec indexIngestionSpec;
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,d,val\n");
            writer.write("unparseable,a,1\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        List<String> columns = Arrays.asList("time", "dim", "val");
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfig(2, null, null, null, null, false, true);
        if (this.useInputFormatApi) {
            indexIngestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
            expectedMessages = ImmutableList.of((Object)StringUtils.format((String)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, d=a, val=1} (Path: %s, Record: 1, Line: 2)", (Object[])new Object[]{tmpFile.toURI()}));
        } else {
            indexIngestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, DimensionsSpec.EMPTY, null, columns, true, 0), null, null, tuningConfig, false, false);
            expectedMessages = ImmutableList.of((Object)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, d=a, val=1}");
        }
        IndexTask indexTask = new IndexTask(null, null, indexIngestionSpec, null);
        TaskStatus status = (TaskStatus)this.runTask((IndexTask)indexTask).lhs;
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        IndexTaskTest.checkTaskStatusErrorMsgForParseExceptionsExceeded(status);
        IngestionStatsAndErrorsTaskReportData reportData = this.getTaskReportData();
        List parseExceptionReports = (List)reportData.getUnparseableEvents().get("buildSegments");
        List actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedMessages, actualMessages);
        ImmutableList expectedInputs = ImmutableList.of((Object)"{time=unparseable, d=a, val=1}");
        List actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedInputs, actualInputs);
    }

    @Test
    public void testMultipleParseExceptionsSuccess() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("{\"time\":\"unparseable\",\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("{\"time\":\"2014-01-01T00:00:10Z\",\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("{\"time\":\"2014-01-01T00:00:10Z\",\"dim\":\"b\",\"dimLong\":\"notnumber\",\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("{\"time\":\"2014-01-01T00:00:10Z\",\"dim\":\"b\",\"dimLong\":2,\"dimFloat\":\"notnumber\",\"val\":1}\n");
            writer.write("{\"time\":\"2014-01-01T00:00:10Z\",\"dim\":\"b\",\"dimLong\":2,\"dimFloat\":4.0,\"val\":\"notnumber\"}\n");
            writer.write("{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("{\"time\":\"3014-03-01T00:00:10Z\",\"dim\":\"outsideofinterval\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("{\"time\":\"99999999999-01-01T00:00:10Z\",\"dim\":\"b\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}\n");
            writer.write("this is not JSON\n");
        }
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, null, null, null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(2), null, null), INDEX_SPEC, null, null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, null, Boolean.valueOf(true), Integer.valueOf(7), Integer.valueOf(7), null, null);
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dim"), new LongDimensionSchema("dimLong"), new FloatDimensionSchema("dimFloat")));
        IndexTask.IndexIngestionSpec ingestionSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, dimensionsSpec, (InputFormat)new JsonInputFormat(null, null, null), null, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new JSONParseSpec(timestampSpec, dimensionsSpec, null, null, null), null, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        TaskStatus status = (TaskStatus)this.runTask((IndexTask)indexTask).lhs;
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)status.getStatusCode());
        Assert.assertEquals(null, (Object)status.getErrorMsg());
        IngestionStatsAndErrorsTaskReportData reportData = this.getTaskReportData();
        ImmutableMap expectedMetrics = ImmutableMap.of((Object)"determinePartitions", (Object)ImmutableMap.of((Object)"processedWithError", (Object)0, (Object)"processed", (Object)4, (Object)"unparseable", (Object)4, (Object)"thrownAway", (Object)1), (Object)"buildSegments", (Object)ImmutableMap.of((Object)"processedWithError", (Object)3, (Object)"processed", (Object)1, (Object)"unparseable", (Object)4, (Object)"thrownAway", (Object)1));
        Assert.assertEquals((Object)expectedMetrics, (Object)reportData.getRowStats());
        List parseExceptionReports = (List)reportData.getUnparseableEvents().get("buildSegments");
        List<String> expectedMessages = this.useInputFormatApi ? Arrays.asList(StringUtils.format((String)"Unable to parse row [this is not JSON] (Path: %s, Record: 6, Line: 9)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 6, Line: 8)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Unable to parse row [{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}] (Path: %s, Record: 5, Line: 6)", (Object[])new Object[]{tmpFile.toURI()}), "Unable to parse value[notnumber] for field[val]", "could not convert value [notnumber] to float", "could not convert value [notnumber] to long", StringUtils.format((String)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 1, Line: 1)", (Object[])new Object[]{tmpFile.toURI()})) : Arrays.asList("Unable to parse row [this is not JSON]", "Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "Unable to parse row [{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}]", "Unable to parse value[notnumber] for field[val]", "could not convert value [notnumber] to float", "could not convert value [notnumber] to long", "Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        List actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals(expectedMessages, actualMessages);
        List<String> expectedInputs = Arrays.asList("this is not JSON", "{time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}", "{time=2014-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=4.0, val=notnumber}", "{time=2014-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=notnumber, val=1}", "{time=2014-01-01T00:00:10Z, dim=b, dimLong=notnumber, dimFloat=3.0, val=1}", "{time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        List actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals(expectedInputs, actualInputs);
        parseExceptionReports = (List)reportData.getUnparseableEvents().get("determinePartitions");
        expectedMessages = this.useInputFormatApi ? Arrays.asList(StringUtils.format((String)"Unable to parse row [this is not JSON] (Path: %s, Record: 6, Line: 9)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 6, Line: 8)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Unable to parse row [{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}] (Path: %s, Record: 5, Line: 6)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 1, Line: 1)", (Object[])new Object[]{tmpFile.toURI()})) : Arrays.asList("Unable to parse row [this is not JSON]", "Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "Unable to parse row [{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}]", "Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals(expectedMessages, actualMessages);
        expectedInputs = Arrays.asList("this is not JSON", "{time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "{\"time\":9.0x,\"dim\":\"a\",\"dimLong\":2,\"dimFloat\":3.0,\"val\":1}", "{time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals(expectedInputs, actualInputs);
    }

    @Test
    public void testMultipleParseExceptionsFailure() throws Exception {
        List<String> expectedMessages;
        IndexTask.IndexIngestionSpec ingestionSpec;
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,dim,dimLong,dimFloat,val\n");
            writer.write("unparseable,a,2,3.0,1\n");
            writer.write("2014-01-01T00:00:10Z,a,2,3.0,1\n");
            writer.write("9.0,a,2,3.0,1\n");
            writer.write("3014-03-01T00:00:10Z,outsideofinterval,2,3.0,1\n");
            writer.write("99999999999-01-01T00:00:10Z,b,2,3.0,1\n");
        }
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, null, null, null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(2), null), INDEX_SPEC, null, null, Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(5), null, null);
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dim"), new LongDimensionSchema("dimLong"), new FloatDimensionSchema("dimFloat")));
        List<String> columns = Arrays.asList("time", "dim", "dimLong", "dimFloat", "val");
        if (this.useInputFormatApi) {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, dimensionsSpec, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
            expectedMessages = Arrays.asList(StringUtils.format((String)"Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 3, Line: 6)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[9.0] is unparseable! Event: {time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 2, Line: 4)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 1, Line: 2)", (Object[])new Object[]{tmpFile.toURI()}));
        } else {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, dimensionsSpec, null, columns, true, 0), null, null, tuningConfig, false, false);
            expectedMessages = Arrays.asList("Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "Timestamp[9.0] is unparseable! Event: {time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1}", "Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        }
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        TaskStatus status = (TaskStatus)this.runTask((IndexTask)indexTask).lhs;
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        IndexTaskTest.checkTaskStatusErrorMsgForParseExceptionsExceeded(status);
        IngestionStatsAndErrorsTaskReportData reportData = this.getTaskReportData();
        ImmutableMap expectedMetrics = ImmutableMap.of((Object)"determinePartitions", (Object)ImmutableMap.of((Object)"processedWithError", (Object)0, (Object)"processed", (Object)0, (Object)"unparseable", (Object)0, (Object)"thrownAway", (Object)0), (Object)"buildSegments", (Object)ImmutableMap.of((Object)"processedWithError", (Object)0, (Object)"processed", (Object)1, (Object)"unparseable", (Object)3, (Object)"thrownAway", (Object)(this.useInputFormatApi ? 1 : 2)));
        Assert.assertEquals((Object)expectedMetrics, (Object)reportData.getRowStats());
        List parseExceptionReports = (List)reportData.getUnparseableEvents().get("buildSegments");
        List actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals(expectedMessages, actualMessages);
        List<String> expectedInputs = Arrays.asList("{time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "{time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1}", "{time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        List actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals(expectedInputs, actualInputs);
    }

    @Test
    public void testMultipleParseExceptionsFailureAtDeterminePartitions() throws Exception {
        List<String> expectedMessages;
        IndexTask.IndexIngestionSpec ingestionSpec;
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("time,dim,dimLong,dimFloat,val\n");
            writer.write("unparseable,a,2,3.0,1\n");
            writer.write("2014-01-01T00:00:10Z,a,2,3.0,1\n");
            writer.write("9.0,a,2,3.0,1\n");
            writer.write("3014-03-01T00:00:10Z,outsideofinterval,2,3.0,1\n");
            writer.write("99999999999-01-01T00:00:10Z,b,2,3.0,1\n");
        }
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, null, null, null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(2), null, null), INDEX_SPEC, null, null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, null, Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(5), null, null);
        TimestampSpec timestampSpec = new TimestampSpec("time", "auto", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dim"), new LongDimensionSchema("dimLong"), new FloatDimensionSchema("dimFloat")));
        List<String> columns = Arrays.asList("time", "dim", "dimLong", "dimFloat", "val");
        if (this.useInputFormatApi) {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, timestampSpec, dimensionsSpec, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
            expectedMessages = Arrays.asList(StringUtils.format((String)"Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 3, Line: 6)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[9.0] is unparseable! Event: {time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 2, Line: 4)", (Object[])new Object[]{tmpFile.toURI()}), StringUtils.format((String)"Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1} (Path: %s, Record: 1, Line: 2)", (Object[])new Object[]{tmpFile.toURI()}));
        } else {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(timestampSpec, dimensionsSpec, null, columns, true, 0), null, null, tuningConfig, false, false);
            expectedMessages = Arrays.asList("Timestamp[99999999999-01-01T00:00:10Z] is unparseable! Event: {time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "Timestamp[9.0] is unparseable! Event: {time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1}", "Timestamp[unparseable] is unparseable! Event: {time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        }
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        TaskStatus status = (TaskStatus)this.runTask((IndexTask)indexTask).lhs;
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        IndexTaskTest.checkTaskStatusErrorMsgForParseExceptionsExceeded(status);
        IngestionStatsAndErrorsTaskReportData reportData = this.getTaskReportData();
        ImmutableMap expectedMetrics = ImmutableMap.of((Object)"determinePartitions", (Object)ImmutableMap.of((Object)"processedWithError", (Object)0, (Object)"processed", (Object)1, (Object)"unparseable", (Object)3, (Object)"thrownAway", (Object)(this.useInputFormatApi ? 1 : 2)), (Object)"buildSegments", (Object)ImmutableMap.of((Object)"processedWithError", (Object)0, (Object)"processed", (Object)0, (Object)"unparseable", (Object)0, (Object)"thrownAway", (Object)0));
        Assert.assertEquals((Object)expectedMetrics, (Object)reportData.getRowStats());
        List parseExceptionReports = (List)reportData.getUnparseableEvents().get("determinePartitions");
        List actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals(expectedMessages, actualMessages);
        List<String> expectedInputs = Arrays.asList("{time=99999999999-01-01T00:00:10Z, dim=b, dimLong=2, dimFloat=3.0, val=1}", "{time=9.0, dim=a, dimLong=2, dimFloat=3.0, val=1}", "{time=unparseable, dim=a, dimLong=2, dimFloat=3.0, val=1}");
        List actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals(expectedInputs, actualInputs);
    }

    @Test
    public void testCsvWithHeaderOfEmptyColumns() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("ts,,\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        tmpFile = File.createTempFile("druid", "index", tmpDir);
        writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);
        var4_4 = null;
        try {
            writer.write("ts,dim,\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var4_4 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
        tmpFile = File.createTempFile("druid", "index", tmpDir);
        writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);
        var4_4 = null;
        try {
            writer.write("ts,,val\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var4_4 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfig(2, 1, null, null, null, true, true);
        IndexTask.IndexIngestionSpec ingestionSpec = this.useInputFormatApi ? IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, DEFAULT_TIMESTAMP_SPEC, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(null, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false) : IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(DEFAULT_TIMESTAMP_SPEC, DimensionsSpec.EMPTY, null, null, true, 0), null, null, tuningConfig, false, false);
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)2L, (long)segments.size());
        Assert.assertNotEquals(segments.get(0), segments.get(1));
        for (DataSegment segment : segments) {
            System.out.println(segment.getDimensions());
        }
        for (int i = 0; i < 2; ++i) {
            DataSegment segment;
            segment = (DataSegment)segments.get(i);
            HashSet dimensions = new HashSet(segment.getDimensions());
            Assert.assertTrue((String)StringUtils.format((String)"Actual dimensions: %s", (Object[])new Object[]{dimensions}), (dimensions.equals(Sets.newHashSet((Object[])new String[]{"column_2"})) || dimensions.equals(Sets.newHashSet((Object[])new String[]{"dim", "column_2", "column_3"})) ? 1 : 0) != 0);
            Assert.assertEquals(Collections.singletonList("val"), (Object)segment.getMetrics());
            Assert.assertEquals((Object)Intervals.of((String)"2014/P1D"), (Object)segment.getInterval());
        }
    }

    @Test
    public void testCsvWithHeaderOfEmptyTimestamp() throws Exception {
        ImmutableList expectedMessages;
        IndexTask.IndexIngestionSpec ingestionSpec;
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write(",,\n");
            writer.write("2014-01-01T00:00:10Z,a,1\n");
        }
        List<String> columns = Arrays.asList("ts", "", "");
        IndexTask.IndexTuningConfig tuningConfig = IndexTaskTest.createTuningConfig(2, null, null, null, null, false, true);
        if (this.useInputFormatApi) {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, DEFAULT_TIMESTAMP_SPEC, DimensionsSpec.EMPTY, (InputFormat)new CsvInputFormat(columns, null, null, Boolean.valueOf(true), 0), null, null, tuningConfig, false, false);
            expectedMessages = ImmutableList.of((Object)StringUtils.format((String)"Timestamp[null] is unparseable! Event: {column_1=2014-01-01T00:00:10Z, column_2=a, column_3=1} (Path: %s, Record: 1, Line: 2)", (Object[])new Object[]{tmpFile.toURI()}));
        } else {
            ingestionSpec = IndexTaskTest.createIngestionSpec(this.jsonMapper, tmpDir, (ParseSpec)new CSVParseSpec(DEFAULT_TIMESTAMP_SPEC, DimensionsSpec.EMPTY, null, columns, true, 0), null, null, tuningConfig, false, false);
            expectedMessages = ImmutableList.of((Object)"Timestamp[null] is unparseable! Event: {column_1=2014-01-01T00:00:10Z, column_2=a, column_3=1}");
        }
        IndexTask indexTask = new IndexTask(null, null, ingestionSpec, null);
        TaskStatus status = (TaskStatus)this.runTask((IndexTask)indexTask).lhs;
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        IndexTaskTest.checkTaskStatusErrorMsgForParseExceptionsExceeded(status);
        IngestionStatsAndErrorsTaskReportData reportData = this.getTaskReportData();
        List parseExceptionReports = (List)reportData.getUnparseableEvents().get("buildSegments");
        List actualMessages = parseExceptionReports.stream().map(r -> (String)((List)r.get("details")).get(0)).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedMessages, actualMessages);
        ImmutableList expectedInputs = ImmutableList.of((Object)"{column_1=2014-01-01T00:00:10Z, column_2=a, column_3=1}");
        List actualInputs = parseExceptionReports.stream().map(r -> (String)r.get("input")).collect(Collectors.toList());
        Assert.assertEquals((Object)expectedInputs, actualInputs);
    }

    @Test
    public void testOverwriteWithSameSegmentGranularity() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        IndexTaskTest.populateRollupTestData(tmpFile);
        for (int i = 0; i < 2; ++i) {
            IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.DAY, Boolean.valueOf(true), null), null, IndexTaskTest.createTuningConfig(3, 2, null, 2L, null, false, true), false, false), null);
            List segments = (List)this.runTask((IndexTask)indexTask).rhs;
            Assert.assertEquals((long)5L, (long)segments.size());
            Interval expectedInterval = Intervals.of((String)"2014-01-01T00:00:00.000Z/2014-01-02T00:00:00.000Z");
            for (int j = 0; j < 5; ++j) {
                DataSegment segment = (DataSegment)segments.get(j);
                Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
                Assert.assertEquals((Object)expectedInterval, (Object)segment.getInterval());
                if (i == 0) {
                    Assert.assertEquals(NumberedShardSpec.class, segment.getShardSpec().getClass());
                    Assert.assertEquals((long)j, (long)segment.getShardSpec().getPartitionNum());
                    continue;
                }
                if (this.lockGranularity == LockGranularity.SEGMENT) {
                    Assert.assertEquals(NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
                    NumberedOverwriteShardSpec numberedOverwriteShardSpec = (NumberedOverwriteShardSpec)segment.getShardSpec();
                    Assert.assertEquals((long)(j + 32768), (long)numberedOverwriteShardSpec.getPartitionNum());
                    Assert.assertEquals((long)1L, (long)numberedOverwriteShardSpec.getMinorVersion());
                    Assert.assertEquals((long)5L, (long)numberedOverwriteShardSpec.getAtomicUpdateGroupSize());
                    Assert.assertEquals((long)0L, (long)numberedOverwriteShardSpec.getStartRootPartitionId());
                    Assert.assertEquals((long)5L, (long)numberedOverwriteShardSpec.getEndRootPartitionId());
                    continue;
                }
                Assert.assertEquals(NumberedShardSpec.class, segment.getShardSpec().getClass());
                NumberedShardSpec numberedShardSpec = (NumberedShardSpec)segment.getShardSpec();
                Assert.assertEquals((long)j, (long)numberedShardSpec.getPartitionNum());
            }
        }
    }

    @Test
    public void testOverwriteWithDifferentSegmentGranularity() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        IndexTaskTest.populateRollupTestData(tmpFile);
        for (int i = 0; i < 2; ++i) {
            Granularity segmentGranularity = i == 0 ? Granularities.DAY : Granularities.MONTH;
            IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(segmentGranularity, Granularities.DAY, Boolean.valueOf(true), null), null, IndexTaskTest.createTuningConfig(3, 2, null, 2L, null, false, true), false, false), null);
            List segments = (List)this.runTask((IndexTask)indexTask).rhs;
            Assert.assertEquals((long)5L, (long)segments.size());
            Interval expectedInterval = i == 0 ? Intervals.of((String)"2014-01-01/2014-01-02") : Intervals.of((String)"2014-01-01/2014-02-01");
            for (int j = 0; j < 5; ++j) {
                DataSegment segment = (DataSegment)segments.get(j);
                Assert.assertEquals((Object)DATASOURCE, (Object)segment.getDataSource());
                Assert.assertEquals((Object)expectedInterval, (Object)segment.getInterval());
                Assert.assertEquals(NumberedShardSpec.class, segment.getShardSpec().getClass());
                Assert.assertEquals((long)j, (long)segment.getShardSpec().getPartitionNum());
            }
        }
    }

    @Test
    public void testIndexTaskWithSingleDimPartitionsSpecThrowingException() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        IndexTask task = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, null, null, IndexTaskTest.createTuningConfigWithPartitionsSpec((PartitionsSpec)new SingleDimensionPartitionsSpec(null, Integer.valueOf(1), null, false), true), false, false), null);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("partitionsSpec[org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec] is not supported");
        task.isReady((TaskActionClient)this.createActionClient((Task)task));
    }

    @Test
    public void testOldSegmentNotReplacedWhenDropFlagFalse() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.YEAR, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        HashSet usedSegmentsBeforeOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)1L, (long)usedSegmentsBeforeOverwrite.size());
        for (DataSegment segment : usedSegmentsBeforeOverwrite) {
            Assert.assertTrue((boolean)Granularities.YEAR.isAligned(segment.getInterval()));
        }
        indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)3L, (long)segments.size());
        HashSet usedSegmentsBeforeAfterOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)4L, (long)usedSegmentsBeforeAfterOverwrite.size());
        int yearSegmentFound = 0;
        int minuteSegmentFound = 0;
        for (DataSegment segment : usedSegmentsBeforeAfterOverwrite) {
            if (usedSegmentsBeforeOverwrite.contains(segment)) {
                Assert.assertTrue((boolean)Granularities.YEAR.isAligned(segment.getInterval()));
                ++yearSegmentFound;
                continue;
            }
            Assert.assertTrue((boolean)Granularities.MINUTE.isAligned(segment.getInterval()));
            ++minuteSegmentFound;
        }
        Assert.assertEquals((long)1L, (long)yearSegmentFound);
        Assert.assertEquals((long)3L, (long)minuteSegmentFound);
    }

    @Test
    public void testOldSegmentNotCoveredByTombstonesWhenDropFlagTrueSinceIngestionIntervalDoesNotContainsOldSegment() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T01:00:10Z,a,1\n");
            writer.write("2014-01-01T01:10:20Z,b,1\n");
            writer.write("2014-01-01T01:20:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01T01:00:00Z/2014-01-01T02:00:00Z"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        HashSet usedSegmentsBeforeOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)1L, (long)usedSegmentsBeforeOverwrite.size());
        for (DataSegment segment : usedSegmentsBeforeOverwrite) {
            Assert.assertTrue((boolean)Granularities.DAY.isAligned(segment.getInterval()));
        }
        indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01T01:10:00Z/2014-01-01T02:00:00Z"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, true), null);
        segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        HashSet usedSegmentsBeforeAfterOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)2L, (long)usedSegmentsBeforeAfterOverwrite.size());
        int segmentFound = 0;
        int tombstonesFound = 0;
        int hourSegmentFound = 0;
        int daySegmentFound = 0;
        for (DataSegment segment : usedSegmentsBeforeAfterOverwrite) {
            if (segment.isTombstone()) {
                ++tombstonesFound;
            } else {
                ++segmentFound;
            }
            if (usedSegmentsBeforeOverwrite.contains(segment)) {
                Assert.assertTrue((boolean)Granularities.DAY.isAligned(segment.getInterval()));
                ++daySegmentFound;
                continue;
            }
            Assert.assertTrue((boolean)Granularities.HOUR.isAligned(segment.getInterval()));
            ++hourSegmentFound;
        }
        Assert.assertEquals((long)1L, (long)daySegmentFound);
        Assert.assertEquals((long)1L, (long)hourSegmentFound);
        Assert.assertEquals((long)2L, (long)segmentFound);
        Assert.assertEquals((long)0L, (long)tombstonesFound);
    }

    @Test
    public void testOldSegmentCoveredByTombstonesWhenDropFlagTrueSinceIngestionIntervalContainsOldSegment() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-01-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01T01:00:00Z/2014-01-01T02:00:00Z"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        HashSet usedSegmentsBeforeOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)1L, (long)usedSegmentsBeforeOverwrite.size());
        for (DataSegment segment : usedSegmentsBeforeOverwrite) {
            Assert.assertTrue((boolean)Granularities.DAY.isAligned(segment.getInterval()));
        }
        indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, true), null);
        segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)24L, (long)segments.size());
        HashSet usedSegmentsBeforeAfterOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)24L, (long)usedSegmentsBeforeAfterOverwrite.size());
        for (DataSegment segment : usedSegmentsBeforeAfterOverwrite) {
            if (usedSegmentsBeforeOverwrite.contains(segment)) {
                Assert.fail();
                continue;
            }
            Assert.assertTrue((boolean)Granularities.HOUR.isAligned(segment.getInterval()));
        }
    }

    @Test
    public void verifyPublishingOnlyTombstones() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-03-01T00:00:10Z,a,1\n");
            writer.write("2014-03-01T01:00:20Z,b,1\n");
            writer.write("2014-03-01T02:00:30Z,c,1\n");
        }
        IndexTask indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-03/2014-04-01"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, false), null);
        List segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        HashSet usedSegmentsBeforeOverwrite = Sets.newHashSet((Iterable)((Iterable)this.getSegmentsMetadataManager().iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(DATASOURCE, Intervals.ETERNITY, true).get()));
        Assert.assertEquals((long)1L, (long)usedSegmentsBeforeOverwrite.size());
        for (DataSegment segment : usedSegmentsBeforeOverwrite) {
            Assert.assertTrue((boolean)Granularities.DAY.isAligned(segment.getInterval()));
        }
        tmpDir = this.temporaryFolder.newFolder();
        tmpFile = File.createTempFile("druid", "index", tmpDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,1\n");
            writer.write("2014-12-01T02:00:30Z,c,1\n");
        }
        indexTask = new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, tmpDir, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-03-01/2014-04-01"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), false, true), null);
        segments = (List)this.runTask((IndexTask)indexTask).rhs;
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((boolean)((DataSegment)segments.get(0)).isTombstone());
    }

    @Test
    public void testErrorWhenDropFlagTrueAndOverwriteFalse() throws Exception {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Cannot both drop existing segments and append to existing segments. Either dropExisting or appendToExisting should be set to false");
        new IndexTask(null, null, this.createDefaultIngestionSpec(this.jsonMapper, this.temporaryFolder.newFolder(), (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014-01-01/2014-01-02"))), null, IndexTaskTest.createTuningConfigWithMaxRowsPerSegment(10, true), true, true), null);
    }

    public static void checkTaskStatusErrorMsgForParseExceptionsExceeded(TaskStatus status) {
        Assert.assertThat((Object)status.getErrorMsg(), (Matcher)CoreMatchers.containsString((String)"Max parse exceptions"));
    }

    private Pair<TaskStatus, List<DataSegment>> runTask(IndexTask task) throws Exception {
        task.addToContext("forceTimeChunkLock", (Object)(this.lockGranularity == LockGranularity.TIME_CHUNK ? 1 : 0));
        TaskStatus status = (TaskStatus)this.taskRunner.run((Task)task).get();
        List<DataSegment> segments = this.taskRunner.getPublishedSegments();
        return Pair.of((Object)status, segments);
    }

    private static IndexTask.IndexTuningConfig createTuningConfigWithMaxRowsPerSegment(int maxRowsPerSegment, boolean forceGuaranteedRollup) {
        return IndexTaskTest.createTuningConfig(maxRowsPerSegment, 1, null, null, null, forceGuaranteedRollup, true);
    }

    private static IndexTask.IndexTuningConfig createTuningConfigWithPartitionsSpec(PartitionsSpec partitionsSpec, boolean forceGuaranteedRollup) {
        return IndexTaskTest.createTuningConfig(null, 1, null, null, partitionsSpec, forceGuaranteedRollup, true);
    }

    static IndexTask.IndexTuningConfig createTuningConfig(@Nullable Integer maxRowsPerSegment, @Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Long maxTotalRows, @Nullable PartitionsSpec partitionsSpec, boolean forceGuaranteedRollup, boolean reportParseException) {
        return new IndexTask.IndexTuningConfig(null, maxRowsPerSegment, null, maxRowsInMemory, maxBytesInMemory, null, maxTotalRows, null, null, null, partitionsSpec, INDEX_SPEC, null, null, Boolean.valueOf(forceGuaranteedRollup), Boolean.valueOf(reportParseException), null, null, null, null, null, Integer.valueOf(1), null, null);
    }

    private IngestionStatsAndErrorsTaskReportData getTaskReportData() throws IOException {
        Map taskReports = (Map)this.jsonMapper.readValue(this.taskRunner.getTaskReportsFile(), (TypeReference)new TypeReference<Map<String, TaskReport>>(){});
        return IngestionStatsAndErrorsTaskReportData.getPayloadFromTaskReports((Map)taskReports);
    }

    private IndexTask.IndexIngestionSpec createDefaultIngestionSpec(ObjectMapper objectMapper, File baseDir, @Nullable GranularitySpec granularitySpec, @Nullable TransformSpec transformSpec, IndexTask.IndexTuningConfig tuningConfig, boolean appendToExisting, Boolean dropExisting) {
        if (this.useInputFormatApi) {
            return IndexTaskTest.createIngestionSpec(objectMapper, baseDir, DEFAULT_TIMESTAMP_SPEC, DEFAULT_DIMENSIONS_SPEC, DEFAULT_INPUT_FORMAT, transformSpec, granularitySpec, tuningConfig, appendToExisting, dropExisting);
        }
        return IndexTaskTest.createIngestionSpec(objectMapper, baseDir, DEFAULT_PARSE_SPEC, transformSpec, granularitySpec, tuningConfig, appendToExisting, dropExisting);
    }

    static IndexTask.IndexIngestionSpec createIngestionSpec(ObjectMapper objectMapper, File baseDir, @Nullable ParseSpec parseSpec, @Nullable TransformSpec transformSpec, @Nullable GranularitySpec granularitySpec, IndexTask.IndexTuningConfig tuningConfig, boolean appendToExisting, Boolean dropExisting) {
        return IndexTaskTest.createIngestionSpec(objectMapper, baseDir, parseSpec, null, null, null, transformSpec, granularitySpec, tuningConfig, appendToExisting, dropExisting);
    }

    static IndexTask.IndexIngestionSpec createIngestionSpec(ObjectMapper objectMapper, File baseDir, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, InputFormat inputFormat, @Nullable TransformSpec transformSpec, @Nullable GranularitySpec granularitySpec, IndexTask.IndexTuningConfig tuningConfig, boolean appendToExisting, Boolean dropExisting) {
        return IndexTaskTest.createIngestionSpec(objectMapper, baseDir, null, timestampSpec, dimensionsSpec, inputFormat, transformSpec, granularitySpec, tuningConfig, appendToExisting, dropExisting);
    }

    private static IndexTask.IndexIngestionSpec createIngestionSpec(ObjectMapper objectMapper, File baseDir, @Nullable ParseSpec parseSpec, @Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable InputFormat inputFormat, @Nullable TransformSpec transformSpec, @Nullable GranularitySpec granularitySpec, IndexTask.IndexTuningConfig tuningConfig, boolean appendToExisting, Boolean dropExisting) {
        if (inputFormat != null) {
            Preconditions.checkArgument((parseSpec == null ? 1 : 0) != 0, (Object)"Can't use parseSpec");
            return new IndexTask.IndexIngestionSpec(new DataSchema(DATASOURCE, (TimestampSpec)Preconditions.checkNotNull((Object)timestampSpec, (Object)"timestampSpec"), (DimensionsSpec)Preconditions.checkNotNull((Object)dimensionsSpec, (Object)"dimensionsSpec"), new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)(granularitySpec != null ? granularitySpec : new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014/2015")))), transformSpec), new IndexTask.IndexIOConfig(null, (InputSource)new LocalInputSource(baseDir, "druid*"), inputFormat, Boolean.valueOf(appendToExisting), dropExisting), tuningConfig);
        }
        return new IndexTask.IndexIngestionSpec(new DataSchema(DATASOURCE, (Map)objectMapper.convertValue((Object)new StringInputRowParser(parseSpec != null ? parseSpec : DEFAULT_PARSE_SPEC, null), Map.class), new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)(granularitySpec != null ? granularitySpec : new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, Collections.singletonList(Intervals.of((String)"2014/2015")))), transformSpec, objectMapper), new IndexTask.IndexIOConfig((FirehoseFactory)new LocalFirehoseFactory(baseDir, "druid*", null), Boolean.valueOf(appendToExisting), dropExisting), tuningConfig);
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(IndexTask.IndexTuningConfig.class).usingGetClass().verify();
    }

    private static class LatchableServiceEmitter
    extends ServiceEmitter {
        private CountDownLatch latch;

        private LatchableServiceEmitter() {
            super("", "", null);
        }

        public void emit(Event event) {
            if (this.latch != null && "task/segmentAvailability/wait/time".equals(event.toMap().get("metric"))) {
                this.latch.countDown();
            }
        }
    }
}

