/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.KillUnusedSegmentsTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.assertj.core.api.Assertions;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KillUnusedSegmentsTaskTest
extends IngestionTestBase {
    private static final String DATA_SOURCE = "dataSource";
    private TaskRunner taskRunner;

    @Before
    public void setup() {
        this.taskRunner = new IngestionTestBase.TestTaskRunner(this);
    }

    @Test
    public void testKill() throws Exception {
        String version = DateTimes.nowUtc().toString();
        ImmutableSet segments = ImmutableSet.of((Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-01-01/2019-02-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-03-01/2019-04-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-04-01/2019-05-01"), version));
        Set announced = this.getMetadataStorageCoordinator().announceHistoricalSegments((Set)segments);
        Assert.assertEquals((Object)segments, (Object)announced);
        Assert.assertTrue((boolean)this.getSegmentsMetadataManager().markSegmentAsUnused(KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version).getId()));
        Assert.assertTrue((boolean)this.getSegmentsMetadataManager().markSegmentAsUnused(KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-03-01/2019-04-01"), version).getId()));
        KillUnusedSegmentsTask task = new KillUnusedSegmentsTask(null, DATA_SOURCE, Intervals.of((String)"2019-03-01/2019-04-01"), null, Boolean.valueOf(false));
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)this.taskRunner.run((Task)task).get()).getStatusCode());
        List unusedSegments = this.getMetadataStorageCoordinator().retrieveUnusedSegmentsForInterval(DATA_SOURCE, Intervals.of((String)"2019/2020"));
        Assert.assertEquals((Object)ImmutableList.of((Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version)), (Object)unusedSegments);
        Assertions.assertThat((Iterable)this.getMetadataStorageCoordinator().retrieveUsedSegmentsForInterval(DATA_SOURCE, Intervals.of((String)"2019/2020"), Segments.ONLY_VISIBLE)).containsExactlyInAnyOrder((Object[])new DataSegment[]{KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-01-01/2019-02-01"), version), KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-04-01/2019-05-01"), version)});
    }

    @Test
    public void testKillWithMarkUnused() throws Exception {
        String version = DateTimes.nowUtc().toString();
        ImmutableSet segments = ImmutableSet.of((Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-01-01/2019-02-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-03-01/2019-04-01"), version), (Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-04-01/2019-05-01"), version));
        Set announced = this.getMetadataStorageCoordinator().announceHistoricalSegments((Set)segments);
        Assert.assertEquals((Object)segments, (Object)announced);
        Assert.assertTrue((boolean)this.getSegmentsMetadataManager().markSegmentAsUnused(KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version).getId()));
        KillUnusedSegmentsTask task = new KillUnusedSegmentsTask(null, DATA_SOURCE, Intervals.of((String)"2019-03-01/2019-04-01"), null, Boolean.valueOf(true));
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)this.taskRunner.run((Task)task).get()).getStatusCode());
        List unusedSegments = this.getMetadataStorageCoordinator().retrieveUnusedSegmentsForInterval(DATA_SOURCE, Intervals.of((String)"2019/2020"));
        Assert.assertEquals((Object)ImmutableList.of((Object)KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-02-01/2019-03-01"), version)), (Object)unusedSegments);
        Assertions.assertThat((Iterable)this.getMetadataStorageCoordinator().retrieveUsedSegmentsForInterval(DATA_SOURCE, Intervals.of((String)"2019/2020"), Segments.ONLY_VISIBLE)).containsExactlyInAnyOrder((Object[])new DataSegment[]{KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-01-01/2019-02-01"), version), KillUnusedSegmentsTaskTest.newSegment(Intervals.of((String)"2019-04-01/2019-05-01"), version)});
    }

    private static DataSegment newSegment(Interval interval, String version) {
        return new DataSegment(DATA_SOURCE, interval, version, null, null, null, null, Integer.valueOf(9), 10L);
    }
}

