/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SpecificSegmentsSpecTest {
    @Test
    public void createTest() {
        List segments = IntStream.range(0, 20).mapToObj(i -> SpecificSegmentsSpecTest.newSegment(Intervals.of((String)"2019-01-%02d/2019-01-%02d", (Object[])new Object[]{i + 1, i + 2}))).collect(Collectors.toList());
        List expectedSegmentIds = segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList());
        Collections.shuffle(segments, ThreadLocalRandom.current());
        SpecificSegmentsSpec spec = SpecificSegmentsSpec.fromSegments(segments);
        Assert.assertEquals(expectedSegmentIds, (Object)spec.getSegments());
    }

    private static DataSegment newSegment(Interval interval) {
        return new DataSegment("datasource", interval, "version", null, null, null, null, Integer.valueOf(9), 10L);
    }
}

