/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TaskReportSerdeTest {
    private final ObjectMapper jsonMapper;

    public TaskReportSerdeTest() {
        TestUtils testUtils = new TestUtils();
        this.jsonMapper = testUtils.getTestObjectMapper();
    }

    @Test
    public void testSerde() throws Exception {
        IngestionStatsAndErrorsTaskReport report1 = new IngestionStatsAndErrorsTaskReport("testID", new IngestionStatsAndErrorsTaskReportData(IngestionState.BUILD_SEGMENTS, (Map)ImmutableMap.of((Object)"hello", (Object)"world"), (Map)ImmutableMap.of((Object)"number", (Object)1234), "an error message", true, 1000L));
        String report1serialized = this.jsonMapper.writeValueAsString((Object)report1);
        IngestionStatsAndErrorsTaskReport report2 = (IngestionStatsAndErrorsTaskReport)this.jsonMapper.readValue(report1serialized, IngestionStatsAndErrorsTaskReport.class);
        Assert.assertEquals((Object)report1, (Object)report2);
        Assert.assertEquals((long)report1.hashCode(), (long)report2.hashCode());
        Map reportMap1 = TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{report1});
        String reportMapSerialized = this.jsonMapper.writeValueAsString((Object)reportMap1);
        Map reportMap2 = (Map)this.jsonMapper.readValue(reportMapSerialized, (TypeReference)new TypeReference<Map<String, TaskReport>>(){});
        Assert.assertEquals((Object)reportMap1, (Object)reportMap2);
    }
}

