/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheLoader;
import org.apache.druid.segment.loading.TombstoneLoadSpec;
import org.apache.druid.segment.realtime.firehose.LocalFirehoseFactory;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;

abstract class AbstractMultiPhaseParallelIndexingTest
extends AbstractParallelIndexSupervisorTaskTest {
    protected static final String DATASOURCE = "dataSource";
    protected static final Granularity SEGMENT_GRANULARITY = Granularities.DAY;
    private static final ScanQueryRunnerFactory SCAN_QUERY_RUNNER_FACTORY = new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(new ScanQueryConfig().setLegacy(false), DefaultGenericQueryMetricsFactory.instance()), new ScanQueryEngine(), new ScanQueryConfig());
    private final LockGranularity lockGranularity;
    private final boolean useInputFormatApi;

    AbstractMultiPhaseParallelIndexingTest(LockGranularity lockGranularity, boolean useInputFormatApi, double transientTaskFailureRate, double transientApiCallFailureRate) {
        super(transientTaskFailureRate, transientApiCallFailureRate);
        this.lockGranularity = lockGranularity;
        this.useInputFormatApi = useInputFormatApi;
        this.getObjectMapper().registerSubtypes(new Class[]{ParallelIndexTuningConfig.class, DruidInputSource.class, TombstoneLoadSpec.class});
    }

    boolean isUseInputFormatApi() {
        return this.useInputFormatApi;
    }

    Set<DataSegment> runTestTask(@Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable InputFormat inputFormat, @Nullable ParseSpec parseSpec, Interval interval, File inputDir, String filter, PartitionsSpec partitionsSpec, int maxNumConcurrentSubTasks, TaskState expectedTaskStatus) {
        return this.runTestTask(timestampSpec, dimensionsSpec, inputFormat, parseSpec, interval, inputDir, filter, partitionsSpec, maxNumConcurrentSubTasks, expectedTaskStatus, false, false);
    }

    Set<DataSegment> runTestTask(@Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable InputFormat inputFormat, @Nullable ParseSpec parseSpec, Interval interval, File inputDirectory, String filter, PartitionsSpec partitionsSpec, int maxNumConcurrentSubTasks, TaskState expectedTaskStatus, boolean appendToExisting, boolean dropExisting) {
        ParallelIndexSupervisorTask task = this.createTask(timestampSpec, dimensionsSpec, inputFormat, parseSpec, interval, inputDirectory, filter, partitionsSpec, maxNumConcurrentSubTasks, appendToExisting, dropExisting);
        return this.runTask((Task)task, expectedTaskStatus);
    }

    void runTaskAndVerifyStatus(Task task, TaskState expectedTaskStatus) {
        task.addToContext("forceTimeChunkLock", (Object)(this.lockGranularity == LockGranularity.TIME_CHUNK ? 1 : 0));
        TaskStatus taskStatus = this.getIndexingServiceClient().runAndWait(task);
        Assert.assertEquals((Object)expectedTaskStatus, (Object)taskStatus.getStatusCode());
    }

    Set<DataSegment> runTask(Task task, TaskState expectedTaskStatus) {
        this.runTaskAndVerifyStatus(task, expectedTaskStatus);
        return this.getIndexingServiceClient().getPublishedSegments(task);
    }

    Map<String, Object> runTaskAndGetReports(Task task, TaskState expectedTaskStatus) {
        this.runTaskAndVerifyStatus(task, expectedTaskStatus);
        return this.getIndexingServiceClient().getTaskReport(task.getId());
    }

    protected ParallelIndexSupervisorTask createTask(@Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable InputFormat inputFormat, @Nullable ParseSpec parseSpec, Interval interval, File inputDirectory, String filter, PartitionsSpec partitionsSpec, int maxNumConcurrentSubTasks, boolean appendToExisting, boolean dropExisting) {
        ParallelIndexIngestionSpec ingestionSpec;
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(SEGMENT_GRANULARITY, Granularities.MINUTE, interval == null ? null : Collections.singletonList(interval));
        ParallelIndexTuningConfig tuningConfig = this.newTuningConfig(partitionsSpec, maxNumConcurrentSubTasks, !appendToExisting);
        if (this.useInputFormatApi) {
            Preconditions.checkArgument((parseSpec == null ? 1 : 0) != 0);
            ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig(null, (InputSource)new LocalInputSource(inputDirectory, filter), inputFormat, Boolean.valueOf(appendToExisting), Boolean.valueOf(dropExisting));
            ingestionSpec = new ParallelIndexIngestionSpec(new DataSchema(DATASOURCE, timestampSpec, dimensionsSpec, DEFAULT_METRICS_SPEC, (GranularitySpec)granularitySpec, null), ioConfig, tuningConfig);
        } else {
            Preconditions.checkArgument((inputFormat == null ? 1 : 0) != 0);
            ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig((FirehoseFactory)new LocalFirehoseFactory(inputDirectory, filter, null), Boolean.valueOf(appendToExisting), dropExisting);
            ingestionSpec = new ParallelIndexIngestionSpec(new DataSchema(DATASOURCE, (Map)this.getObjectMapper().convertValue((Object)new StringInputRowParser(parseSpec, null), Map.class), DEFAULT_METRICS_SPEC, (GranularitySpec)granularitySpec, null, this.getObjectMapper()), ioConfig, tuningConfig);
        }
        return new ParallelIndexSupervisorTask(null, null, null, ingestionSpec, Collections.emptyMap());
    }

    List<ScanResultValue> querySegment(DataSegment dataSegment, List<String> columns, File tempSegmentDir) {
        Segment segment = this.loadSegment(dataSegment, tempSegmentDir);
        QueryRunner runner = SCAN_QUERY_RUNNER_FACTORY.createRunner(segment);
        return runner.run(QueryPlus.wrap((Query)new ScanQuery((DataSource)new TableDataSource(DATASOURCE), (QuerySegmentSpec)new SpecificSegmentSpec(new SegmentDescriptor(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getShardSpec().getPartitionNum())), null, null, 0, 0L, 0L, null, null, null, columns, Boolean.valueOf(false), null))).toList();
    }

    private Segment loadSegment(DataSegment dataSegment, File tempSegmentDir) {
        SegmentCacheManager cacheManager = new SegmentCacheManagerFactory(this.getObjectMapper()).manufacturate(tempSegmentDir);
        SegmentLocalCacheLoader loader = new SegmentLocalCacheLoader(cacheManager, this.getIndexIO(), this.getObjectMapper());
        try {
            return loader.getSegment(dataSegment, false, SegmentLazyLoadFailCallback.NOOP);
        }
        catch (SegmentLoadingException e) {
            throw new RuntimeException(e);
        }
    }
}

