/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericPartitionStatTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private GenericPartitionStat target;

    @Before
    public void setup() {
        this.target = new GenericPartitionStat("task-executor-host", 1, true, ParallelIndexTestingFactory.INTERVAL, (BucketNumberedShardSpec)new HashBucketShardSpec(4, 5, Collections.singletonList("dim"), HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper()), Integer.valueOf(2), Long.valueOf(3L));
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }

    @Test
    public void hasPartitionIdThatMatchesSecondaryPartition() {
        Assert.assertEquals((long)this.target.getSecondaryPartition().getBucketId(), (long)this.target.getBucketId());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(GenericPartitionStat.class).withNonnullFields(new String[]{"taskExecutorHost", "taskExecutorPort", "useHttps", "interval", "shardSpec"}).usingGetClass().verify();
    }
}

