/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashPartitionAdjustingCorePartitionSizeTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final InputFormat INPUT_FORMAT = new CsvInputFormat(Arrays.asList("ts", "dim1", "dim2", "val"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0);
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"2020-01-01/P1M");
    private final int maxNumConcurrentSubTasks;

    @Parameterized.Parameters(name="{0}, maxNumConcurrentSubTasks={1}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.TIME_CHUNK, 2}, (Object)new Object[]{LockGranularity.TIME_CHUNK, 1}, (Object)new Object[]{LockGranularity.SEGMENT, 2});
    }

    public HashPartitionAdjustingCorePartitionSizeTest(LockGranularity lockGranularity, int maxNumConcurrentSubTasks) {
        super(lockGranularity, true, 0.2, 0.2);
        this.maxNumConcurrentSubTasks = maxNumConcurrentSubTasks;
    }

    @Test
    public void testLessPartitionsThanBuckets() throws IOException {
        File inputDir = this.temporaryFolder.newFolder();
        for (int i = 0; i < 3; ++i) {
            try (BufferedWriter writer = Files.newBufferedWriter(new File(inputDir, "test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(StringUtils.format((String)"2020-01-01T00:00:00,%s,b1,%d\n", (Object[])new Object[]{"a" + (i + 1), 10 * (i + 1)}));
                continue;
            }
        }
        HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim1"));
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(this.runTestTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, inputDir, "test_*", (PartitionsSpec)partitionsSpec, this.maxNumConcurrentSubTasks, TaskState.SUCCESS));
        Assert.assertEquals((long)3L, (long)segments.size());
        segments.sort(Comparator.comparing(segment -> segment.getShardSpec().getPartitionNum()));
        int prevPartitionId = -1;
        for (DataSegment segment2 : segments) {
            Assert.assertSame(HashBasedNumberedShardSpec.class, segment2.getShardSpec().getClass());
            HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)segment2.getShardSpec();
            Assert.assertEquals((long)3L, (long)shardSpec.getNumCorePartitions());
            Assert.assertEquals((long)10L, (long)shardSpec.getNumBuckets());
            Assert.assertEquals((Object)ImmutableList.of((Object)"dim1"), (Object)shardSpec.getPartitionDimensions());
            Assert.assertEquals((long)(prevPartitionId + 1), (long)shardSpec.getPartitionNum());
            prevPartitionId = shardSpec.getPartitionNum();
        }
    }

    @Test
    public void testEqualNumberOfPartitionsToBuckets() throws IOException {
        File inputDir = this.temporaryFolder.newFolder();
        for (int i = 0; i < 10; ++i) {
            try (BufferedWriter writer = Files.newBufferedWriter(new File(inputDir, "test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(StringUtils.format((String)"2020-01-01T00:00:00,%s,b1,%d\n", (Object[])new Object[]{"aa" + (i + 10), 10 * (i + 1)}));
                continue;
            }
        }
        HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(5), (List)ImmutableList.of((Object)"dim1"));
        Set<DataSegment> segments = this.runTestTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, inputDir, "test_*", (PartitionsSpec)partitionsSpec, this.maxNumConcurrentSubTasks, TaskState.SUCCESS);
        Assert.assertEquals((long)5L, (long)segments.size());
        segments.forEach(segment -> {
            Assert.assertSame(HashBasedNumberedShardSpec.class, segment.getShardSpec().getClass());
            HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)segment.getShardSpec();
            Assert.assertEquals((long)5L, (long)shardSpec.getNumCorePartitions());
            Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
            Assert.assertEquals((Object)ImmutableList.of((Object)"dim1"), (Object)shardSpec.getPartitionDimensions());
        });
    }
}

