/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsReport;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.DimensionRangeBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class ParallelIndexSupervisorTaskTest {

    public static class StaticUtilsTest {
        @Test
        public void testIsParallelModeFalse_nullTuningConfig() {
            InputSource inputSource = (InputSource)EasyMock.mock(InputSource.class);
            Assert.assertFalse((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, null));
        }

        @Test
        public void testIsParallelModeFalse_rangePartition() {
            InputSource inputSource = (InputSource)EasyMock.mock(InputSource.class);
            EasyMock.expect((Object)inputSource.isSplittable()).andReturn((Object)true).anyTimes();
            ParallelIndexTuningConfig tuningConfig = (ParallelIndexTuningConfig)EasyMock.mock(ParallelIndexTuningConfig.class);
            EasyMock.expect((Object)tuningConfig.getGivenOrDefaultPartitionsSpec()).andReturn(EasyMock.mock(SingleDimensionPartitionsSpec.class)).anyTimes();
            EasyMock.expect((Object)tuningConfig.getMaxNumConcurrentSubTasks()).andReturn((Object)0).andReturn((Object)1).andReturn((Object)2);
            EasyMock.replay((Object[])new Object[]{inputSource, tuningConfig});
            Assert.assertFalse((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
            Assert.assertTrue((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
            Assert.assertTrue((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeFalse_notRangePartition() {
            InputSource inputSource = (InputSource)EasyMock.mock(InputSource.class);
            EasyMock.expect((Object)inputSource.isSplittable()).andReturn((Object)true).anyTimes();
            ParallelIndexTuningConfig tuningConfig = (ParallelIndexTuningConfig)EasyMock.mock(ParallelIndexTuningConfig.class);
            EasyMock.expect((Object)tuningConfig.getGivenOrDefaultPartitionsSpec()).andReturn(EasyMock.mock(PartitionsSpec.class)).anyTimes();
            EasyMock.expect((Object)tuningConfig.getMaxNumConcurrentSubTasks()).andReturn((Object)1).andReturn((Object)2).andReturn((Object)3);
            EasyMock.replay((Object[])new Object[]{inputSource, tuningConfig});
            Assert.assertFalse((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
            Assert.assertTrue((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
            Assert.assertTrue((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeFalse_inputSourceNotSplittable() {
            InputSource inputSource = (InputSource)EasyMock.mock(InputSource.class);
            EasyMock.expect((Object)inputSource.isSplittable()).andReturn((Object)false).anyTimes();
            ParallelIndexTuningConfig tuningConfig = (ParallelIndexTuningConfig)EasyMock.mock(ParallelIndexTuningConfig.class);
            EasyMock.expect((Object)tuningConfig.getGivenOrDefaultPartitionsSpec()).andReturn(EasyMock.mock(SingleDimensionPartitionsSpec.class)).anyTimes();
            EasyMock.expect((Object)tuningConfig.getMaxNumConcurrentSubTasks()).andReturn((Object)3);
            EasyMock.replay((Object[])new Object[]{inputSource, tuningConfig});
            Assert.assertFalse((boolean)ParallelIndexSupervisorTask.isParallelMode((InputSource)inputSource, (ParallelIndexTuningConfig)tuningConfig));
        }

        @Test
        public void test_getPartitionToLocations_ordersPartitionsCorrectly() {
            Interval day1 = Intervals.of((String)"2022-01-01/2022-01-02");
            Interval day2 = Intervals.of((String)"2022-01-02/2022-01-03");
            String task1 = "task1";
            String task2 = "task2";
            HashMap<String, GeneratedPartitionsReport> taskIdToReport = new HashMap<String, GeneratedPartitionsReport>();
            taskIdToReport.put("task1", new GeneratedPartitionsReport("task1", Arrays.asList(this.createRangePartitionStat(day1, 1), this.createRangePartitionStat(day2, 7), this.createRangePartitionStat(day1, 0), this.createRangePartitionStat(day2, 1)), null));
            taskIdToReport.put("task2", new GeneratedPartitionsReport("task2", Arrays.asList(this.createRangePartitionStat(day1, 4), this.createRangePartitionStat(day1, 6), this.createRangePartitionStat(day2, 1), this.createRangePartitionStat(day1, 1)), null));
            Map partitionToLocations = ParallelIndexSupervisorTask.getPartitionToLocations(taskIdToReport);
            Assert.assertEquals((long)6L, (long)partitionToLocations.size());
            this.verifyPartitionIdAndLocations(day1, 0, partitionToLocations, 0, "task1");
            this.verifyPartitionIdAndLocations(day1, 1, partitionToLocations, 1, "task1", "task2");
            this.verifyPartitionIdAndLocations(day1, 4, partitionToLocations, 2, "task2");
            this.verifyPartitionIdAndLocations(day1, 6, partitionToLocations, 3, "task2");
            this.verifyPartitionIdAndLocations(day2, 1, partitionToLocations, 0, "task1", "task2");
            this.verifyPartitionIdAndLocations(day2, 7, partitionToLocations, 1, "task1");
        }

        private PartitionStat createRangePartitionStat(Interval interval, int bucketId) {
            return new DeepStoragePartitionStat(interval, (BucketNumberedShardSpec)new DimensionRangeBucketShardSpec(bucketId, Arrays.asList("dim1", "dim2"), null, null), new HashMap());
        }

        private void verifyPartitionIdAndLocations(Interval interval, int bucketId, Map<ParallelIndexSupervisorTask.Partition, List<PartitionLocation>> partitionToLocations, int expectedPartitionId, String ... expectedTaskIds) {
            ParallelIndexSupervisorTask.Partition partition = new ParallelIndexSupervisorTask.Partition(interval, bucketId);
            List<PartitionLocation> locations = partitionToLocations.get(partition);
            Assert.assertEquals((long)expectedTaskIds.length, (long)locations.size());
            HashSet<String> observedTaskIds = new HashSet<String>();
            for (PartitionLocation location : locations) {
                Assert.assertEquals((long)bucketId, (long)location.getBucketId());
                Assert.assertEquals((Object)interval, (Object)location.getInterval());
                Assert.assertEquals((long)expectedPartitionId, (long)location.getShardSpec().getPartitionNum());
                observedTaskIds.add(location.getSubTaskId());
            }
            Assert.assertEquals(new HashSet<String>(Arrays.asList(expectedTaskIds)), observedTaskIds);
        }
    }

    public static class ConstructorTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testFailToConstructWhenBothAppendToExistingAndForceGuaranteedRollupAreSet() {
            boolean appendToExisting = true;
            boolean forceGuaranteedRollup = true;
            ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig(null, (InputSource)new InlineInputSource("test"), (InputFormat)new JsonInputFormat(null, null, null), Boolean.valueOf(true), null);
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(10), null), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(true), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(10), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null, null);
            ParallelIndexIngestionSpec indexIngestionSpec = new ParallelIndexIngestionSpec(new DataSchema("datasource", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, null, null, null), ioConfig, tuningConfig);
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Perfect rollup cannot be guaranteed when appending to existing dataSources");
            new ParallelIndexSupervisorTask(null, null, null, indexIngestionSpec, null);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class CreateMergeIoConfigsTest {
        private static final int TOTAL_NUM_MERGE_TASKS = 10;
        private static final Function<List<PartitionLocation>, PartialSegmentMergeIOConfig> CREATE_PARTIAL_SEGMENT_MERGE_IO_CONFIG = PartialSegmentMergeIOConfig::new;
        public int count;
        public String partitionLocationType;

        @Parameterized.Parameters(name="count = {0}, partitionLocationType = {1}")
        public static Iterable<? extends Object[]> data() {
            return Arrays.asList({20, "local"}, {24, "deepstore"}, {25, "local"}, {27, "deepstore"});
        }

        public CreateMergeIoConfigsTest(int count, String partitionLocationType) {
            this.count = count;
            this.partitionLocationType = partitionLocationType;
        }

        @Test
        public void handlesLastPartitionCorrectly() {
            List<PartialSegmentMergeIOConfig> assignedPartitionLocation = this.createMergeIOConfigs();
            CreateMergeIoConfigsTest.assertNoMissingPartitions(this.count, assignedPartitionLocation);
        }

        @Test
        public void sizesPartitionsEvenly() {
            List<PartialSegmentMergeIOConfig> assignedPartitionLocation = this.createMergeIOConfigs();
            List actualPartitionSizes = assignedPartitionLocation.stream().map(i -> i.getPartitionLocations().size()).collect(Collectors.toList());
            List sortedPartitionSizes = Ordering.natural().sortedCopy(actualPartitionSizes);
            int minPartitionSize = (Integer)sortedPartitionSizes.get(0);
            int maxPartitionSize = (Integer)sortedPartitionSizes.get(sortedPartitionSizes.size() - 1);
            int partitionSizeRange = maxPartitionSize - minPartitionSize;
            Assert.assertThat((String)("partition sizes = " + actualPartitionSizes), (Object)partitionSizeRange, (Matcher)Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))).and(Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(1)))));
        }

        private List<PartialSegmentMergeIOConfig> createMergeIOConfigs() {
            return ParallelIndexSupervisorTask.createMergeIOConfigs((int)10, CreateMergeIoConfigsTest.createPartitionToLocations(this.count, this.partitionLocationType), CREATE_PARTIAL_SEGMENT_MERGE_IO_CONFIG);
        }

        private static Map<ParallelIndexSupervisorTask.Partition, List<PartitionLocation>> createPartitionToLocations(int count, String partitionLocationType) {
            return IntStream.range(0, count).boxed().collect(Collectors.toMap(i -> new ParallelIndexSupervisorTask.Partition(CreateMergeIoConfigsTest.createInterval(i), i.intValue()), i -> Collections.singletonList(CreateMergeIoConfigsTest.createPartitionLocation(i, partitionLocationType))));
        }

        private static PartitionLocation createPartitionLocation(int id, String partitionLocationType) {
            if ("deepstore".equals(partitionLocationType)) {
                return new DeepStoragePartitionLocation("", Intervals.of((String)"2000/2099"), (BuildingShardSpec)new BuildingHashBasedNumberedShardSpec(id, id, id + 1, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper()), (Map)ImmutableMap.of());
            }
            return new GenericPartitionLocation("host", 0, false, "subTaskId", CreateMergeIoConfigsTest.createInterval(id), (BuildingShardSpec)new BuildingHashBasedNumberedShardSpec(id, id, id + 1, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper()));
        }

        private static Interval createInterval(int id) {
            return Intervals.utc((long)id, (long)(id + 1));
        }

        private static void assertNoMissingPartitions(int count, List<PartialSegmentMergeIOConfig> assignedPartitionLocation) {
            List expectedIds = IntStream.range(0, count).boxed().collect(Collectors.toList());
            List actualIds = assignedPartitionLocation.stream().flatMap(i -> i.getPartitionLocations().stream().map(PartitionLocation::getBucketId)).sorted().collect(Collectors.toList());
            Assert.assertEquals(expectedIds, actualIds);
        }
    }
}

