/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionCardinalityReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionCardinalityTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.core.LogEvent;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class PartialDimensionCardinalityTaskTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private static final HashedPartitionsSpec HASHED_PARTITIONS_SPEC = HashedPartitionsSpec.defaultSpec();

    private static class PartialDimensionCardinalityTaskBuilder {
        private static final InputFormat INPUT_FORMAT = ParallelIndexTestingFactory.getInputFormat();
        private String id = "id";
        private InputSource inputSource = new InlineInputSource("row-with-invalid-timestamp");
        private ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)PartialDimensionCardinalityTaskTest.access$200()).build();
        private DataSchema dataSchema = ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS).withGranularitySpec((GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, (List)ImmutableList.of((Object)Intervals.of((String)"1970-01-01T00:00:00Z/P10D"))));

        private PartialDimensionCardinalityTaskBuilder() {
        }

        PartialDimensionCardinalityTaskBuilder id(String id) {
            this.id = id;
            return this;
        }

        PartialDimensionCardinalityTaskBuilder inputSource(InputSource inputSource) {
            this.inputSource = inputSource;
            return this;
        }

        PartialDimensionCardinalityTaskBuilder tuningConfig(ParallelIndexTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        PartialDimensionCardinalityTaskBuilder dataSchema(DataSchema dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        PartialDimensionCardinalityTaskBuilder withDimensions(List<String> dims) {
            this.dataSchema = this.dataSchema.withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(dims)));
            return this;
        }

        PartialDimensionCardinalityTask build() {
            ParallelIndexIngestionSpec ingestionSpec = ParallelIndexTestingFactory.createIngestionSpec(this.inputSource, INPUT_FORMAT, this.tuningConfig, this.dataSchema);
            return new PartialDimensionCardinalityTask(this.id, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, ingestionSpec, ParallelIndexTestingFactory.CONTEXT, OBJECT_MAPPER);
        }
    }

    public static class RunTaskTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();
        @Rule
        public TemporaryFolder temporaryFolder = new TemporaryFolder();
        @Rule
        public LoggerCaptureRule logger = new LoggerCaptureRule(ParseExceptionHandler.class);
        private Capture<SubTaskReport> reportCapture;
        private TaskToolbox taskToolbox;

        @Before
        public void setup() {
            this.reportCapture = Capture.newInstance();
            final ParallelIndexSupervisorTaskClient taskClient = (ParallelIndexSupervisorTaskClient)EasyMock.mock(ParallelIndexSupervisorTaskClient.class);
            taskClient.report((String)EasyMock.eq((Object)"supervisor-task-id"), (SubTaskReport)EasyMock.capture(this.reportCapture));
            EasyMock.replay((Object[])new Object[]{taskClient});
            this.taskToolbox = (TaskToolbox)EasyMock.mock(TaskToolbox.class);
            EasyMock.expect((Object)this.taskToolbox.getIndexingTmpDir()).andStubReturn((Object)this.temporaryFolder.getRoot());
            EasyMock.expect((Object)this.taskToolbox.getSupervisorTaskClientFactory()).andReturn((Object)new IndexTaskClientFactory<ParallelIndexSupervisorTaskClient>(){

                public ParallelIndexSupervisorTaskClient build(TaskInfoProvider taskInfoProvider, String callerId, int numThreads, Duration httpTimeout, long numRetries) {
                    return taskClient;
                }
            });
            EasyMock.expect((Object)this.taskToolbox.getIndexingServiceClient()).andReturn((Object)new NoopIndexingServiceClient());
            EasyMock.expect((Object)this.taskToolbox.getRowIngestionMetersFactory()).andReturn((Object)new DropwizardRowIngestionMetersFactory());
            EasyMock.replay((Object[])new Object[]{this.taskToolbox});
        }

        @Test
        public void requiresPartitionDimension() throws Exception {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("partitionDimensions must be specified");
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().partitionDimension(null).build()).build();
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
        }

        @Test
        public void logsParseExceptionsIfEnabled() throws Exception {
            long invalidTimestamp = Long.MAX_VALUE;
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(invalidTimestamp, "a"));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)HASHED_PARTITIONS_SPEC).logParseExceptions(true).build();
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().inputSource((InputSource)inlineInputSource).tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
            List logEvents = this.logger.getLogEvents();
            Assert.assertEquals((long)1L, (long)logEvents.size());
            String logMessage = ((LogEvent)logEvents.get(0)).getMessage().getFormattedMessage();
            Assert.assertThat((Object)logMessage, (Matcher)Matchers.containsString((String)"Encountered parse exception"));
        }

        @Test
        public void doesNotLogParseExceptionsIfDisabled() throws Exception {
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)HASHED_PARTITIONS_SPEC).logParseExceptions(false).build();
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
            Assert.assertEquals(Collections.emptyList(), (Object)this.logger.getLogEvents());
        }

        @Test
        public void failsWhenTooManyParseExceptions() throws Exception {
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)HASHED_PARTITIONS_SPEC).maxParseExceptions(0).build();
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().tuningConfig(tuningConfig).build();
            this.exception.expect(RuntimeException.class);
            this.exception.expectMessage("Max parse exceptions[0] exceeded");
            task.runTask(this.taskToolbox);
        }

        @Test
        public void sendsCorrectReportWhenRowHasMultipleDimensionValues() {
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(0L, Arrays.asList("a", "b")));
            PartialDimensionCardinalityTaskBuilder taskBuilder = new PartialDimensionCardinalityTaskBuilder().inputSource((InputSource)inlineInputSource);
            DimensionCardinalityReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToCardinalities = report.getIntervalToCardinalities();
            byte[] hllSketchBytes = (byte[])Iterables.getOnlyElement(intervalToCardinalities.values());
            HllSketch hllSketch = HllSketch.wrap((Memory)Memory.wrap((byte[])hllSketchBytes));
            Assert.assertNotNull((Object)hllSketch);
            Assert.assertEquals((long)1L, (long)((long)hllSketch.getEstimate()));
        }

        @Test
        public void sendsCorrectReportWhenNonEmptyPartitionDimension() {
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRowFromMap(0L, (Map<String, Object>)ImmutableMap.of((Object)"dim1", (Object)"a", (Object)"dim2", (Object)"1")) + "\n" + ParallelIndexTestingFactory.createRowFromMap(0L, (Map<String, Object>)ImmutableMap.of((Object)"dim1", (Object)"a", (Object)"dim2", (Object)"2")) + "\n" + ParallelIndexTestingFactory.createRowFromMap(0L, (Map<String, Object>)ImmutableMap.of((Object)"dim1", (Object)"b", (Object)"dim2", (Object)"3")) + "\n" + ParallelIndexTestingFactory.createRowFromMap(0L, (Map<String, Object>)ImmutableMap.of((Object)"dim1", (Object)"b", (Object)"dim2", (Object)"4")));
            HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, null, Collections.singletonList("dim1"));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)partitionsSpec).build();
            PartialDimensionCardinalityTaskBuilder taskBuilder = new PartialDimensionCardinalityTaskBuilder().inputSource((InputSource)inlineInputSource).tuningConfig(tuningConfig).withDimensions(Arrays.asList("dim1", "dim2"));
            DimensionCardinalityReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToCardinalities = report.getIntervalToCardinalities();
            byte[] hllSketchBytes = (byte[])Iterables.getOnlyElement(intervalToCardinalities.values());
            HllSketch hllSketch = HllSketch.wrap((Memory)Memory.wrap((byte[])hllSketchBytes));
            Assert.assertNotNull((Object)hllSketch);
            Assert.assertEquals((long)4L, (long)((long)hllSketch.getEstimate()));
        }

        @Test
        public void sendsCorrectReportWithMultipleIntervalsInData() {
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(DateTimes.of((String)"1970-01-01T00:00:00.001Z").getMillis(), "a") + "\n" + ParallelIndexTestingFactory.createRow(DateTimes.of((String)"1970-01-02T03:46:40.000Z").getMillis(), "b") + "\n" + ParallelIndexTestingFactory.createRow(DateTimes.of((String)"1970-01-02T03:46:40.000Z").getMillis(), "c") + "\n" + ParallelIndexTestingFactory.createRow(DateTimes.of((String)"1970-01-02T04:02:40.000Z").getMillis(), "b") + "\n" + ParallelIndexTestingFactory.createRow(DateTimes.of((String)"1970-01-02T05:19:10.000Z").getMillis(), "b"));
            PartialDimensionCardinalityTaskBuilder taskBuilder = new PartialDimensionCardinalityTaskBuilder().inputSource((InputSource)inlineInputSource);
            DimensionCardinalityReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToCardinalities = report.getIntervalToCardinalities();
            Assert.assertEquals((long)2L, (long)intervalToCardinalities.size());
            byte[] hllSketchBytes = (byte[])intervalToCardinalities.get(Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-02T00:00:00.000Z"));
            HllSketch hllSketch = HllSketch.wrap((Memory)Memory.wrap((byte[])hllSketchBytes));
            Assert.assertNotNull((Object)hllSketch);
            Assert.assertEquals((long)1L, (long)((long)hllSketch.getEstimate()));
            hllSketchBytes = (byte[])intervalToCardinalities.get(Intervals.of((String)"1970-01-02T00:00:00.000Z/1970-01-03T00:00:00.000Z"));
            hllSketch = HllSketch.wrap((Memory)Memory.wrap((byte[])hllSketchBytes));
            Assert.assertNotNull((Object)hllSketch);
            Assert.assertEquals((long)4L, (long)((long)hllSketch.getEstimate()));
        }

        @Test
        public void returnsSuccessIfNoExceptions() throws Exception {
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().build();
            TaskStatus taskStatus = task.runTask(this.taskToolbox);
            Assert.assertEquals((Object)"id", (Object)taskStatus.getId());
            Assert.assertEquals((Object)TaskState.SUCCESS, (Object)taskStatus.getStatusCode());
        }

        private DimensionCardinalityReport runTask(PartialDimensionCardinalityTaskBuilder taskBuilder) {
            try {
                taskBuilder.build().runTask(this.taskToolbox);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return (DimensionCardinalityReport)this.reportCapture.getValue();
        }
    }

    public static class ConstructorTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void requiresForceGuaranteedRollup() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("forceGuaranteedRollup must be set");
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().forceGuaranteedRollup(false).partitionsSpec((PartitionsSpec)new DynamicPartitionsSpec(null, null)).build();
            new PartialDimensionCardinalityTaskBuilder().tuningConfig(tuningConfig).build();
        }

        @Test
        public void requiresHashedPartitions() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("hashed partitionsSpec required");
            SingleDimensionPartitionsSpec partitionsSpec = new SingleDimensionPartitionsSpec(null, Integer.valueOf(1), "a", false);
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)partitionsSpec).build();
            new PartialDimensionCardinalityTaskBuilder().tuningConfig(tuningConfig).build();
        }

        @Test
        public void serializesDeserializes() {
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().build();
            TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)task);
        }

        @Test
        public void hasCorrectPrefixForAutomaticId() {
            PartialDimensionCardinalityTask task = new PartialDimensionCardinalityTaskBuilder().id(ParallelIndexTestingFactory.AUTOMATIC_ID).build();
            Assert.assertThat((Object)task.getId(), (Matcher)Matchers.startsWith((String)"partial_dimension_cardinality"));
        }
    }
}

