/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionDistributionReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionDistributionTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketch;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.apache.logging.log4j.core.LogEvent;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class PartialDimensionDistributionTaskTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private static final SingleDimensionPartitionsSpec SINGLE_DIM_PARTITIONS_SPEC = new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().build();

    private static class PartialDimensionDistributionTaskBuilder {
        private static final InputFormat INPUT_FORMAT = ParallelIndexTestingFactory.getInputFormat();
        private String id = "id";
        private InputSource inputSource = new InlineInputSource("row-with-invalid-timestamp");
        private ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().build()).build();
        private DataSchema dataSchema = ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS);
        private Supplier<PartialDimensionDistributionTask.DedupInputRowFilter> dedupRowDimValueFilterSupplier = null;

        private PartialDimensionDistributionTaskBuilder() {
        }

        PartialDimensionDistributionTaskBuilder id(String id) {
            this.id = id;
            return this;
        }

        PartialDimensionDistributionTaskBuilder inputSource(InputSource inputSource) {
            this.inputSource = inputSource;
            return this;
        }

        PartialDimensionDistributionTaskBuilder tuningConfig(ParallelIndexTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        PartialDimensionDistributionTaskBuilder dataSchema(DataSchema dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        PartialDimensionDistributionTaskBuilder dedupRowDimValueFilterSupplier(Supplier<PartialDimensionDistributionTask.DedupInputRowFilter> dedupRowDimValueFilterSupplier) {
            this.dedupRowDimValueFilterSupplier = dedupRowDimValueFilterSupplier;
            return this;
        }

        PartialDimensionDistributionTask build() {
            ParallelIndexIngestionSpec ingestionSpec = ParallelIndexTestingFactory.createIngestionSpec(this.inputSource, INPUT_FORMAT, this.tuningConfig, this.dataSchema);
            Supplier<PartialDimensionDistributionTask.DedupInputRowFilter> supplier = this.dedupRowDimValueFilterSupplier == null ? () -> new PartialDimensionDistributionTask.DedupInputRowFilter(this.dataSchema.getGranularitySpec().getQueryGranularity()) : this.dedupRowDimValueFilterSupplier;
            return new PartialDimensionDistributionTask(this.id, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, ingestionSpec, ParallelIndexTestingFactory.CONTEXT, supplier);
        }
    }

    public static class RunTaskTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();
        @Rule
        public TemporaryFolder temporaryFolder = new TemporaryFolder();
        @Rule
        public LoggerCaptureRule logger = new LoggerCaptureRule(ParseExceptionHandler.class);
        private Capture<SubTaskReport> reportCapture;
        private TaskToolbox taskToolbox;

        @Before
        public void setup() {
            this.reportCapture = Capture.newInstance();
            final ParallelIndexSupervisorTaskClient taskClient = (ParallelIndexSupervisorTaskClient)EasyMock.mock(ParallelIndexSupervisorTaskClient.class);
            taskClient.report((String)EasyMock.eq((Object)"supervisor-task-id"), (SubTaskReport)EasyMock.capture(this.reportCapture));
            EasyMock.replay((Object[])new Object[]{taskClient});
            this.taskToolbox = (TaskToolbox)EasyMock.mock(TaskToolbox.class);
            EasyMock.expect((Object)this.taskToolbox.getIndexingTmpDir()).andStubReturn((Object)this.temporaryFolder.getRoot());
            EasyMock.expect((Object)this.taskToolbox.getSupervisorTaskClientFactory()).andReturn((Object)new IndexTaskClientFactory<ParallelIndexSupervisorTaskClient>(){

                public ParallelIndexSupervisorTaskClient build(TaskInfoProvider taskInfoProvider, String callerId, int numThreads, Duration httpTimeout, long numRetries) {
                    return taskClient;
                }
            });
            EasyMock.expect((Object)this.taskToolbox.getIndexingServiceClient()).andReturn((Object)new NoopIndexingServiceClient());
            EasyMock.expect((Object)this.taskToolbox.getRowIngestionMetersFactory()).andReturn((Object)new DropwizardRowIngestionMetersFactory());
            EasyMock.replay((Object[])new Object[]{this.taskToolbox});
        }

        @Test
        public void requiresPartitionDimensions() throws Exception {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("partitionDimensions must be specified");
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().partitionDimension(null).build()).build();
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
        }

        @Test
        public void logsParseExceptionsIfEnabled() throws Exception {
            long invalidTimestamp = Long.MAX_VALUE;
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(invalidTimestamp, "a"));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)SINGLE_DIM_PARTITIONS_SPEC).logParseExceptions(true).build();
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().inputSource((InputSource)inlineInputSource).tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
            List logEvents = this.logger.getLogEvents();
            Assert.assertEquals((long)1L, (long)logEvents.size());
            String logMessage = ((LogEvent)logEvents.get(0)).getMessage().getFormattedMessage();
            Assert.assertThat((Object)logMessage, (Matcher)Matchers.containsString((String)"Encountered parse exception"));
        }

        @Test
        public void doesNotLogParseExceptionsIfDisabled() throws Exception {
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)SINGLE_DIM_PARTITIONS_SPEC).logParseExceptions(false).build();
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).build();
            task.runTask(this.taskToolbox);
            Assert.assertEquals(Collections.emptyList(), (Object)this.logger.getLogEvents());
        }

        @Test
        public void failsWhenTooManyParseExceptions() throws Exception {
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)SINGLE_DIM_PARTITIONS_SPEC).maxParseExceptions(0).build();
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).build();
            this.exception.expect(RuntimeException.class);
            this.exception.expectMessage("Max parse exceptions[0] exceeded");
            task.runTask(this.taskToolbox);
        }

        @Test
        public void failsIfRowHasMultipleDimensionValues() {
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(0L, Arrays.asList("a", "b")));
            PartialDimensionDistributionTaskBuilder taskBuilder = new PartialDimensionDistributionTaskBuilder().inputSource((InputSource)inlineInputSource);
            this.exception.expect(RuntimeException.class);
            this.exception.expectMessage("Cannot partition on multi-value dimension [dim]");
            this.runTask(taskBuilder);
        }

        @Test
        public void sendsCorrectReportWhenAssumeGroupedTrue() {
            long timestamp = 0L;
            String dimensionValue = "a";
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(timestamp, dimensionValue) + "\n" + ParallelIndexTestingFactory.createRow(timestamp + 1L, dimensionValue));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().assumeGrouped(true).build()).build();
            PartialDimensionDistributionTaskBuilder taskBuilder = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).inputSource((InputSource)inlineInputSource);
            DimensionDistributionReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToDistribution = report.getIntervalToDistribution();
            StringDistribution distribution = (StringDistribution)Iterables.getOnlyElement(intervalToDistribution.values());
            Assert.assertNotNull((Object)distribution);
            PartitionBoundaries partitions = distribution.getEvenPartitionsByMaxSize(1);
            Assert.assertEquals((long)2L, (long)partitions.size());
            Assert.assertNull((Object)partitions.get(0));
            Assert.assertNull((Object)partitions.get(1));
        }

        @Test
        public void groupsRowsWhenAssumeGroupedFalse() {
            long timestamp = 0L;
            String dimensionValue = "a";
            InlineInputSource inlineInputSource = new InlineInputSource(ParallelIndexTestingFactory.createRow(timestamp, dimensionValue) + "\n" + ParallelIndexTestingFactory.createRow(timestamp + 1L, dimensionValue));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().assumeGrouped(false).build()).build();
            PartialDimensionDistributionTaskBuilder taskBuilder = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).inputSource((InputSource)inlineInputSource);
            DimensionDistributionReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToDistribution = report.getIntervalToDistribution();
            StringDistribution distribution = (StringDistribution)Iterables.getOnlyElement(intervalToDistribution.values());
            Assert.assertNotNull((Object)distribution);
            PartitionBoundaries partitions = distribution.getEvenPartitionsByMaxSize(1);
            Assert.assertEquals((long)2L, (long)partitions.size());
            Assert.assertNull((Object)partitions.get(0));
            Assert.assertNull((Object)partitions.get(1));
        }

        @Test
        public void preservesMinAndMaxWhenAssumeGroupedFalse() {
            int smallBloomFilter = 1;
            double manyFalsePositiveBloomFilter = 0.5;
            int minBloomFilterBits = 64;
            long timestamp = 0L;
            List dimensionValues = IntStream.range(0, minBloomFilterBits * 10).mapToObj(i -> StringUtils.format((String)"%010d", (Object[])new Object[]{i})).collect(Collectors.toCollection(ArrayList::new));
            List rows = dimensionValues.stream().map(d -> ParallelIndexTestingFactory.createRow(timestamp, d)).collect(Collectors.toList());
            Joiner joiner = Joiner.on((String)"\n");
            InlineInputSource inlineInputSource = new InlineInputSource(joiner.join((Object)joiner.join(rows.subList(1, rows.size())), rows.get(0), new Object[]{rows.get(rows.size() - 1)}));
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().assumeGrouped(false).build()).build();
            DataSchema dataSchema = ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS);
            PartialDimensionDistributionTaskBuilder taskBuilder = new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).dataSchema(dataSchema).inputSource((InputSource)inlineInputSource).dedupRowDimValueFilterSupplier(() -> new PartialDimensionDistributionTask.DedupInputRowFilter(dataSchema.getGranularitySpec().getQueryGranularity(), smallBloomFilter, manyFalsePositiveBloomFilter));
            DimensionDistributionReport report = this.runTask(taskBuilder);
            Assert.assertEquals((Object)"id", (Object)report.getTaskId());
            Map intervalToDistribution = report.getIntervalToDistribution();
            StringDistribution distribution = (StringDistribution)Iterables.getOnlyElement(intervalToDistribution.values());
            Assert.assertNotNull((Object)distribution);
            PartitionBoundaries partitions = distribution.getEvenPartitionsByMaxSize(1);
            Assert.assertEquals((long)(minBloomFilterBits + 2), (long)partitions.size());
            StringTuple minDimensionValue = StringTuple.create((String[])new String[]{(String)dimensionValues.get(0)});
            Assert.assertEquals((Object)minDimensionValue, (Object)((StringSketch)distribution).getMin());
            StringTuple maxDimensionValue = StringTuple.create((String[])new String[]{(String)dimensionValues.get(dimensionValues.size() - 1)});
            Assert.assertEquals((Object)maxDimensionValue, (Object)((StringSketch)distribution).getMax());
        }

        @Test
        public void returnsSuccessIfNoExceptions() throws Exception {
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().build();
            TaskStatus taskStatus = task.runTask(this.taskToolbox);
            Assert.assertEquals((Object)"id", (Object)taskStatus.getId());
            Assert.assertEquals((Object)TaskState.SUCCESS, (Object)taskStatus.getStatusCode());
        }

        private DimensionDistributionReport runTask(PartialDimensionDistributionTaskBuilder taskBuilder) {
            try {
                taskBuilder.build().runTask(this.taskToolbox);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return (DimensionDistributionReport)this.reportCapture.getValue();
        }
    }

    public static class ConstructorTest {
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void requiresForceGuaranteedRollup() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("forceGuaranteedRollup must be set");
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().forceGuaranteedRollup(false).partitionsSpec((PartitionsSpec)new DynamicPartitionsSpec(null, null)).build();
            new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).build();
        }

        @Test
        public void requiresMultiDimensionPartitions() {
            this.exception.expect(IllegalArgumentException.class);
            this.exception.expectMessage("range partitionsSpec required");
            HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(1), null);
            ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)partitionsSpec).build();
            new PartialDimensionDistributionTaskBuilder().tuningConfig(tuningConfig).build();
        }

        @Test
        public void serializesDeserializes() {
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().build();
            TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)task);
        }

        @Test
        public void hasCorrectPrefixForAutomaticId() {
            PartialDimensionDistributionTask task = new PartialDimensionDistributionTaskBuilder().id(ParallelIndexTestingFactory.AUTOMATIC_ID).build();
            Assert.assertThat((Object)task.getId(), (Matcher)Matchers.startsWith((String)"partial_dimension_distribution"));
        }
    }
}

