/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketch;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketchMerger;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StringSketchMergerTest {
    private StringSketchMerger target;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() {
        this.target = new StringSketchMerger();
    }

    @Test
    public void requiresStringSketch() {
        StringDistribution distribution = (StringDistribution)EasyMock.mock(StringDistribution.class);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Only merging StringSketch instances is currently supported");
        this.target.merge(distribution);
    }

    @Test
    public void mergesCorrectly() {
        StringTuple string1 = StringTuple.create((String[])new String[]{"a"});
        StringSketch sketch1 = new StringSketch();
        sketch1.put(string1);
        StringTuple string2 = StringTuple.create((String[])new String[]{"mn"});
        StringSketch sketch2 = new StringSketch();
        sketch2.put(string2);
        StringTuple string3 = StringTuple.create((String[])new String[]{"z"});
        StringSketch sketch3 = new StringSketch();
        sketch3.put(string3);
        this.target.merge((StringDistribution)sketch2);
        this.target.merge((StringDistribution)sketch1);
        this.target.merge((StringDistribution)sketch3);
        StringDistribution merged = this.target.getResult();
        PartitionBoundaries partitions = merged.getEvenPartitionsByMaxSize(1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertNull((Object)partitions.get(0));
        Assert.assertEquals((Object)string2, (Object)partitions.get(1));
        Assert.assertNull((Object)partitions.get(2));
    }
}

