/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketch;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class StringSketchTest {
    private static final int FACTOR = 2;
    private static final int NUM_STRING = 8192;
    private static final double DELTA = ItemsSketch.getNormalizedRankError((int)4096, (boolean)true) * 8192.0;
    private static final List<StringTuple> STRINGS = IntStream.range(0, 8192).mapToObj(i -> StringTuple.create((String[])new String[]{StringUtils.format((String)"%010d", (Object[])new Object[]{i})})).collect(Collectors.toCollection(ArrayList::new));
    private static final StringTuple MIN_STRING = STRINGS.get(0);
    private static final StringTuple MAX_STRING = STRINGS.get(8191);

    static {
        ItemsSketch.rand.setSeed(0L);
    }

    @RunWith(value=Enclosed.class)
    public static class PartitionTest {
        private static final StringSketch SKETCH = new StringSketch();

        private static void assertMaxNumberOfPartitions(PartitionBoundaries partitionBoundaries) {
            String partitionBoundariesString = PartitionTest.toString(partitionBoundaries);
            Assert.assertEquals((String)partitionBoundariesString, (long)4097L, (long)partitionBoundaries.size());
            PartitionTest.assertFirstAndLastPartitionsCorrect(partitionBoundaries);
            int previous = 0;
            for (int i = 1; i < partitionBoundaries.size() - 1; ++i) {
                int current = Integer.parseInt(((StringTuple)partitionBoundaries.get(i)).get(0));
                Assert.assertEquals((String)(PartitionTest.getErrMsgPrefix(1, i) + partitionBoundariesString), (float)1.0f, (float)(current - previous), (float)2.0f);
                previous = current;
            }
        }

        private static void assertSinglePartition(PartitionBoundaries partitionBoundaries) {
            Assert.assertEquals((long)2L, (long)partitionBoundaries.size());
            PartitionTest.assertFirstAndLastPartitionsCorrect(partitionBoundaries);
        }

        private static void assertFirstAndLastPartitionsCorrect(PartitionBoundaries partitionBoundaries) {
            Assert.assertNull((Object)partitionBoundaries.get(0));
            Assert.assertNull((Object)partitionBoundaries.get(partitionBoundaries.size() - 1));
        }

        private static String getErrMsgPrefix(int size, int i) {
            return "size=" + size + " i=" + i + " of ";
        }

        private static String toString(PartitionBoundaries partitionBoundaries) {
            String prefix = "partitionBoundaries[" + partitionBoundaries.size() + "]=";
            StringJoiner sj = new StringJoiner(" ", prefix, "]");
            for (int i = 0; i < partitionBoundaries.size(); ++i) {
                sj.add("[" + i + "]=" + partitionBoundaries.get(i));
            }
            return sj.toString();
        }

        static {
            STRINGS.forEach(arg_0 -> ((StringSketch)SKETCH).put(arg_0));
        }

        public static class MaxSizeTest {
            @Rule
            public ExpectedException exception = ExpectedException.none();

            @Test
            public void requiresPositiveSize() {
                this.exception.expect(IllegalArgumentException.class);
                this.exception.expectMessage("maxSize must be positive but is 0");
                SKETCH.getEvenPartitionsByMaxSize(0);
            }

            @Test
            public void handlesEmptySketch() {
                StringSketch sketch = new StringSketch();
                PartitionBoundaries partitionBoundaries = sketch.getEvenPartitionsByMaxSize(1);
                Assert.assertEquals((long)0L, (long)partitionBoundaries.size());
            }

            @Test
            public void handlesSingletonSketch() {
                StringSketch sketch = new StringSketch();
                sketch.put(MIN_STRING);
                PartitionBoundaries partitionBoundaries = sketch.getEvenPartitionsByMaxSize(1);
                Assert.assertEquals((long)2L, (long)partitionBoundaries.size());
                Assert.assertNull((Object)partitionBoundaries.get(0));
                Assert.assertNull((Object)partitionBoundaries.get(1));
            }

            @Test
            public void handlesMinimimumSize() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByMaxSize(1);
                PartitionTest.assertMaxNumberOfPartitions(partitionBoundaries);
            }

            @Test
            public void handlesUnevenPartitions() {
                List<Integer> maxSizes = Arrays.asList(509, 1021, 2039, 4093);
                maxSizes.forEach(MaxSizeTest::testHandlesUnevenPartitions);
            }

            private static void testHandlesUnevenPartitions(int maxSize) {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByMaxSize(maxSize);
                PartitionTest.assertFirstAndLastPartitionsCorrect(partitionBoundaries);
                String partitionBoundariesString = PartitionTest.toString(partitionBoundaries);
                long expectedPartitionCount = (long)Math.ceil(8192.0 / (double)maxSize);
                Assert.assertEquals((String)("maxSize=" + maxSize + " " + partitionBoundariesString), (long)(expectedPartitionCount + 1L), (long)partitionBoundaries.size());
                double minSize = 8192.0 / (double)expectedPartitionCount - DELTA;
                int previous = 0;
                for (int i = 1; i < partitionBoundaries.size() - 1; ++i) {
                    int current = Integer.parseInt(((StringTuple)partitionBoundaries.get(i)).get(0));
                    int size = current - previous;
                    Assert.assertThat((String)(PartitionTest.getErrMsgPrefix(maxSize, i) + partitionBoundariesString), (Object)size, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maxSize)));
                    Assert.assertThat((String)(PartitionTest.getErrMsgPrefix(maxSize, i) + partitionBoundariesString), (Object)size, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(minSize)));
                    previous = current;
                }
            }

            @Test
            public void handlesSinglePartition() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByMaxSize((int)Math.ceil(8192.0 + DELTA));
                PartitionTest.assertSinglePartition(partitionBoundaries);
            }

            @Test
            public void handlesOversizedPartition() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByMaxSize(Integer.MAX_VALUE);
                PartitionTest.assertSinglePartition(partitionBoundaries);
            }
        }

        public static class TargetSizeTest {
            @Rule
            public ExpectedException exception = ExpectedException.none();

            @Test
            public void requiresPositiveSize() {
                this.exception.expect(IllegalArgumentException.class);
                this.exception.expectMessage("targetSize must be positive but is 0");
                SKETCH.getEvenPartitionsByTargetSize(0);
            }

            @Test
            public void handlesEmptySketch() {
                StringSketch sketch = new StringSketch();
                PartitionBoundaries partitionBoundaries = sketch.getEvenPartitionsByTargetSize(1);
                Assert.assertEquals((long)0L, (long)partitionBoundaries.size());
            }

            @Test
            public void handlesSingletonSketch() {
                StringSketch sketch = new StringSketch();
                sketch.put(MIN_STRING);
                PartitionBoundaries partitionBoundaries = sketch.getEvenPartitionsByTargetSize(1);
                Assert.assertEquals((long)2L, (long)partitionBoundaries.size());
                Assert.assertNull((Object)partitionBoundaries.get(0));
                Assert.assertNull((Object)partitionBoundaries.get(1));
            }

            @Test
            public void handlesMinimimumSize() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByTargetSize(1);
                PartitionTest.assertMaxNumberOfPartitions(partitionBoundaries);
            }

            @Test
            public void handlesUnevenPartitions() {
                List<Integer> targetSizes = Arrays.asList(127, 257, 509, 1021, 2039, 4093);
                targetSizes.forEach(TargetSizeTest::testHandlesUnevenPartitions);
            }

            private static void testHandlesUnevenPartitions(int targetSize) {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByTargetSize(targetSize);
                PartitionTest.assertFirstAndLastPartitionsCorrect(partitionBoundaries);
                String partitionBoundariesString = PartitionTest.toString(partitionBoundaries);
                int expectedHighPartitionBoundaryCount = (int)Math.ceil(8192.0 / (double)targetSize);
                int expectedLowPartitionBoundaryCount = expectedHighPartitionBoundaryCount - 1;
                Assert.assertThat((String)("targetSize=" + targetSize + " " + partitionBoundariesString), (Object)partitionBoundaries.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(expectedHighPartitionBoundaryCount + 1)));
                Assert.assertThat((String)("targetSize=" + targetSize + " " + partitionBoundariesString), (Object)partitionBoundaries.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(expectedLowPartitionBoundaryCount + 1)));
                int previous = 0;
                for (int i = 1; i < partitionBoundaries.size() - 1; ++i) {
                    int current = Integer.parseInt(((StringTuple)partitionBoundaries.get(i)).get(0));
                    int size = current - previous;
                    Assert.assertThat((String)(PartitionTest.getErrMsgPrefix(targetSize, i) + partitionBoundariesString), (Object)size, (Matcher)IsCloseTo.closeTo((double)targetSize, (double)(Math.ceil(DELTA) * 2.0)));
                    previous = current;
                }
            }

            @Test
            public void handlesSinglePartition() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByTargetSize(8192);
                PartitionTest.assertSinglePartition(partitionBoundaries);
            }

            @Test
            public void handlesOversizedPartition() {
                PartitionBoundaries partitionBoundaries = SKETCH.getEvenPartitionsByTargetSize(Integer.MAX_VALUE);
                PartitionTest.assertSinglePartition(partitionBoundaries);
            }
        }
    }

    public static class PutTest {
        private StringSketch target;

        @Before
        public void setup() {
            this.target = new StringSketch();
        }

        @Test
        public void putIfNewMin() {
            StringTuple value = MAX_STRING;
            Assert.assertEquals((long)0L, (long)this.getCount());
            this.target.putIfNewMin(value);
            Assert.assertEquals((long)1L, (long)this.getCount());
            this.target.putIfNewMin(value);
            Assert.assertEquals((long)1L, (long)this.getCount());
            Assert.assertEquals((Object)value, (Object)this.target.getDelegate().getMinValue());
            Assert.assertEquals((Object)value, (Object)this.target.getDelegate().getMaxValue());
            this.target.putIfNewMin(MIN_STRING);
            Assert.assertEquals((long)2L, (long)this.getCount());
            Assert.assertEquals((Object)MIN_STRING, (Object)this.target.getDelegate().getMinValue());
            Assert.assertEquals((Object)MAX_STRING, (Object)this.target.getDelegate().getMaxValue());
        }

        @Test
        public void putIfNewMax() {
            StringTuple value = MIN_STRING;
            Assert.assertEquals((long)0L, (long)this.getCount());
            this.target.putIfNewMax(value);
            Assert.assertEquals((long)1L, (long)this.getCount());
            this.target.putIfNewMax(value);
            Assert.assertEquals((long)1L, (long)this.getCount());
            Assert.assertEquals((Object)value, (Object)this.target.getDelegate().getMinValue());
            Assert.assertEquals((Object)value, (Object)this.target.getDelegate().getMaxValue());
            this.target.putIfNewMax(MAX_STRING);
            Assert.assertEquals((long)2L, (long)this.getCount());
            Assert.assertEquals((Object)MIN_STRING, (Object)this.target.getDelegate().getMinValue());
            Assert.assertEquals((Object)MAX_STRING, (Object)this.target.getDelegate().getMaxValue());
        }

        private long getCount() {
            return this.target.getDelegate().getN();
        }
    }

    public static class SerializationDeserializationTest {
        private static final ObjectMapper OBJECT_MAPPER = new JacksonModule().smileMapper();

        @Test
        public void serializesDeserializes() {
            StringSketch target = new StringSketch();
            target.put(MIN_STRING);
            target.put(MAX_STRING);
            TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)target);
        }

        @Test
        public void abidesEqualsContract() {
            EqualsVerifier.forClass(StringSketch.class).usingGetClass().withNonnullFields(new String[]{"delegate"}).verify();
        }
    }
}

