/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import java.util.Collections;
import java.util.List;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilderTestingFactory;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class DefaultIndexTaskInputRowIteratorBuilderTest {

    public static class HandlerTest {
        private static final IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester HANDLER_TESTER = IndexTaskInputRowIteratorBuilderTestingFactory.createHandlerTester(DefaultIndexTaskInputRowIteratorBuilder::new);
        private static final InputRow NO_NEXT_INPUT_ROW = null;
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void invokesAppendedHandlersLast() {
            DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
            InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp);
            CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
            GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
            List<HandlingInputRowIterator.InputRowHandler> appendedHandlers = Collections.singletonList(row -> true);
            List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, appendedHandlers, NO_NEXT_INPUT_ROW);
            Assert.assertEquals(Collections.singletonList(IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler.APPENDED), handlerInvocationHistory);
        }

        @Test
        public void doesNotInvokeHandlersIfRowValid() {
            DateTime timestamp = DateTimes.utc((long)0L);
            InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp);
            CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
            GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
            List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, inputRow);
            Assert.assertEquals(Collections.emptyList(), handlerInvocationHistory);
        }
    }

    public static class BuildTest {
        private static final CloseableIterator<InputRow> ITERATOR = (CloseableIterator)EasyMock.mock(CloseableIterator.class);
        private static final GranularitySpec GRANULARITY_SPEC = (GranularitySpec)EasyMock.mock(GranularitySpec.class);
        @Rule
        public ExpectedException exception = ExpectedException.none();

        @Test
        public void requiresDelegate() {
            this.exception.expect(NullPointerException.class);
            this.exception.expectMessage("delegate required");
            new DefaultIndexTaskInputRowIteratorBuilder().granularitySpec(GRANULARITY_SPEC).build();
        }

        @Test
        public void requiresGranularitySpec() {
            this.exception.expect(NullPointerException.class);
            this.exception.expectMessage("granularitySpec required");
            new DefaultIndexTaskInputRowIteratorBuilder().delegate(ITERATOR).build();
        }

        @Test
        public void succeedsIfAllRequiredPresent() {
            new DefaultIndexTaskInputRowIteratorBuilder().delegate(ITERATOR).granularitySpec(GRANULARITY_SPEC).build();
        }
    }
}

