/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;

class IndexTaskInputRowIteratorBuilderTestingFactory {
    static final DateTime TIMESTAMP = DateTimes.utc((long)0L);
    static final String DIMENSION = "dimension";
    static final List<String> DIMENSIONS = Collections.singletonList("dimension");
    static final Optional<Interval> PRESENT_BUCKET_INTERVAL_OPT = Optional.of((Object)Intervals.ETERNITY);

    IndexTaskInputRowIteratorBuilderTestingFactory() {
    }

    static InputRow createInputRow(DateTime timestamp) {
        return IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, Collections.singletonList(DIMENSION));
    }

    static InputRow createInputRow(DateTime timestamp, List<String> dimensionValues) {
        return new MapBasedInputRow(timestamp, dimensionValues, Collections.singletonMap(DIMENSION, dimensionValues));
    }

    static CloseableIterator<InputRow> createInputRowIterator(final InputRow inputRow) {
        return new CloseableIterator<InputRow>(){

            public void close() {
            }

            public boolean hasNext() {
                return true;
            }

            public InputRow next() {
                return inputRow;
            }
        };
    }

    static GranularitySpec createAbsentBucketIntervalGranularitySpec(DateTime timestamp) {
        return IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, (Optional<Interval>)Optional.absent());
    }

    static GranularitySpec createGranularitySpec(DateTime timestamp, Optional<Interval> bucketIntervalOpt) {
        GranularitySpec granularitySpec = (GranularitySpec)EasyMock.mock(GranularitySpec.class);
        EasyMock.expect((Object)granularitySpec.bucketInterval(timestamp)).andStubReturn(bucketIntervalOpt);
        EasyMock.replay((Object[])new Object[]{granularitySpec});
        return granularitySpec;
    }

    static HandlerTester createHandlerTester(Supplier<IndexTaskInputRowIteratorBuilder> iteratorBuilderSupplier) {
        return new HandlerTester(iteratorBuilderSupplier);
    }

    static class HandlerTester {
        private final Supplier<IndexTaskInputRowIteratorBuilder> iteratorBuilderSupplier;

        private HandlerTester(Supplier<IndexTaskInputRowIteratorBuilder> iteratorBuilderSupplier) {
            this.iteratorBuilderSupplier = iteratorBuilderSupplier;
        }

        List<Handler> invokeHandlers(CloseableIterator<InputRow> inputRowIterator, GranularitySpec granularitySpec, InputRow expectedNextInputRow) {
            return this.invokeHandlers(inputRowIterator, granularitySpec, Collections.emptyList(), expectedNextInputRow);
        }

        List<Handler> invokeHandlers(CloseableIterator<InputRow> inputRowIterator, GranularitySpec granularitySpec, List<HandlingInputRowIterator.InputRowHandler> appendedHandlers, InputRow expectedNextInputRow) {
            ArrayList<Handler> handlerInvocationHistory = new ArrayList<Handler>();
            IndexTaskInputRowIteratorBuilder iteratorBuilder = this.iteratorBuilderSupplier.get().delegate(inputRowIterator).granularitySpec(granularitySpec);
            if (iteratorBuilder instanceof DefaultIndexTaskInputRowIteratorBuilder) {
                appendedHandlers.stream().peek(handler -> handlerInvocationHistory.add(Handler.APPENDED)).forEach(arg_0 -> ((DefaultIndexTaskInputRowIteratorBuilder)((DefaultIndexTaskInputRowIteratorBuilder)iteratorBuilder)).appendInputRowHandler(arg_0));
            }
            HandlingInputRowIterator iterator = iteratorBuilder.build();
            InputRow nextInputRow = iterator.next();
            Assert.assertEquals((Object)expectedNextInputRow, (Object)nextInputRow);
            return handlerInvocationHistory;
        }

        static enum Handler {
            NULL_ROW,
            ABSENT_BUCKET_INTERVAL,
            APPENDED;

        }
    }
}

