/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilderTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.RangePartitionIndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RangePartitionIndexTaskInputRowIteratorBuilderTest {
    private static final boolean SKIP_NULL = true;
    private static final IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester HANDLER_TESTER = IndexTaskInputRowIteratorBuilderTestingFactory.createHandlerTester(() -> new RangePartitionIndexTaskInputRowIteratorBuilder(IndexTaskInputRowIteratorBuilderTestingFactory.DIMENSIONS, true));
    private static final InputRow NO_NEXT_INPUT_ROW = null;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void invokesDimensionValueCountFilterLast() {
        DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
        List<String> nullDimensionValue = Collections.emptyList();
        InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, nullDimensionValue);
        CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
        GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
        List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, NO_NEXT_INPUT_ROW);
        RangePartitionIndexTaskInputRowIteratorBuilderTest.assertNotInHandlerInvocationHistory(handlerInvocationHistory, IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler.NULL_ROW);
        RangePartitionIndexTaskInputRowIteratorBuilderTest.assertNotInHandlerInvocationHistory(handlerInvocationHistory, IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler.ABSENT_BUCKET_INTERVAL);
    }

    @Test
    public void throwsExceptionIfMultipleDimensionValues() {
        DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
        List<String> multipleDimensionValues = Arrays.asList("multiple", "dimension", "values");
        InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, multipleDimensionValues);
        CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
        GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Cannot partition on multi-value dimension [dimension]");
        HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, NO_NEXT_INPUT_ROW);
    }

    @Test
    public void doesNotInvokeHandlersIfRowValid() {
        DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
        List<Object> nullDimensionValue = Collections.singletonList(null);
        InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, nullDimensionValue);
        CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
        GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
        List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, inputRow);
        Assert.assertEquals(Collections.emptyList(), handlerInvocationHistory);
    }

    @Test
    public void invokesHandlerIfRowInvalidNull() {
        DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
        List<String> nullDimensionValue = null;
        InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, nullDimensionValue);
        CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
        GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
        List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = HANDLER_TESTER.invokeHandlers(inputRowIterator, granularitySpec, NO_NEXT_INPUT_ROW);
        RangePartitionIndexTaskInputRowIteratorBuilderTest.assertNotInHandlerInvocationHistory(handlerInvocationHistory, IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler.NULL_ROW);
        RangePartitionIndexTaskInputRowIteratorBuilderTest.assertNotInHandlerInvocationHistory(handlerInvocationHistory, IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler.ABSENT_BUCKET_INTERVAL);
    }

    @Test
    public void doesNotInvokeHandlersIfRowValidNull() {
        DateTime timestamp = IndexTaskInputRowIteratorBuilderTestingFactory.TIMESTAMP;
        List<String> nullDimensionValue = null;
        InputRow inputRow = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRow(timestamp, nullDimensionValue);
        CloseableIterator<InputRow> inputRowIterator = IndexTaskInputRowIteratorBuilderTestingFactory.createInputRowIterator(inputRow);
        GranularitySpec granularitySpec = IndexTaskInputRowIteratorBuilderTestingFactory.createGranularitySpec(timestamp, IndexTaskInputRowIteratorBuilderTestingFactory.PRESENT_BUCKET_INTERVAL_OPT);
        IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester handlerTester = IndexTaskInputRowIteratorBuilderTestingFactory.createHandlerTester(() -> new RangePartitionIndexTaskInputRowIteratorBuilder(IndexTaskInputRowIteratorBuilderTestingFactory.DIMENSIONS, false));
        List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory = handlerTester.invokeHandlers(inputRowIterator, granularitySpec, inputRow);
        Assert.assertEquals(Collections.emptyList(), handlerInvocationHistory);
    }

    private static void assertNotInHandlerInvocationHistory(List<IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler> handlerInvocationHistory, IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler handler) {
        Assert.assertThat(handlerInvocationHistory, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new IndexTaskInputRowIteratorBuilderTestingFactory.HandlerTester.Handler[]{handler})));
    }
}

