/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ForkingTaskRunner;
import org.apache.druid.indexing.overlord.QuotableWhiteSpaceSplitter;
import org.apache.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.NoopTaskLogs;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.assertj.core.util.Lists;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ForkingTaskRunnerTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test(expected=AssertionError.class)
    public void testPatternMatcherFailureForJavaOptions() {
        ForkingTaskRunnerTest.checkValues(new String[]{"not quoted has space"});
    }

    @Test(expected=AssertionError.class)
    public void testPatternMatcherFailureForSpaceOnlyJavaOptions() {
        ForkingTaskRunnerTest.checkValues(new String[]{" "});
    }

    @Test
    public void testPatternMatcherLeavesUnbalancedQuoteJavaOptions() {
        Assert.assertEquals((Object)"\"", (Object)Iterators.get((Iterator)new QuotableWhiteSpaceSplitter("\"").iterator(), (int)0));
    }

    @Test
    public void testPatternMatcherPreservesNonBreakingSpacesJavaOptions() {
        ForkingTaskRunnerTest.checkValues(new String[]{"keep\u00a0me\u00a0around"});
    }

    @Test
    public void testPatternMatcherForSimpleJavaOptions() {
        ForkingTaskRunnerTest.checkValues(new String[]{"test", "-mmm\"some quote with\"suffix", "test2", "\"completely quoted\"", "more", "\u2603", "-XX:SomeCoolOption=false", "-XX:SomeOption=\"with spaces\"", "someValues", "some\"strange looking\"option", "andOtherOptions", "\"\"", "AndMaybeEmptyQuotes", "keep\u00a0me\u00a0around"});
        ForkingTaskRunnerTest.checkValues(new String[]{"\"completely quoted\""});
        ForkingTaskRunnerTest.checkValues(new String[]{"\"\""});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\""});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\"suffix"});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\t\"suffix"});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\t\r\n\f     \"suffix"});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\t\r\n\f     \""});
        ForkingTaskRunnerTest.checkValues(new String[]{"\"\t\r\n\f     \"suffix"});
        ForkingTaskRunnerTest.checkValues(new String[]{"-foo=\"\"suffix", "more"});
    }

    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)ImmutableList.copyOf((Iterable)new QuotableWhiteSpaceSplitter("")).isEmpty());
    }

    @Test
    public void testFarApart() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"start", (Object)"stop"), (Object)ImmutableList.copyOf((Iterable)new QuotableWhiteSpaceSplitter("start\t\t\t\t \n\f\r\n \f\f \n\r\f\n\r\t stop")));
    }

    @Test
    public void testOmitEmpty() {
        Assert.assertTrue((boolean)ImmutableList.copyOf((Iterable)new QuotableWhiteSpaceSplitter(" \t     \t\t\t\t \n\n \f\f \n\f\r\t")).isEmpty());
    }

    private static void checkValues(String[] strings) {
        Assert.assertEquals((Object)ImmutableList.copyOf((Object[])strings), (Object)ImmutableList.copyOf((Iterable)new QuotableWhiteSpaceSplitter(Joiner.on((String)" ").join((Object[])strings))));
    }

    @Test
    public void testMaskedIterator() {
        Pair originalAndExpectedCommand = new Pair((Object)Lists.list((Object[])new String[]{"java -cp", "/path/to/somewhere:some-jars.jar", "/some===file", "/asecretFileNa=me", "-Dsome.property=random", "-Dsome.otherproperty = random=random", "-Dsome.somesecret = secretvalue", "-Dsome.somesecret=secretvalue", "-Dsome.somepassword = secret=value", "-Dsome.some=notasecret", "-Dsome.otherSecret= =asfdhkj352872598====fasdlkjfa="}), (Object)"java -cp /path/to/somewhere:some-jars.jar /some===file /asecretFileNa=<masked> -Dsome.property=random -Dsome.otherproperty = random=random -Dsome.somesecret =<masked> -Dsome.somesecret=<masked> -Dsome.somepassword =<masked> -Dsome.some=notasecret -Dsome.otherSecret=<masked>");
        StartupLoggingConfig startupLoggingConfig = new StartupLoggingConfig();
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), null, new WorkerConfig(), null, null, null, null, startupLoggingConfig);
        Assert.assertEquals((Object)originalAndExpectedCommand.rhs, (Object)forkingTaskRunner.getMaskedCommand(startupLoggingConfig.getMaskProperties(), (List)originalAndExpectedCommand.lhs));
    }

    @Test
    public void testTaskStatusWhenTaskProcessFails() throws ExecutionException, InterruptedException {
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), new Properties(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)new DefaultObjectMapper(), new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false), new StartupLoggingConfig()){

            ForkingTaskRunner.ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) {
                ForkingTaskRunner.ProcessHolder processHolder = (ForkingTaskRunner.ProcessHolder)Mockito.mock(ForkingTaskRunner.ProcessHolder.class);
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).registerWithCloser((Closer)ArgumentMatchers.any());
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).shutdown();
                return processHolder;
            }

            int waitForTaskProcessToComplete(Task task, ForkingTaskRunner.ProcessHolder processHolder, File logFile, File reportsFile) {
                return 1;
            }
        };
        TaskStatus status = (TaskStatus)forkingTaskRunner.run((Task)NoopTask.create()).get();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        Assert.assertEquals((Object)"Task execution process exited unsuccessfully with code[1]. See middleManager logs for more details.", (Object)status.getErrorMsg());
    }

    @Test
    public void testTaskStatusWhenTaskProcessSucceedsTaskSucceeds() throws ExecutionException, InterruptedException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        NoopTask task = NoopTask.create();
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), new Properties(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)mapper, new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false), new StartupLoggingConfig(), (ObjectMapper)mapper, (Task)task){
            final /* synthetic */ ObjectMapper val$mapper;
            final /* synthetic */ Task val$task;
            {
                this.val$mapper = objectMapper;
                this.val$task = task;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            ForkingTaskRunner.ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) throws IOException {
                ForkingTaskRunner.ProcessHolder processHolder = (ForkingTaskRunner.ProcessHolder)Mockito.mock(ForkingTaskRunner.ProcessHolder.class);
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).registerWithCloser((Closer)ArgumentMatchers.any());
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).shutdown();
                for (String param : command) {
                    if (!param.endsWith("status.json")) continue;
                    this.val$mapper.writeValue(new File(param), (Object)TaskStatus.success((String)this.val$task.getId()));
                    break;
                }
                return processHolder;
            }

            int waitForTaskProcessToComplete(Task task, ForkingTaskRunner.ProcessHolder processHolder, File logFile, File reportsFile) {
                return 0;
            }
        };
        TaskStatus status = (TaskStatus)forkingTaskRunner.run((Task)task).get();
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)status.getStatusCode());
        Assert.assertNull((Object)status.getErrorMsg());
    }

    @Test
    public void testTaskStatusWhenTaskProcessSucceedsTaskFails() throws ExecutionException, InterruptedException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        NoopTask task = NoopTask.create();
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), new Properties(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)mapper, new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false), new StartupLoggingConfig(), (ObjectMapper)mapper, (Task)task){
            final /* synthetic */ ObjectMapper val$mapper;
            final /* synthetic */ Task val$task;
            {
                this.val$mapper = objectMapper;
                this.val$task = task;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            ForkingTaskRunner.ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) throws IOException {
                ForkingTaskRunner.ProcessHolder processHolder = (ForkingTaskRunner.ProcessHolder)Mockito.mock(ForkingTaskRunner.ProcessHolder.class);
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).registerWithCloser((Closer)ArgumentMatchers.any());
                ((ForkingTaskRunner.ProcessHolder)Mockito.doNothing().when((Object)processHolder)).shutdown();
                for (String param : command) {
                    if (!param.endsWith("status.json")) continue;
                    this.val$mapper.writeValue(new File(param), (Object)TaskStatus.failure((String)this.val$task.getId(), (String)"task failure test"));
                    break;
                }
                return processHolder;
            }

            int waitForTaskProcessToComplete(Task task, ForkingTaskRunner.ProcessHolder processHolder, File logFile, File reportsFile) {
                return 0;
            }
        };
        TaskStatus status = (TaskStatus)forkingTaskRunner.run((Task)task).get();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        Assert.assertEquals((Object)"task failure test", (Object)status.getErrorMsg());
    }

    @Test
    public void testJavaOptsAndJavaOptsArrayOverride() throws ExecutionException, InterruptedException, JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String taskContent = "{\n  \"type\" : \"noop\",\n  \"id\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"groupId\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"dataSource\" : \"none\",\n  \"runTime\" : 2500,\n  \"isReadyTime\" : 0,\n  \"isReadyResult\" : \"YES\",\n  \"firehose\" : null,\n  \"context\" : {\n    \"druid.indexer.runner.javaOptsArray\" : [ \"-Xmx10g\", \"-Xms10g\" ],\n    \"druid.indexer.runner.javaOpts\" : \"-Xmx1g -Xms1g\"\n  }\n}";
        Task task = (Task)OBJECT_MAPPER.readValue("{\n  \"type\" : \"noop\",\n  \"id\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"groupId\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"dataSource\" : \"none\",\n  \"runTime\" : 2500,\n  \"isReadyTime\" : 0,\n  \"isReadyResult\" : \"YES\",\n  \"firehose\" : null,\n  \"context\" : {\n    \"druid.indexer.runner.javaOptsArray\" : [ \"-Xmx10g\", \"-Xms10g\" ],\n    \"druid.indexer.runner.javaOpts\" : \"-Xmx1g -Xms1g\"\n  }\n}", NoopTask.class);
        final AtomicInteger xmxJavaOptsIndex = new AtomicInteger(-1);
        final AtomicInteger xmxJavaOptsArrayIndex = new AtomicInteger(-1);
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), new Properties(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)mapper, new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false), new StartupLoggingConfig()){

            ForkingTaskRunner.ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) {
                xmxJavaOptsIndex.set(command.indexOf("-Xmx1g"));
                xmxJavaOptsArrayIndex.set(command.indexOf("-Xmx10g"));
                return (ForkingTaskRunner.ProcessHolder)Mockito.mock(ForkingTaskRunner.ProcessHolder.class);
            }

            int waitForTaskProcessToComplete(Task task, ForkingTaskRunner.ProcessHolder processHolder, File logFile, File reportsFile) {
                return 1;
            }
        };
        forkingTaskRunner.run(task).get();
        Assert.assertTrue((xmxJavaOptsArrayIndex.get() > xmxJavaOptsIndex.get() ? 1 : 0) != 0);
        Assert.assertTrue((xmxJavaOptsIndex.get() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidTaskContextJavaOptsArray() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String taskContent = "{\n  \"type\" : \"noop\",\n  \"id\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"groupId\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"dataSource\" : \"none\",\n  \"runTime\" : 2500,\n  \"isReadyTime\" : 0,\n  \"isReadyResult\" : \"YES\",\n  \"firehose\" : null,\n  \"context\" : {\n    \"druid.indexer.runner.javaOptsArray\" : \"not a string array\",\n    \"druid.indexer.runner.javaOpts\" : \"-Xmx1g -Xms1g\"\n  }\n}";
        Task task = (Task)OBJECT_MAPPER.readValue("{\n  \"type\" : \"noop\",\n  \"id\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"groupId\" : \"noop_2022-03-25T05:17:34.929Z_3a074de1-74b8-4f6e-84b5-67996144f9ac\",\n  \"dataSource\" : \"none\",\n  \"runTime\" : 2500,\n  \"isReadyTime\" : 0,\n  \"isReadyResult\" : \"YES\",\n  \"firehose\" : null,\n  \"context\" : {\n    \"druid.indexer.runner.javaOptsArray\" : \"not a string array\",\n    \"druid.indexer.runner.javaOpts\" : \"-Xmx1g -Xms1g\"\n  }\n}", NoopTask.class);
        ForkingTaskRunner forkingTaskRunner = new ForkingTaskRunner(new ForkingTaskRunnerConfig(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), new Properties(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)mapper, new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false), new StartupLoggingConfig()){

            ForkingTaskRunner.ProcessHolder runTaskProcess(List<String> command, File logFile, TaskLocation taskLocation) {
                return (ForkingTaskRunner.ProcessHolder)Mockito.mock(ForkingTaskRunner.ProcessHolder.class);
            }

            int waitForTaskProcessToComplete(Task task, ForkingTaskRunner.ProcessHolder processHolder, File logFile, File reportsFile) {
                return 1;
            }
        };
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            TaskStatus cfr_ignored_0 = (TaskStatus)forkingTaskRunner.run(task).get();
        });
        Assert.assertTrue((boolean)e.getMessage().endsWith("druid.indexer.runner.javaOptsArray in context of task: " + task.getId() + " must be an array of strings."));
    }
}

