/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.MetadataTaskStorage;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.metadata.DerbyMetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TaskLockBoxConcurrencyTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derby = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper objectMapper = new DefaultObjectMapper();
    private ExecutorService service;
    private TaskStorage taskStorage;
    private TaskLockbox lockbox;

    @Before
    public void setup() {
        TestDerbyConnector derbyConnector = this.derby.getConnector();
        derbyConnector.createTaskTables();
        this.taskStorage = new MetadataTaskStorage((MetadataStorageConnector)derbyConnector, new TaskStorageConfig(null), (MetadataStorageActionHandlerFactory)new DerbyMetadataStorageActionHandlerFactory((SQLMetadataConnector)derbyConnector, (MetadataStorageTablesConfig)this.derby.metadataTablesConfigSupplier().get(), this.objectMapper));
        this.lockbox = new TaskLockbox(this.taskStorage, (IndexerMetadataStorageCoordinator)new IndexerSQLMetadataStorageCoordinator(this.objectMapper, (MetadataStorageTablesConfig)this.derby.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)derbyConnector));
        this.service = Executors.newFixedThreadPool(2);
    }

    @After
    public void teardown() {
        this.service.shutdownNow();
    }

    private LockResult tryTimeChunkLock(TaskLockType lockType, Task task, Interval interval) {
        return this.lockbox.tryLock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null));
    }

    private LockResult acquireTimeChunkLock(TaskLockType lockType, Task task, Interval interval) throws InterruptedException {
        return this.lockbox.lock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null));
    }

    @Test(timeout=60000L)
    public void testDoInCriticalSectionWithDifferentTasks() throws ExecutionException, InterruptedException, EntryExistsException {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        NoopTask lowPriorityTask = NoopTask.create((int)10);
        NoopTask highPriorityTask = NoopTask.create((int)100);
        this.lockbox.add((Task)lowPriorityTask);
        this.lockbox.add((Task)highPriorityTask);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.taskStorage.insert((Task)highPriorityTask, TaskStatus.running((String)highPriorityTask.getId()));
        SettableSupplier intSupplier = new SettableSupplier((Object)0);
        CountDownLatch latch = new CountDownLatch(1);
        Future<Integer> lowPriorityFuture = this.service.submit(() -> this.lambda$testDoInCriticalSectionWithDifferentTasks$2((Task)lowPriorityTask, interval, latch, intSupplier));
        Future<Integer> highPriorityFuture = this.service.submit(() -> this.lambda$testDoInCriticalSectionWithDifferentTasks$5(latch, (Task)highPriorityTask, interval, intSupplier));
        Assert.assertEquals((long)1L, (long)lowPriorityFuture.get().intValue());
        Assert.assertEquals((long)2L, (long)highPriorityFuture.get().intValue());
        LockResult result = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval);
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertTrue((boolean)result.isRevoked());
    }

    @Test(timeout=60000L)
    public void testDoInCriticalSectionWithOverlappedIntervals() throws Exception {
        ImmutableList intervals = ImmutableList.of((Object)Intervals.of((String)"2017-01-01/2017-01-02"), (Object)Intervals.of((String)"2017-01-02/2017-01-03"), (Object)Intervals.of((String)"2017-01-03/2017-01-04"));
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
        for (Interval interval : intervals) {
            LockResult result = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, interval);
            Assert.assertTrue((boolean)result.isOk());
        }
        SettableSupplier intSupplier = new SettableSupplier((Object)0);
        CountDownLatch latch = new CountDownLatch(1);
        Future<Integer> future1 = this.service.submit(() -> this.lambda$testDoInCriticalSectionWithOverlappedIntervals$8((Task)task, (List)intervals, latch, intSupplier));
        Future<Integer> future2 = this.service.submit(() -> this.lambda$testDoInCriticalSectionWithOverlappedIntervals$11(latch, (Task)task, (List)intervals, intSupplier));
        Assert.assertEquals((long)1L, (long)future1.get().intValue());
        Assert.assertEquals((long)2L, (long)future2.get().intValue());
    }

    private /* synthetic */ Integer lambda$testDoInCriticalSectionWithOverlappedIntervals$11(CountDownLatch latch, Task task, List intervals, SettableSupplier intSupplier) throws Exception {
        latch.await();
        return (Integer)this.lockbox.doInCriticalSection(task, intervals.subList(1, 3), CriticalAction.builder().onValidLocks(() -> {
            Thread.sleep(100L);
            intSupplier.set((Object)((Integer)intSupplier.get() + 1));
            return (Integer)intSupplier.get();
        }).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
    }

    private /* synthetic */ Integer lambda$testDoInCriticalSectionWithOverlappedIntervals$8(Task task, List intervals, CountDownLatch latch, SettableSupplier intSupplier) throws Exception {
        return (Integer)this.lockbox.doInCriticalSection(task, intervals.subList(0, 2), CriticalAction.builder().onValidLocks(() -> {
            latch.countDown();
            Thread.sleep(100L);
            intSupplier.set((Object)((Integer)intSupplier.get() + 1));
            return (Integer)intSupplier.get();
        }).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
    }

    private /* synthetic */ Integer lambda$testDoInCriticalSectionWithDifferentTasks$5(CountDownLatch latch, Task highPriorityTask, Interval interval, SettableSupplier intSupplier) throws Exception {
        latch.await();
        LockResult result = this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, highPriorityTask, interval);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertFalse((boolean)result.isRevoked());
        return (Integer)this.lockbox.doInCriticalSection(highPriorityTask, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> {
            Thread.sleep(100L);
            intSupplier.set((Object)((Integer)intSupplier.get() + 1));
            return (Integer)intSupplier.get();
        }).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
    }

    private /* synthetic */ Integer lambda$testDoInCriticalSectionWithDifferentTasks$2(Task lowPriorityTask, Interval interval, CountDownLatch latch, SettableSupplier intSupplier) throws Exception {
        LockResult result = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, lowPriorityTask, interval);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertFalse((boolean)result.isRevoked());
        return (Integer)this.lockbox.doInCriticalSection(lowPriorityTask, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> {
            latch.countDown();
            Thread.sleep(100L);
            intSupplier.set((Object)((Integer)intSupplier.get() + 1));
            return (Integer)intSupplier.get();
        }).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
    }
}

