/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TaskQueueTest
extends IngestionTestBase {
    private static final Granularity SEGMENT_GRANULARITY = Granularities.DAY;

    @Test
    public void testManageInternalReleaseLockWhenTaskIsNotReady() throws Exception {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task1 = new TestTask("t1", Intervals.of((String)"2021-01/P1M"));
        this.prepareTaskForLocking((Task)task1);
        Assert.assertTrue((boolean)task1.isReady(actionClientFactory.create((Task)task1)));
        TestTask task2 = new TestTask("t2", Intervals.of((String)"2021-01-31/P1M"));
        taskQueue.add((Task)task2);
        taskQueue.manageInternal();
        Assert.assertFalse((boolean)task2.isDone());
        Assert.assertTrue((boolean)this.getLockbox().findLocksForTask((Task)task2).isEmpty());
        TestTask task3 = new TestTask("t3", Intervals.of((String)"2021-02-01/P1M"));
        taskQueue.add((Task)task3);
        taskQueue.manageInternal();
        Assert.assertFalse((boolean)task2.isDone());
        Assert.assertTrue((boolean)task3.isDone());
        Assert.assertTrue((boolean)this.getLockbox().findLocksForTask((Task)task2).isEmpty());
        this.shutdownTask((Task)task1);
        taskQueue.shutdown(task3.getId(), "Emulating shutdown of task3", new Object[0]);
        taskQueue.manageInternal();
        Assert.assertTrue((boolean)task2.isDone());
    }

    @Test
    public void testShutdownReleasesTaskLock() throws Exception {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01/P1M"));
        taskQueue.add((Task)task);
        this.getLockbox().lock((Task)task, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task, task.interval, null));
        List locksForTask = this.getLockbox().findLocksForTask((Task)task);
        Assert.assertEquals((long)1L, (long)locksForTask.size());
        Assert.assertEquals((Object)task.interval, (Object)((TaskLock)locksForTask.get(0)).getInterval());
        taskQueue.shutdown(task.getId(), "Shutdown Task test", new Object[0]);
        Assert.assertTrue((boolean)this.getLockbox().findLocksForTask((Task)task).isEmpty());
        Optional statusOptional = this.getTaskStorage().getStatus(task.getId());
        Assert.assertTrue((boolean)statusOptional.isPresent());
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)statusOptional.get()).getStatusCode());
        Assert.assertNotNull((Object)((TaskStatus)statusOptional.get()).getErrorMsg());
        Assert.assertEquals((Object)"Shutdown Task test", (Object)((TaskStatus)statusOptional.get()).getErrorMsg());
    }

    @Test
    public void testSetUseLineageBasedSegmentAllocationByDefault() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D"));
        taskQueue.add((Task)task);
        List tasks = taskQueue.getTasks();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task queuedTask = (Task)tasks.get(0);
        Assert.assertTrue((boolean)((Boolean)queuedTask.getContextValue("useLineageBasedSegmentAllocation")));
    }

    @Test
    public void testDefaultTaskContextOverrideDefaultLineageBasedSegmentAllocation() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(){

            public Map<String, Object> getContext() {
                return ImmutableMap.of((Object)"useLineageBasedSegmentAllocation", (Object)false);
            }
        }, this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D"));
        taskQueue.add((Task)task);
        List tasks = taskQueue.getTasks();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task queuedTask = (Task)tasks.get(0);
        Assert.assertFalse((boolean)((Boolean)queuedTask.getContextValue("useLineageBasedSegmentAllocation")));
    }

    @Test
    public void testUserProvidedTaskContextOverrideDefaultLineageBasedSegmentAllocation() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D"), (Map)ImmutableMap.of((Object)"useLineageBasedSegmentAllocation", (Object)false));
        taskQueue.add((Task)task);
        List tasks = taskQueue.getTasks();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task queuedTask = (Task)tasks.get(0);
        Assert.assertFalse((boolean)((Boolean)queuedTask.getContextValue("useLineageBasedSegmentAllocation")));
    }

    @Test
    public void testLockConfigTakePrecedenceThanDefaultTaskContext() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(){

            public Map<String, Object> getContext() {
                return ImmutableMap.of((Object)"forceTimeChunkLock", (Object)false);
            }
        }, this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D"));
        taskQueue.add((Task)task);
        List tasks = taskQueue.getTasks();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task queuedTask = (Task)tasks.get(0);
        Assert.assertTrue((boolean)((Boolean)queuedTask.getContextValue("forceTimeChunkLock")));
    }

    @Test
    public void testUserProvidedContextOverrideLockConfig() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D"), (Map)ImmutableMap.of((Object)"forceTimeChunkLock", (Object)false));
        taskQueue.add((Task)task);
        List tasks = taskQueue.getTasks();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task queuedTask = (Task)tasks.get(0);
        Assert.assertFalse((boolean)((Boolean)queuedTask.getContextValue("forceTimeChunkLock")));
    }

    @Test
    public void testTaskStatusWhenExceptionIsThrownInIsReady() throws EntryExistsException {
        IngestionTestBase.TestLocalTaskActionClientFactory actionClientFactory = this.createActionClientFactory();
        TaskQueue taskQueue = new TaskQueue(new TaskLockConfig(), new TaskQueueConfig(null, null, null, null), new DefaultTaskConfig(), this.getTaskStorage(), (TaskRunner)new SimpleTaskRunner(actionClientFactory), (TaskActionClientFactory)actionClientFactory, this.getLockbox(), (ServiceEmitter)new NoopServiceEmitter());
        taskQueue.setActive(true);
        TestTask task = new TestTask("t1", Intervals.of((String)"2021-01-01/P1D")){

            @Override
            public boolean isReady(TaskActionClient taskActionClient) {
                throw new RuntimeException("isReady failure test");
            }
        };
        taskQueue.add((Task)task);
        taskQueue.manageInternal();
        Optional statusOptional = this.getTaskStorage().getStatus(task.getId());
        Assert.assertTrue((boolean)statusOptional.isPresent());
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)statusOptional.get()).getStatusCode());
        Assert.assertNotNull((Object)((TaskStatus)statusOptional.get()).getErrorMsg());
        Assert.assertTrue((String)StringUtils.format((String)"Actual message is: %s", (Object[])new Object[]{((TaskStatus)statusOptional.get()).getErrorMsg()}), (boolean)((TaskStatus)statusOptional.get()).getErrorMsg().startsWith("Failed while waiting for the task to be ready to run"));
    }

    private static class SimpleTaskRunner
    implements TaskRunner {
        private final TaskActionClientFactory actionClientFactory;

        private SimpleTaskRunner(TaskActionClientFactory actionClientFactory) {
            this.actionClientFactory = actionClientFactory;
        }

        public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
            return null;
        }

        public void start() {
        }

        public void registerListener(TaskRunnerListener listener, Executor executor) {
        }

        public void unregisterListener(String listenerId) {
        }

        public ListenableFuture<TaskStatus> run(Task task) {
            try {
                TaskToolbox toolbox = (TaskToolbox)Mockito.mock(TaskToolbox.class);
                Mockito.when((Object)toolbox.getTaskActionClient()).thenReturn((Object)this.actionClientFactory.create(task));
                return Futures.immediateFuture((Object)task.run(toolbox));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void shutdown(String taskid, String reason) {
        }

        public void stop() {
        }

        public Collection<? extends TaskRunnerWorkItem> getRunningTasks() {
            return null;
        }

        public Collection<? extends TaskRunnerWorkItem> getPendingTasks() {
            return null;
        }

        public Collection<? extends TaskRunnerWorkItem> getKnownTasks() {
            return Collections.emptyList();
        }

        public Optional<ScalingStats> getScalingStats() {
            return null;
        }

        public Map<String, Long> getTotalTaskSlotCount() {
            return ImmutableMap.of((Object)"_default_worker_category", (Object)0L);
        }

        public Map<String, Long> getIdleTaskSlotCount() {
            return ImmutableMap.of((Object)"_default_worker_category", (Object)0L);
        }

        public Map<String, Long> getUsedTaskSlotCount() {
            return ImmutableMap.of((Object)"_default_worker_category", (Object)0L);
        }

        public Map<String, Long> getLazyTaskSlotCount() {
            return ImmutableMap.of((Object)"_default_worker_category", (Object)0L);
        }

        public Map<String, Long> getBlacklistedTaskSlotCount() {
            return ImmutableMap.of((Object)"_default_worker_category", (Object)0L);
        }
    }

    private static class TestTask
    extends AbstractBatchIndexTask {
        private final Interval interval;
        private boolean done;

        private TestTask(String id, Interval interval) {
            this(id, interval, (Map<String, Object>)null);
        }

        private TestTask(String id, Interval interval, Map<String, Object> context) {
            super(id, "datasource", context);
            this.interval = interval;
        }

        public boolean isReady(TaskActionClient taskActionClient) throws Exception {
            return this.tryTimeChunkLock(taskActionClient, (List)ImmutableList.of((Object)this.interval));
        }

        public TaskStatus runTask(TaskToolbox toolbox) {
            this.done = true;
            return TaskStatus.success((String)this.getId());
        }

        public boolean requireLockExistingSegments() {
            return false;
        }

        public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) {
            return null;
        }

        public boolean isPerfectRollup() {
            return false;
        }

        @Nullable
        public Granularity getSegmentGranularity() {
            return SEGMENT_GRANULARITY;
        }

        public String getType() {
            return "test";
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

