/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.MultipleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.overlord.ThreadingTaskRunner;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.tasklogs.NoopTaskLogs;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ThreadingTaskRunnerTest {
    @Test
    public void testTaskStatusWhenTaskThrowsExceptionWhileRunning() throws ExecutionException, InterruptedException {
        ThreadingTaskRunner runner = new ThreadingTaskRunner(ThreadingTaskRunnerTest.mockTaskToolboxFactory(), new TaskConfig(null, null, null, null, (List)ImmutableList.of(), false, new Period((Object)"PT0S"), new Period((Object)"PT10S"), (List)ImmutableList.of(), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null), new WorkerConfig(), (TaskLogPusher)new NoopTaskLogs(), (ObjectMapper)new DefaultObjectMapper(), (AppenderatorsManager)new TestAppenderatorsManager(), (TaskReportFileWriter)new MultipleFileTaskReportFileWriter(), new DruidNode("middleManager", "host", false, Integer.valueOf(8091), null, true, false));
        ListenableFuture statusFuture = runner.run((Task)new AbstractTask("id", "datasource", null){

            public String getType() {
                return "test";
            }

            public boolean isReady(TaskActionClient taskActionClient) {
                return true;
            }

            public void stopGracefully(TaskConfig taskConfig) {
            }

            public TaskStatus run(TaskToolbox toolbox) {
                throw new RuntimeException("Task failure test");
            }
        });
        TaskStatus status = (TaskStatus)statusFuture.get();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        Assert.assertEquals((Object)"Failed with an exception. See indexer logs for more details.", (Object)status.getErrorMsg());
    }

    private static TaskToolboxFactory mockTaskToolboxFactory() {
        TaskToolboxFactory factory = (TaskToolboxFactory)Mockito.mock(TaskToolboxFactory.class);
        Mockito.when((Object)factory.build((Task)ArgumentMatchers.any())).thenReturn(Mockito.mock(TaskToolbox.class));
        return factory;
    }
}

