/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ZkWorker;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZkWorkerTest {
    Function<ChildData, String> extract;

    @Before
    public void setup() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        this.extract = ZkWorker.createTaskIdExtractor((ObjectMapper)mapper);
    }

    ChildData prepare(String input) {
        String replaced = StringUtils.format((String)StringUtils.replaceChar((String)input, (char)'\'', (String)"\""), (Object[])new Object[]{"id"});
        byte[] data = StringUtils.toUtf8((String)replaced);
        return new ChildData("/a/b/c", new Stat(), data);
    }

    @Test
    public void testShallowObjectWithIdFirst() {
        ChildData input = this.prepare("{'%s': 'abcd', 'status': 'RUNNING'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testShallowObjectWithIdMiddle() {
        ChildData input = this.prepare("{'before': 'something', '%s': 'abcd', 'status': 'RUNNING'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testShallowObjectWithIdLast() {
        ChildData input = this.prepare("{'before': 'something', 'status': 'RUNNING', '%s': 'abcd'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testShallowObjectWithNoId() {
        ChildData input = this.prepare("{'before': 'something', 'status': 'RUNNING'}");
        String actual = this.extract.apply(input);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testDeepObjectWithIdFirst() {
        ChildData input = this.prepare("{'%s': 'abcd', 'subobject': { 'subkey': 'subvalue' }, 'subarray': [{'key': 'val'}, 2, 3], 'status': 'RUNNING'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testDeepObjectWithIdLast() {
        ChildData input = this.prepare("{'subobject': { 'subkey': 'subvalue' }, 'subarray': [{'key': 'val'}, 2, 3], 'status': 'RUNNING', '%s': 'abcd'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testDeepObjectWithIdInNestedOnly() {
        ChildData input = this.prepare("{'subobject': { '%s': 'defg' }, 'subarray': [{'key': 'val'}, 2, 3], 'status': 'RUNNING'}");
        String actual = this.extract.apply(input);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testDeepObjectWithIdInNestedAndOuter() {
        ChildData input = this.prepare("{'subobject': { '%s': 'defg' }, 'subarray': [{'key': 'val'}, 2, 3], 'status': 'RUNNING', '%1$s': 'abcd'}");
        String actual = this.extract.apply(input);
        Assert.assertEquals((Object)"abcd", (Object)actual);
    }

    @Test
    public void testIdWithWrongTypeReturnsNull() {
        ChildData input = this.prepare("{'%s': {'nested': 'obj'}'");
        String actual = this.extract.apply(input);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testCanReadIdFromAJacksonSerializedTaskAnnouncement() throws JsonProcessingException {
        String expectedTaskId = "task01234";
        NoopTask task0 = NoopTask.create((String)"task01234", (int)0);
        TaskAnnouncement taskAnnouncement = TaskAnnouncement.create((Task)task0, (TaskStatus)TaskStatus.running((String)task0.getId()), (TaskLocation)TaskLocation.unknown());
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] serialized = objectMapper.writeValueAsBytes((Object)taskAnnouncement);
        ChildData zkNode = new ChildData("/a/b/c", new Stat(), serialized);
        String actualExtractedTaskId = this.extract.apply(zkNode);
        Assert.assertEquals((Object)"task01234", (Object)actualExtractedTaskId);
    }
}

