/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.IndexingServiceModuleHelper;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RemoteTaskRunnerConfigTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final Period DEFAULT_TIMEOUT = Period.ZERO;
    private static final String DEFAULT_VERSION = "";
    private static final long DEFAULT_MAX_ZNODE = 10240L;
    private static final int DEFAULT_PENDING_TASKS_RUNNER_NUM_THREADS = 5;
    private static final int DEFAULT_MAX_RETRIES_BEFORE_BLACKLIST = 5;
    private static final Period DEFAULT_TASK_BACKOFF = new Period((Object)"PT10M");
    private static final Period DEFAULT_BLACKLIST_CLEANUP_PERIOD = new Period((Object)"PT5M");

    @Test
    public void testIsJsonConfiguratable() {
        JsonConfigurator.verifyClazzIsConfigurable((ObjectMapper)MAPPER, RemoteTaskRunnerConfig.class, null);
    }

    @Test
    public void testGetTaskAssignmentTimeout() throws Exception {
        Period timeout = Period.hours((int)1);
        Assert.assertEquals((Object)timeout, (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getTaskAssignmentTimeout());
    }

    @Test
    public void testGetPendingTasksRunnerNumThreads() throws Exception {
        int pendingTasksRunnerNumThreads = 20;
        Assert.assertEquals((long)20L, (long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 20, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getPendingTasksRunnerNumThreads());
    }

    @Test
    public void testGetMinWorkerVersion() throws Exception {
        String version = "some version";
        Assert.assertEquals((Object)"some version", (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, "some version", 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getMinWorkerVersion());
    }

    @Test
    public void testGetMaxZnodeBytes() throws Exception {
        long max = 20480L;
        Assert.assertEquals((long)20480L, (long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 20480L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getMaxZnodeBytes());
    }

    @Test
    public void testGetTaskShutdownLinkTimeout() throws Exception {
        Period timeout = Period.hours((int)1);
        Assert.assertEquals((Object)timeout, (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, timeout, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getTaskShutdownLinkTimeout());
    }

    @Test
    public void testGetTaskCleanupTimeout() throws Exception {
        Period timeout = Period.hours((int)1);
        Assert.assertEquals((Object)timeout, (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, timeout, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getTaskCleanupTimeout());
    }

    @Test
    public void testGetMaxRetriesBeforeBlacklist() throws Exception {
        int maxRetriesBeforeBlacklist = 2;
        Assert.assertEquals((long)2L, (long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 2, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getMaxRetriesBeforeBlacklist());
    }

    @Test
    public void testGetWorkerBlackListBackoffTime() throws Exception {
        Period taskBlackListBackoffTime = new Period((Object)"PT1M");
        Assert.assertEquals((Object)taskBlackListBackoffTime, (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, taskBlackListBackoffTime, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).getWorkerBlackListBackoffTime());
    }

    @Test
    public void testGetTaskBlackListCleanupPeriod() throws Exception {
        Period taskBlackListCleanupPeriod = Period.years((int)100);
        Assert.assertEquals((Object)taskBlackListCleanupPeriod, (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, taskBlackListCleanupPeriod)).getWorkerBlackListCleanupPeriod());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)));
        Period timeout = Period.years((int)999);
        String version = "someVersion";
        long max = 20480L;
        int pendingTasksRunnerNumThreads = 20;
        boolean maxRetriesBeforeBlacklist = true;
        Period taskBlackListBackoffTime = new Period((Object)"PT1M");
        Period taskBlackListCleanupPeriod = Period.years((int)10);
        Assert.assertEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, DEFAULT_TIMEOUT, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, DEFAULT_VERSION, 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 10240L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, DEFAULT_TIMEOUT, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 5, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 5, taskBlackListBackoffTime, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, DEFAULT_TASK_BACKOFF, taskBlackListCleanupPeriod)));
        Assert.assertNotEquals((Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, taskBlackListCleanupPeriod)), (Object)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 1, taskBlackListBackoffTime, DEFAULT_BLACKLIST_CLEANUP_PERIOD)));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, DEFAULT_TIMEOUT, DEFAULT_VERSION, 10240L, DEFAULT_TIMEOUT, 5, 5, DEFAULT_TASK_BACKOFF, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).hashCode());
        Period timeout = Period.years((int)999);
        String version = "someVersion";
        long max = 20480L;
        int pendingTasksRunnerNumThreads = 20;
        int maxRetriesBeforeBlacklist = 80;
        Period taskBlackListBackoffTime = new Period((Object)"PT1M");
        Period taskBlackListCleanupPeriod = Period.years((int)10);
        Assert.assertEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(DEFAULT_TIMEOUT, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, DEFAULT_TIMEOUT, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, DEFAULT_VERSION, 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 10240L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, DEFAULT_TIMEOUT, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 5, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 5, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, DEFAULT_TASK_BACKOFF, taskBlackListCleanupPeriod)).hashCode());
        Assert.assertNotEquals((long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, taskBlackListCleanupPeriod)).hashCode(), (long)this.reflect(this.generateRemoteTaskRunnerConfig(timeout, timeout, "someVersion", 20480L, timeout, 20, 80, taskBlackListBackoffTime, DEFAULT_BLACKLIST_CLEANUP_PERIOD)).hashCode());
    }

    @Test
    public void testMaxZnodeBytesLowerThanExpected() {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder)));
        this.expectedException.expect(ProvisionException.class);
        this.expectedException.expectMessage("maxZnodeBytes must be in the range of [10KiB, 2GiB)");
        Properties props = new Properties();
        props.put("druid.indexer.runner.maxZnodeBytes", "9KiB");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)"druid.indexer.runner", RemoteTaskRunnerConfig.class);
        configProvider.inject(props, (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get());
        configProvider.get().get();
    }

    @Test
    public void testMaxZnodeBytesGreaterThanExpected() {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder)));
        this.expectedException.expect(ProvisionException.class);
        this.expectedException.expectMessage("maxZnodeBytes must be in the range of [10KiB, 2GiB)");
        Properties props = new Properties();
        props.put("druid.indexer.runner.maxZnodeBytes", "2GiB");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)"druid.indexer.runner", RemoteTaskRunnerConfig.class);
        configProvider.inject(props, (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get());
        configProvider.get().get();
    }

    private RemoteTaskRunnerConfig reflect(RemoteTaskRunnerConfig config) throws IOException {
        return (RemoteTaskRunnerConfig)MAPPER.readValue(MAPPER.writeValueAsString((Object)config), RemoteTaskRunnerConfig.class);
    }

    private RemoteTaskRunnerConfig generateRemoteTaskRunnerConfig(Period taskAssignmentTimeout, Period taskCleanupTimeout, String minWorkerVersion, long maxZnodeBytes, Period taskShutdownLinkTimeout, int pendingTasksRunnerNumThreads, int maxRetriesBeforeBlacklist, Period taskBlackListBackoffTime, Period taskBlackListCleanupPeriod) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("taskAssignmentTimeout", taskAssignmentTimeout);
        objectMap.put("taskCleanupTimeout", taskCleanupTimeout);
        objectMap.put("minWorkerVersion", minWorkerVersion);
        objectMap.put("maxZnodeBytes", maxZnodeBytes);
        objectMap.put("taskShutdownLinkTimeout", taskShutdownLinkTimeout);
        objectMap.put("pendingTasksRunnerNumThreads", pendingTasksRunnerNumThreads);
        objectMap.put("maxRetriesBeforeBlacklist", maxRetriesBeforeBlacklist);
        objectMap.put("workerBlackListBackoffTime", taskBlackListBackoffTime);
        objectMap.put("workerBlackListCleanupPeriod", taskBlackListCleanupPeriod);
        return (RemoteTaskRunnerConfig)MAPPER.convertValue(objectMap, RemoteTaskRunnerConfig.class);
    }
}

