/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.hrtr;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.common.guava.DSuppliers;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.discovery.WorkerNodeService;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningService;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.config.HttpRemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunner;
import org.apache.druid.indexing.overlord.hrtr.WorkerHolder;
import org.apache.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.easymock.EasyMock;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpRemoteTaskRunnerTest {
    @Before
    public void setup() {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
    }

    @Test(timeout=60000L)
    public void testFreshStart() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        HttpRemoteTaskRunner taskRunner = HttpRemoteTaskRunnerTest.newHttpTaskRunnerInstance(druidNodeDiscoveryProvider, (ProvisioningStrategy)new NoopProvisioningStrategy());
        taskRunner.start();
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        DiscoveryDruidNode druidNode2 = new DiscoveryDruidNode(new DruidNode("service", "host2", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip2", 2, "0", "_default_worker_category")));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1, (Object)druidNode2));
        int numTasks = 8;
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < numTasks; ++i) {
            futures.add(taskRunner.run((Task)NoopTask.create((String)("task-id-" + i), (int)0)));
        }
        for (Future future : futures) {
            Assert.assertTrue((boolean)((TaskStatus)future.get()).isSuccess());
        }
        Assert.assertEquals((long)numTasks, (long)taskRunner.getKnownTasks().size());
        Assert.assertEquals((long)numTasks, (long)taskRunner.getCompletedTasks().size());
    }

    @Test(timeout=60000L)
    public void testFreshStartAndStop() {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery).times(2);
        ProvisioningStrategy provisioningStrategy = (ProvisioningStrategy)EasyMock.createMock(ProvisioningStrategy.class);
        ProvisioningService provisioningService = (ProvisioningService)EasyMock.createNiceMock(ProvisioningService.class);
        EasyMock.expect((Object)provisioningStrategy.makeProvisioningService((TaskRunner)EasyMock.isA(HttpRemoteTaskRunner.class))).andReturn((Object)provisioningService);
        provisioningService.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider, provisioningStrategy, provisioningService});
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        DiscoveryDruidNode druidNode2 = new DiscoveryDruidNode(new DruidNode("service", "host2", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip2", 2, "0", "_default_worker_category")));
        HttpRemoteTaskRunner taskRunner = HttpRemoteTaskRunnerTest.newHttpTaskRunnerInstance(druidNodeDiscoveryProvider, provisioningStrategy);
        taskRunner.start();
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1, (Object)druidNode2));
        ConcurrentMap workers = taskRunner.getWorkersForTestingReadOnly();
        Assert.assertEquals((long)2L, (long)workers.size());
        Assert.assertTrue((boolean)workers.values().stream().noneMatch(w -> w.getUnderlyingSyncer().isExecutorShutdown()));
        ((WorkerHolder)workers.values().iterator().next()).stop();
        taskRunner.stop();
        Assert.assertTrue((boolean)druidNodeDiscovery.getListeners().isEmpty());
        Assert.assertEquals((long)2L, (long)workers.size());
        Assert.assertTrue((boolean)workers.values().stream().allMatch(w -> w.getUnderlyingSyncer().isExecutorShutdown()));
        EasyMock.verify((Object[])new Object[]{druidNodeDiscoveryProvider, provisioningStrategy, provisioningService});
    }

    @Test(timeout=60000L)
    public void testFreshStartAndStopNoProvisioner() {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        ProvisioningStrategy provisioningStrategy = (ProvisioningStrategy)EasyMock.createMock(ProvisioningStrategy.class);
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery).times(2);
        EasyMock.expect((Object)provisioningStrategy.makeProvisioningService((TaskRunner)EasyMock.isA(HttpRemoteTaskRunner.class))).andReturn(null);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider, provisioningStrategy});
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), provisioningStrategy, druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                return HttpRemoteTaskRunnerTest.createWorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), new AtomicInteger(), (Set)ImmutableSet.of());
            }
        };
        taskRunner.start();
        taskRunner.stop();
        EasyMock.verify((Object[])new Object[]{druidNodeDiscoveryProvider, provisioningStrategy});
    }

    @Test(timeout=60000L)
    public void testOneStuckTaskAssignmentDoesntBlockOthers() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        NoopTask task1 = NoopTask.create((String)"task-id-1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task-id-2", (int)0);
        NoopTask task3 = NoopTask.create((String)"task-id-3", (int)0);
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null), (Task)task1){
            final /* synthetic */ Task val$task1;
            {
                this.val$task1 = task;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
            }

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                return HttpRemoteTaskRunnerTest.createWorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)this.val$task1, (Object)ImmutableList.of()), new AtomicInteger(), (Set)ImmutableSet.of());
            }
        };
        taskRunner.start();
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        DiscoveryDruidNode druidNode2 = new DiscoveryDruidNode(new DruidNode("service", "host2", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip2", 2, "0", "_default_worker_category")));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1, (Object)druidNode2));
        taskRunner.run((Task)task1);
        ListenableFuture future2 = taskRunner.run((Task)task2);
        ListenableFuture future3 = taskRunner.run((Task)task3);
        Assert.assertTrue((boolean)((TaskStatus)future2.get()).isSuccess());
        Assert.assertTrue((boolean)((TaskStatus)future3.get()).isSuccess());
        Assert.assertEquals((Object)task1.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getPendingTasks())).getTaskId());
    }

    @Test(timeout=60000L)
    public void testTaskRunnerRestart() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        final ConcurrentHashMap<String, CustomFunction> workerHolders = new ConcurrentHashMap<String, CustomFunction>();
        NoopTask task1 = NoopTask.create((String)"task-id-1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task-id-2", (int)0);
        NoopTask task3 = NoopTask.create((String)"task-id-3", (int)0);
        NoopTask task4 = NoopTask.create((String)"task-id-4", (int)0);
        NoopTask task5 = NoopTask.create((String)"task-id-5", (int)0);
        TaskStorage taskStorageMock = (TaskStorage)EasyMock.createStrictMock(TaskStorage.class);
        EasyMock.expect((Object)taskStorageMock.getStatus(task1.getId())).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)taskStorageMock.getStatus(task2.getId())).andReturn((Object)Optional.absent()).times(2);
        EasyMock.expect((Object)taskStorageMock.getStatus(task3.getId())).andReturn((Object)Optional.of((Object)TaskStatus.running((String)task3.getId())));
        EasyMock.expect((Object)taskStorageMock.getStatus(task4.getId())).andReturn((Object)Optional.of((Object)TaskStatus.running((String)task4.getId())));
        EasyMock.expect((Object)taskStorageMock.getStatus(task5.getId())).andReturn((Object)Optional.of((Object)TaskStatus.success((String)task5.getId())));
        EasyMock.replay((Object[])new Object[]{taskStorageMock});
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, taskStorageMock, (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                if (workerHolders.containsKey(worker.getHost())) {
                    return ((CustomFunction)workerHolders.get(worker.getHost())).apply(smileMapper, httpClient, config, workersSyncExec, listener, worker, knownAnnouncements);
                }
                throw new ISE("No WorkerHolder for [%s].", new Object[]{worker.getHost()});
            }
        };
        taskRunner.start();
        DiscoveryDruidNode druidNode = new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(1234), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        AtomicInteger ticks = new AtomicInteger();
        HashSet taskShutdowns = new HashSet();
        workerHolders.put("host:1234", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testTaskRunnerRestart$2((Task)task1, (Task)task2, (Task)task3, (Task)task4, (Task)task5, ticks, taskShutdowns, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        while (ticks.get() < 1) {
            Thread.sleep(100L);
        }
        EasyMock.verify((Object[])new Object[]{taskStorageMock});
        Assert.assertEquals((Object)ImmutableSet.of((Object)task2.getId(), (Object)task5.getId()), taskShutdowns);
        Assert.assertTrue((boolean)taskRunner.getPendingTasks().isEmpty());
        TaskRunnerWorkItem item = (TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks());
        Assert.assertEquals((Object)task4.getId(), (Object)item.getTaskId());
        Assert.assertTrue((boolean)((TaskStatus)taskRunner.run((Task)task3).get()).isSuccess());
        Assert.assertEquals((long)2L, (long)taskRunner.getKnownTasks().size());
    }

    @Test(timeout=60000L)
    public void testWorkerDisapperAndReappearBeforeItsCleanup() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        final ConcurrentHashMap<String, CustomFunction> workerHolders = new ConcurrentHashMap<String, CustomFunction>();
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                if (workerHolders.containsKey(worker.getHost())) {
                    return ((CustomFunction)workerHolders.get(worker.getHost())).apply(smileMapper, httpClient, config, workersSyncExec, listener, worker, knownAnnouncements);
                }
                throw new ISE("No WorkerHolder for [%s].", new Object[]{worker.getHost()});
            }
        };
        taskRunner.start();
        NoopTask task1 = NoopTask.create((String)"task-id-1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task-id-2", (int)0);
        DiscoveryDruidNode druidNode = new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(1234), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        workerHolders.put("host:1234", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testWorkerDisapperAndReappearBeforeItsCleanup$3((Task)task1, (Task)task2, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        ListenableFuture future1 = taskRunner.run((Task)task1);
        ListenableFuture future2 = taskRunner.run((Task)task2);
        while (taskRunner.getPendingTasks().size() > 0) {
            Thread.sleep(100L);
        }
        druidNodeDiscovery.getListeners().get(0).nodesRemoved((Collection)ImmutableList.of((Object)druidNode));
        workerHolders.put("host:1234", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testWorkerDisapperAndReappearBeforeItsCleanup$4((Task)task2, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        Assert.assertTrue((boolean)((TaskStatus)future1.get()).isSuccess());
        Assert.assertTrue((boolean)((TaskStatus)future2.get()).isSuccess());
    }

    @Test(timeout=60000L)
    public void testWorkerDisapperAndReappearAfterItsCleanup() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        final ConcurrentHashMap<String, CustomFunction> workerHolders = new ConcurrentHashMap<String, CustomFunction>();
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public Period getTaskCleanupTimeout() {
                return Period.millis((int)1);
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                if (workerHolders.containsKey(worker.getHost())) {
                    return ((CustomFunction)workerHolders.get(worker.getHost())).apply(smileMapper, httpClient, config, workersSyncExec, listener, worker, knownAnnouncements);
                }
                throw new ISE("No WorkerHolder for [%s].", new Object[]{worker.getHost()});
            }
        };
        taskRunner.start();
        NoopTask task1 = NoopTask.create((String)"task-id-1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task-id-2", (int)0);
        DiscoveryDruidNode druidNode = new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(1234), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        workerHolders.put("host:1234", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testWorkerDisapperAndReappearAfterItsCleanup$5((Task)task1, (Task)task2, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        ListenableFuture future1 = taskRunner.run((Task)task1);
        ListenableFuture future2 = taskRunner.run((Task)task2);
        while (taskRunner.getPendingTasks().size() > 0) {
            Thread.sleep(100L);
        }
        druidNodeDiscovery.getListeners().get(0).nodesRemoved((Collection)ImmutableList.of((Object)druidNode));
        Assert.assertTrue((boolean)((TaskStatus)future1.get()).isFailure());
        Assert.assertTrue((boolean)((TaskStatus)future2.get()).isFailure());
        Assert.assertNotNull((Object)((TaskStatus)future1.get()).getErrorMsg());
        Assert.assertNotNull((Object)((TaskStatus)future2.get()).getErrorMsg());
        Assert.assertTrue((boolean)((TaskStatus)future1.get()).getErrorMsg().startsWith("The worker that this task was assigned disappeared and did not report cleanup within timeout"));
        Assert.assertTrue((boolean)((TaskStatus)future2.get()).getErrorMsg().startsWith("The worker that this task was assigned disappeared and did not report cleanup within timeout"));
        AtomicInteger ticks = new AtomicInteger();
        ConcurrentHashSet actualShutdowns = new ConcurrentHashSet();
        workerHolders.put("host:1234", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testWorkerDisapperAndReappearAfterItsCleanup$6((Task)task1, (Task)task2, ticks, (Set)actualShutdowns, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        while (ticks.get() < 1) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)task2.getId()), (Object)actualShutdowns);
        Assert.assertTrue((boolean)((TaskStatus)taskRunner.run((Task)task1).get()).isFailure());
        Assert.assertTrue((boolean)((TaskStatus)taskRunner.run((Task)task2).get()).isFailure());
    }

    @Test(timeout=60000L)
    public void testMarkWorkersLazy() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        NoopTask task1 = NoopTask.create((String)"task-id-1", (int)0);
        NoopTask task2 = NoopTask.create((String)"task-id-2", (int)0);
        String additionalWorkerCategory = "category2";
        final ConcurrentHashMap<String, CustomFunction> workerHolders = new ConcurrentHashMap<String, CustomFunction>();
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                if (workerHolders.containsKey(worker.getHost())) {
                    return ((CustomFunction)workerHolders.get(worker.getHost())).apply(smileMapper, httpClient, config, workersSyncExec, listener, worker, knownAnnouncements);
                }
                throw new ISE("No WorkerHolder for [%s].", new Object[]{worker.getHost()});
            }
        };
        taskRunner.start();
        Assert.assertTrue((boolean)taskRunner.getTotalTaskSlotCount().isEmpty());
        Assert.assertTrue((boolean)taskRunner.getIdleTaskSlotCount().isEmpty());
        Assert.assertTrue((boolean)taskRunner.getUsedTaskSlotCount().isEmpty());
        AtomicInteger ticks = new AtomicInteger();
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 1, "0", "_default_worker_category")));
        workerHolders.put("host1:8080", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testMarkWorkersLazy$7((Task)task1, ticks, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        taskRunner.run((Task)task1);
        while (ticks.get() < 1) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        DiscoveryDruidNode druidNode2 = new DiscoveryDruidNode(new DruidNode("service", "host2", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip2", 1, "0", additionalWorkerCategory)));
        workerHolders.put("host2:8080", (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> HttpRemoteTaskRunnerTest.lambda$testMarkWorkersLazy$8((Task)task2, ticks, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode2));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getIdleTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getUsedTaskSlotCount().get(additionalWorkerCategory)));
        taskRunner.run((Task)task2);
        while (ticks.get() < 2) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertFalse((boolean)taskRunner.getIdleTaskSlotCount().containsKey(additionalWorkerCategory));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getUsedTaskSlotCount().get(additionalWorkerCategory)));
        DiscoveryDruidNode druidNode3 = new DiscoveryDruidNode(new DruidNode("service", "host3", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip2", 1, "0", "_default_worker_category")));
        workerHolders.put("host3:8080", (mapper, httpClient, config, exec, listener, worker, knownAnnouncements) -> HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of(), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of(), new AtomicInteger(), (Set<String>)ImmutableSet.of()));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode3));
        Assert.assertEquals((long)2L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertFalse((boolean)taskRunner.getIdleTaskSlotCount().containsKey(additionalWorkerCategory));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getUsedTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertFalse((boolean)taskRunner.getLazyTaskSlotCount().containsKey("_default_worker_category"));
        Assert.assertFalse((boolean)taskRunner.getLazyTaskSlotCount().containsKey(additionalWorkerCategory));
        Assert.assertEquals((Object)task1.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        Assert.assertEquals((Object)task2.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getPendingTasks())).getTaskId());
        Assert.assertEquals((Object)"host3:8080", (Object)((Worker)Iterables.getOnlyElement((Iterable)taskRunner.markWorkersLazy(Predicates.alwaysTrue(), Integer.MAX_VALUE))).getHost());
        Assert.assertEquals((long)2L, (long)((Long)taskRunner.getTotalTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getTotalTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getIdleTaskSlotCount().get("_default_worker_category")));
        Assert.assertFalse((boolean)taskRunner.getIdleTaskSlotCount().containsKey(additionalWorkerCategory));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getUsedTaskSlotCount().get("_default_worker_category")));
        Assert.assertEquals((long)0L, (long)((Long)taskRunner.getUsedTaskSlotCount().get(additionalWorkerCategory)));
        Assert.assertEquals((long)1L, (long)((Long)taskRunner.getLazyTaskSlotCount().get("_default_worker_category")));
        Assert.assertFalse((boolean)taskRunner.getLazyTaskSlotCount().containsKey(additionalWorkerCategory));
    }

    @Test
    public void testTaskAddedOrUpdated1() throws Exception {
        NoopTask task = NoopTask.create((String)"task");
        ArrayList<Object> listenerNotificationsAccumulator = new ArrayList<Object>();
        HttpRemoteTaskRunner taskRunner = this.createTaskRunnerForTestTaskAddedOrUpdated((TaskStorage)EasyMock.createStrictMock(TaskStorage.class), listenerNotificationsAccumulator);
        WorkerHolder workerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)workerHolder.getWorker()).andReturn((Object)new Worker("http", "worker", "127.0.0.1", 1, "v1", "_default_worker_category")).anyTimes();
        workerHolder.setLastCompletedTaskTime((DateTime)EasyMock.anyObject());
        workerHolder.resetContinuouslyFailedTasksCount();
        EasyMock.expect((Object)workerHolder.getContinuouslyFailedTasksCount()).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{workerHolder});
        ListenableFuture future = taskRunner.run((Task)task);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getPendingTasks())).getTaskId());
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1000, (int)1001)), workerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1, (int)2)), workerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1, (int)2)), workerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        WorkerHolder rogueWorkerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)rogueWorkerHolder.getWorker()).andReturn((Object)new Worker("http", "rogue-worker", "127.0.0.1", 5, "v1", "_default_worker_category")).anyTimes();
        rogueWorkerHolder.shutdownTask(task.getId());
        EasyMock.replay((Object[])new Object[]{rogueWorkerHolder});
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)"rogue-worker", (int)1, (int)2)), rogueWorkerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        EasyMock.verify((Object[])new Object[]{rogueWorkerHolder});
        rogueWorkerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)rogueWorkerHolder.getWorker()).andReturn((Object)new Worker("http", "rogue-worker", "127.0.0.1", 5, "v1", "_default_worker_category")).anyTimes();
        EasyMock.replay((Object[])new Object[]{rogueWorkerHolder});
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.failure((String)task.getId(), (String)"Dummy task status failure err message"), (TaskLocation)TaskLocation.create((String)"rogue-worker", (int)1, (int)2)), rogueWorkerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getRunningTasks())).getTaskId());
        EasyMock.verify((Object[])new Object[]{rogueWorkerHolder});
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.success((String)task.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1, (int)2)), workerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getCompletedTasks())).getTaskId());
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)future.get()).getStatusCode());
        rogueWorkerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)rogueWorkerHolder.getWorker()).andReturn((Object)new Worker("http", "rogue-worker", "127.0.0.1", 5, "v1", "_default_worker_category")).anyTimes();
        rogueWorkerHolder.shutdownTask(task.getId());
        EasyMock.replay((Object[])new Object[]{rogueWorkerHolder});
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)"rogue-worker", (int)1, (int)2)), rogueWorkerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getCompletedTasks())).getTaskId());
        EasyMock.verify((Object[])new Object[]{rogueWorkerHolder});
        rogueWorkerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)rogueWorkerHolder.getWorker()).andReturn((Object)new Worker("http", "rogue-worker", "127.0.0.1", 5, "v1", "_default_worker_category")).anyTimes();
        EasyMock.replay((Object[])new Object[]{rogueWorkerHolder});
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.failure((String)task.getId(), (String)"Dummy task status failure for testing"), (TaskLocation)TaskLocation.create((String)"rogue-worker", (int)1, (int)2)), rogueWorkerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getCompletedTasks())).getTaskId());
        EasyMock.verify((Object[])new Object[]{rogueWorkerHolder});
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)future.get()).getStatusCode());
        EasyMock.verify((Object[])new Object[]{workerHolder});
        Assert.assertEquals(listenerNotificationsAccumulator, (Object)ImmutableList.of((Object)ImmutableList.of((Object)task.getId(), (Object)TaskLocation.create((String)"worker", (int)1000, (int)1001)), (Object)ImmutableList.of((Object)task.getId(), (Object)TaskLocation.create((String)"worker", (int)1, (int)2)), (Object)ImmutableList.of((Object)task.getId(), (Object)TaskStatus.success((String)task.getId()))));
    }

    @Test
    public void testTaskAddedOrUpdated2() throws Exception {
        NoopTask task = NoopTask.create((String)"task");
        ArrayList<Object> listenerNotificationsAccumulator = new ArrayList<Object>();
        HttpRemoteTaskRunner taskRunner = this.createTaskRunnerForTestTaskAddedOrUpdated((TaskStorage)EasyMock.createStrictMock(TaskStorage.class), listenerNotificationsAccumulator);
        Worker worker = new Worker("http", "localhost", "127.0.0.1", 1, "v1", "_default_worker_category");
        WorkerHolder workerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)workerHolder.getWorker()).andReturn((Object)worker).anyTimes();
        workerHolder.setLastCompletedTaskTime((DateTime)EasyMock.anyObject());
        workerHolder.resetContinuouslyFailedTasksCount();
        EasyMock.expect((Object)workerHolder.getContinuouslyFailedTasksCount()).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{workerHolder});
        ListenableFuture future = taskRunner.run((Task)task);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getPendingTasks())).getTaskId());
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.success((String)task.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1, (int)2)), workerHolder);
        Assert.assertEquals((Object)task.getId(), (Object)((TaskRunnerWorkItem)Iterables.getOnlyElement((Iterable)taskRunner.getCompletedTasks())).getTaskId());
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)future.get()).getStatusCode());
        EasyMock.verify((Object[])new Object[]{workerHolder});
        Assert.assertEquals(listenerNotificationsAccumulator, (Object)ImmutableList.of((Object)ImmutableList.of((Object)task.getId(), (Object)TaskLocation.create((String)"worker", (int)1, (int)2)), (Object)ImmutableList.of((Object)task.getId(), (Object)TaskStatus.success((String)task.getId()))));
    }

    @Test
    public void testTaskAddedOrUpdated3() {
        NoopTask task1 = NoopTask.create((String)"task1");
        NoopTask task2 = NoopTask.create((String)"task2");
        NoopTask task3 = NoopTask.create((String)"task3");
        NoopTask task4 = NoopTask.create((String)"task4");
        NoopTask task5 = NoopTask.create((String)"task5");
        NoopTask task6 = NoopTask.create((String)"task6");
        TaskStorage taskStorage = (TaskStorage)EasyMock.createMock(TaskStorage.class);
        EasyMock.expect((Object)taskStorage.getStatus(task1.getId())).andReturn((Object)Optional.of((Object)TaskStatus.running((String)task1.getId())));
        EasyMock.expect((Object)taskStorage.getStatus(task2.getId())).andReturn((Object)Optional.of((Object)TaskStatus.running((String)task2.getId())));
        EasyMock.expect((Object)taskStorage.getStatus(task3.getId())).andReturn((Object)Optional.of((Object)TaskStatus.success((String)task3.getId())));
        EasyMock.expect((Object)taskStorage.getStatus(task4.getId())).andReturn((Object)Optional.of((Object)TaskStatus.success((String)task4.getId())));
        EasyMock.expect((Object)taskStorage.getStatus(task5.getId())).andReturn((Object)Optional.absent());
        EasyMock.expect((Object)taskStorage.getStatus(task6.getId())).andReturn((Object)Optional.absent());
        EasyMock.replay((Object[])new Object[]{taskStorage});
        ArrayList<Object> listenerNotificationsAccumulator = new ArrayList<Object>();
        HttpRemoteTaskRunner taskRunner = this.createTaskRunnerForTestTaskAddedOrUpdated(taskStorage, listenerNotificationsAccumulator);
        Worker worker = new Worker("http", "localhost", "127.0.0.1", 1, "v1", "_default_worker_category");
        WorkerHolder workerHolder = (WorkerHolder)EasyMock.createMock(WorkerHolder.class);
        EasyMock.expect((Object)workerHolder.getWorker()).andReturn((Object)worker).anyTimes();
        workerHolder.setLastCompletedTaskTime((DateTime)EasyMock.anyObject());
        workerHolder.resetContinuouslyFailedTasksCount();
        EasyMock.expect((Object)workerHolder.getContinuouslyFailedTasksCount()).andReturn((Object)0);
        workerHolder.shutdownTask(task3.getId());
        workerHolder.shutdownTask(task5.getId());
        EasyMock.replay((Object[])new Object[]{workerHolder});
        Assert.assertEquals((long)0L, (long)taskRunner.getKnownTasks().size());
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)1, (int)2)), workerHolder);
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.success((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)3, (int)4)), workerHolder);
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task3, (TaskStatus)TaskStatus.running((String)task3.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)5, (int)6)), workerHolder);
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task4, (TaskStatus)TaskStatus.success((String)task4.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)7, (int)8)), workerHolder);
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task5, (TaskStatus)TaskStatus.running((String)task5.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)9, (int)10)), workerHolder);
        taskRunner.taskAddedOrUpdated(TaskAnnouncement.create((Task)task6, (TaskStatus)TaskStatus.success((String)task6.getId()), (TaskLocation)TaskLocation.create((String)"worker", (int)11, (int)12)), workerHolder);
        EasyMock.verify((Object[])new Object[]{workerHolder, taskStorage});
        Assert.assertEquals(listenerNotificationsAccumulator, (Object)ImmutableList.of((Object)ImmutableList.of((Object)task1.getId(), (Object)TaskLocation.create((String)"worker", (int)1, (int)2)), (Object)ImmutableList.of((Object)task2.getId(), (Object)TaskLocation.create((String)"worker", (int)3, (int)4)), (Object)ImmutableList.of((Object)task2.getId(), (Object)TaskStatus.success((String)task2.getId()))));
    }

    @Test
    public void testTimeoutInAssigningTasks() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 1;
            }

            public Period getTaskAssignmentTimeout() {
                return new Period((Object)"PT1S");
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                return new WorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, (List)ImmutableList.of()){

                    public void start() {
                        this.disabled.set(false);
                    }

                    public void stop() {
                    }

                    public boolean isInitialized() {
                        return true;
                    }

                    public void waitForInitialization() {
                    }

                    public boolean assignTask(Task task) {
                        return true;
                    }

                    public void shutdownTask(String taskId) {
                    }
                };
            }
        };
        taskRunner.start();
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1));
        ListenableFuture future = taskRunner.run((Task)NoopTask.create((String)"task-id", (int)0));
        Assert.assertTrue((boolean)((TaskStatus)future.get()).isFailure());
        Assert.assertNotNull((Object)((TaskStatus)future.get()).getErrorMsg());
        Assert.assertTrue((boolean)((TaskStatus)future.get()).getErrorMsg().startsWith("The worker that this task is assigned did not start it in timeout"));
    }

    @Test
    public void testExceptionThrownInAssigningTasks() throws Exception {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 1;
            }

            public Period getTaskAssignmentTimeout() {
                return new Period((Object)"PT1S");
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                return new WorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, (List)ImmutableList.of()){

                    public void start() {
                        this.disabled.set(false);
                    }

                    public void stop() {
                    }

                    public boolean isInitialized() {
                        return true;
                    }

                    public void waitForInitialization() {
                    }

                    public boolean assignTask(Task task) {
                        throw new RuntimeException("Assign failure test");
                    }

                    public void shutdownTask(String taskId) {
                    }
                };
            }
        };
        taskRunner.start();
        DiscoveryDruidNode druidNode1 = new DiscoveryDruidNode(new DruidNode("service", "host1", false, Integer.valueOf(8080), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of((Object)"workerNodeService", (Object)new WorkerNodeService("ip1", 2, "0", "_default_worker_category")));
        druidNodeDiscovery.getListeners().get(0).nodesAdded((Collection)ImmutableList.of((Object)druidNode1));
        ListenableFuture future = taskRunner.run((Task)NoopTask.create((String)"task-id", (int)0));
        Assert.assertTrue((boolean)((TaskStatus)future.get()).isFailure());
        Assert.assertNotNull((Object)((TaskStatus)future.get()).getErrorMsg());
        Assert.assertTrue((String)StringUtils.format((String)"Actual message is: %s", (Object[])new Object[]{((TaskStatus)future.get()).getErrorMsg()}), (boolean)((TaskStatus)future.get()).getErrorMsg().startsWith("Failed to assign this task"));
    }

    private HttpRemoteTaskRunner createTaskRunnerForTestTaskAddedOrUpdated(TaskStorage taskStorage, final List<Object> listenerNotificationsAccumulator) {
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("workerNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        HttpRemoteTaskRunner taskRunner = new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), (ProvisioningStrategy)new NoopProvisioningStrategy(), druidNodeDiscoveryProvider, taskStorage, (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null));
        taskRunner.start();
        if (listenerNotificationsAccumulator != null) {
            taskRunner.registerListener(new TaskRunnerListener(){

                public String getListenerId() {
                    return "test-listener";
                }

                public void locationChanged(String taskId, TaskLocation newLocation) {
                    listenerNotificationsAccumulator.add(ImmutableList.of((Object)taskId, (Object)newLocation));
                }

                public void statusChanged(String taskId, TaskStatus status) {
                    listenerNotificationsAccumulator.add(ImmutableList.of((Object)taskId, (Object)status));
                }
            }, (Executor)Execs.directExecutor());
        }
        return taskRunner;
    }

    private static WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, final ScheduledExecutorService workersSyncExec, final WorkerHolder.Listener listener, final Worker worker, List<TaskAnnouncement> knownAnnouncements, final List<TaskAnnouncement> preExistingTaskAnnouncements, final Map<Task, List<TaskAnnouncement>> toBeAssignedTasks, final AtomicInteger ticks, final Set<String> actualShutdowns) {
        return new WorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, knownAnnouncements){
            private final String workerHost;
            private final int workerPort;
            private final LifecycleLock startStopLock;
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.startStopLock = new LifecycleLock();
                String hostAndPort = worker.getHost();
                int colonIndex = hostAndPort.indexOf(58);
                if (colonIndex == -1) {
                    throw new IAE("Invalid host and port: [%s]", new Object[]{colonIndex});
                }
                this.workerHost = hostAndPort.substring(0, colonIndex);
                this.workerPort = Integer.parseInt(hostAndPort.substring(colonIndex + 1));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() {
                LifecycleLock lifecycleLock = this.startStopLock;
                synchronized (lifecycleLock) {
                    if (!this.startStopLock.canStart()) {
                        throw new ISE("Can't start worker[%s:%s].", new Object[]{this.workerHost, this.workerPort});
                    }
                    try {
                        this.disabled.set(false);
                        if (!preExistingTaskAnnouncements.isEmpty()) {
                            workersSyncExec.execute(() -> {
                                for (TaskAnnouncement announcement : preExistingTaskAnnouncements) {
                                    ((Map)this.tasksSnapshotRef.get()).put(announcement.getTaskId(), announcement);
                                    listener.taskAddedOrUpdated(announcement, (WorkerHolder)this);
                                }
                                ticks.incrementAndGet();
                            });
                        }
                        this.startStopLock.started();
                    }
                    finally {
                        this.startStopLock.exitStart();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                LifecycleLock lifecycleLock = this.startStopLock;
                synchronized (lifecycleLock) {
                    if (!this.startStopLock.canStop()) {
                        throw new ISE("Can't stop worker[%s:%s].", new Object[]{this.workerHost, this.workerPort});
                    }
                    this.startStopLock.exitStop();
                }
            }

            public boolean isInitialized() {
                return true;
            }

            public void waitForInitialization() {
            }

            public boolean assignTask(Task task) {
                List<TaskAnnouncement> announcements;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                if (this.toImmutable().getCurrCapacityUsed() > worker.getCapacity()) {
                    throw new ISE("Got assigned tasks more than capacity.", new Object[0]);
                }
                if (toBeAssignedTasks.containsKey(task)) {
                    announcements = (List)toBeAssignedTasks.get(task);
                } else {
                    announcements = new ArrayList<TaskAnnouncement>();
                    announcements.add(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.unknown()));
                    announcements.add(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.running((String)task.getId()), (TaskLocation)TaskLocation.create((String)this.workerHost, (int)this.workerPort, (int)-1)));
                    announcements.add(TaskAnnouncement.create((Task)task, (TaskStatus)TaskStatus.success((String)task.getId()), (TaskLocation)TaskLocation.create((String)this.workerHost, (int)this.workerPort, (int)-1)));
                }
                workersSyncExec.execute(() -> {
                    for (TaskAnnouncement announcement : announcements) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        ((Map)this.tasksSnapshotRef.get()).put(announcement.getTaskId(), announcement);
                        listener.taskAddedOrUpdated(announcement, (WorkerHolder)this);
                    }
                    ticks.incrementAndGet();
                });
                return true;
            }

            public void shutdownTask(String taskId) {
                actualShutdowns.add(taskId);
            }
        };
    }

    private static HttpRemoteTaskRunner newHttpTaskRunnerInstance(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, ProvisioningStrategy provisioningStrategy) {
        return new HttpRemoteTaskRunner(TestHelper.makeJsonMapper(), new HttpRemoteTaskRunnerConfig(){

            public int getPendingTasksRunnerNumThreads() {
                return 3;
            }
        }, (HttpClient)EasyMock.createNiceMock(HttpClient.class), DSuppliers.of(new AtomicReference<DefaultWorkerBehaviorConfig>(DefaultWorkerBehaviorConfig.defaultConfig())), provisioningStrategy, druidNodeDiscoveryProvider, (TaskStorage)EasyMock.createNiceMock(TaskStorage.class), (CuratorFramework)EasyMock.createNiceMock(CuratorFramework.class), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null)){

            protected WorkerHolder createWorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, WorkerHolder.Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
                return HttpRemoteTaskRunnerTest.createWorkerHolder(smileMapper, httpClient, config, workersSyncExec, listener, worker, (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), new AtomicInteger(), (Set)ImmutableSet.of());
            }
        };
    }

    private static /* synthetic */ WorkerHolder lambda$testMarkWorkersLazy$8(Task task2, AtomicInteger ticks, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of(), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of((Object)task2, (Object)ImmutableList.of()), ticks, (Set<String>)ImmutableSet.of());
    }

    private static /* synthetic */ WorkerHolder lambda$testMarkWorkersLazy$7(Task task1, AtomicInteger ticks, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of(), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of((Object)task1, (Object)ImmutableList.of((Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host1", (int)8080, (int)-1)))), ticks, (Set<String>)ImmutableSet.of());
    }

    private static /* synthetic */ WorkerHolder lambda$testWorkerDisapperAndReappearAfterItsCleanup$6(Task task1, Task task2, AtomicInteger ticks, Set actualShutdowns, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of((Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.success((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235))), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of(), ticks, actualShutdowns);
    }

    private static /* synthetic */ WorkerHolder lambda$testWorkerDisapperAndReappearAfterItsCleanup$5(Task task1, Task task2, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of(), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of((Object)task1, (Object)ImmutableList.of((Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235))), (Object)task2, (Object)ImmutableList.of((Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)))), new AtomicInteger(), (Set<String>)ImmutableSet.of());
    }

    private static /* synthetic */ WorkerHolder lambda$testWorkerDisapperAndReappearBeforeItsCleanup$4(Task task2, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of((Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.success((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235))), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of(), new AtomicInteger(), (Set<String>)ImmutableSet.of());
    }

    private static /* synthetic */ WorkerHolder lambda$testWorkerDisapperAndReappearBeforeItsCleanup$3(Task task1, Task task2, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of(), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of((Object)task1, (Object)ImmutableList.of((Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.running((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.success((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235))), (Object)task2, (Object)ImmutableList.of((Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.unknown()), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)))), new AtomicInteger(), (Set<String>)ImmutableSet.of());
    }

    private static /* synthetic */ WorkerHolder lambda$testTaskRunnerRestart$2(Task task1, Task task2, Task task3, Task task4, Task task5, AtomicInteger ticks, Set taskShutdowns, ObjectMapper mapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService exec, WorkerHolder.Listener listener, Worker worker, List knownAnnouncements) {
        return HttpRemoteTaskRunnerTest.createWorkerHolder(mapper, httpClient, config, exec, listener, worker, knownAnnouncements, (List<TaskAnnouncement>)ImmutableList.of((Object)TaskAnnouncement.create((Task)task1, (TaskStatus)TaskStatus.success((String)task1.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.running((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.success((String)task2.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task3, (TaskStatus)TaskStatus.success((String)task3.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task4, (TaskStatus)TaskStatus.running((String)task4.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235)), (Object)TaskAnnouncement.create((Task)task5, (TaskStatus)TaskStatus.running((String)task5.getId()), (TaskLocation)TaskLocation.create((String)"host", (int)1234, (int)1235))), (Map<Task, List<TaskAnnouncement>>)ImmutableMap.of(), ticks, taskShutdowns);
    }

    private static interface CustomFunction {
        public WorkerHolder apply(ObjectMapper var1, HttpClient var2, HttpRemoteTaskRunnerConfig var3, ScheduledExecutorService var4, WorkerHolder.Listener var5, Worker var6, List<TaskAnnouncement> var7);
    }

    private static class TestDruidNodeDiscovery
    implements DruidNodeDiscovery {
        private List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();

        public Collection<DiscoveryDruidNode> getAllNodes() {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
            listener.nodesAdded((Collection)ImmutableList.of());
            listener.nodeViewInitialized();
            this.listeners.add(listener);
        }

        public void removeListener(DruidNodeDiscovery.Listener listener) {
            this.listeners.remove(listener);
        }

        public List<DruidNodeDiscovery.Listener> getListeners() {
            return this.listeners;
        }
    }
}

