/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageAdapter;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.WorkerTaskRunnerQueryAdapter;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.http.OverlordResource;
import org.apache.druid.indexing.overlord.http.TaskPayloadResponse;
import org.apache.druid.indexing.overlord.http.TaskStatusResponse;
import org.apache.druid.indexing.overlord.http.TotalWorkerCapacityResponse;
import org.apache.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.metadata.TaskLookup;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OverlordResourceTest {
    private OverlordResource overlordResource;
    private TaskMaster taskMaster;
    private JacksonConfigManager configManager;
    private ProvisioningStrategy provisioningStrategy;
    private TaskStorageQueryAdapter taskStorageQueryAdapter;
    private IndexerMetadataStorageAdapter indexerMetadataStorageAdapter;
    private HttpServletRequest req;
    private TaskRunner taskRunner;
    private WorkerTaskRunnerQueryAdapter workerTaskRunnerQueryAdapter;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.taskRunner = (TaskRunner)EasyMock.createMock(TaskRunner.class);
        this.configManager = (JacksonConfigManager)EasyMock.createMock(JacksonConfigManager.class);
        this.provisioningStrategy = (ProvisioningStrategy)EasyMock.createMock(ProvisioningStrategy.class);
        this.taskMaster = (TaskMaster)EasyMock.createStrictMock(TaskMaster.class);
        this.taskStorageQueryAdapter = (TaskStorageQueryAdapter)EasyMock.createStrictMock(TaskStorageQueryAdapter.class);
        this.indexerMetadataStorageAdapter = (IndexerMetadataStorageAdapter)EasyMock.createStrictMock(IndexerMetadataStorageAdapter.class);
        this.req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        this.workerTaskRunnerQueryAdapter = (WorkerTaskRunnerQueryAdapter)EasyMock.createStrictMock(WorkerTaskRunnerQueryAdapter.class);
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)this.taskRunner)).anyTimes();
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        String username = authenticationResult.getIdentity();
                        switch (resource.getName()) {
                            case "allow": {
                                return new Access(true);
                            }
                            case "wikipedia": {
                                return new Access(action == Action.READ && "Wiki Reader".equals(username));
                            }
                            case "buzzfeed": {
                                return new Access(action == Action.READ && "Buzz Reader".equals(username));
                            }
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.overlordResource = new OverlordResource(this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, null, this.configManager, null, authMapper, this.workerTaskRunnerQueryAdapter, this.provisioningStrategy);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
    }

    @Test
    public void testLeader() {
        EasyMock.expect((Object)this.taskMaster.getCurrentLeader()).andReturn((Object)"boz").once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.getLeader();
        Assert.assertEquals((Object)"boz", (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testIsLeader() {
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true).once();
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response1 = this.overlordResource.isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)true), (Object)response1.getEntity());
        Assert.assertEquals((long)200L, (long)response1.getStatus());
        Response response2 = this.overlordResource.isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)false), (Object)response2.getEntity());
        Assert.assertEquals((long)404L, (long)response2.getStatus());
    }

    @Test
    public void testSecuredGetWaitingTask() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "allow", (Object)this.getTaskWithIdAndDatasource("id_1", "allow")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_3"), "deny", (Object)this.getTaskWithIdAndDatasource("id_3", "deny")), (Object)new TaskInfo("id_4", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_4"), "deny", (Object)this.getTaskWithIdAndDatasource("id_4", "deny"))));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1")), (Object)((Object)new MockTaskRunnerWorkItem("id_4"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getWaitingTasks(this.req).getEntity();
        Assert.assertEquals((long)1L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_2", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
    }

    @Test
    public void testSecuredGetCompleteTasks() {
        this.expectAuthorizationTokenCheck();
        ImmutableList tasksIds = ImmutableList.of((Object)"id_1", (Object)"id_2", (Object)"id_3");
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, (Duration)null)), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_1"), "deny", (Object)this.getTaskWithIdAndDatasource("id_1", "deny")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getCompleteTasks(null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        Assert.assertEquals(tasksIds.get(1), (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertEquals(tasksIds.get(2), (Object)((TaskStatusPlus)responseObjects.get(1)).getId());
    }

    @Test
    public void testSecuredGetRunningTasks() {
        this.expectAuthorizationTokenCheck();
        ImmutableList tasksIds = ImmutableList.of((Object)"id_1", (Object)"id_2");
        EasyMock.expect((Object)this.taskRunner.getRunningTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(0))), (Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(1)))));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "deny", (Object)this.getTaskWithIdAndDatasource("id_1", "deny")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow"))));
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_1")).andStubReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_2")).andStubReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getRunningTasks(null, this.req).getEntity();
        Assert.assertEquals((long)1L, (long)responseObjects.size());
        Assert.assertEquals(tasksIds.get(1), (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
    }

    @Test
    public void testGetTasks() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance(), (Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null)), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_5", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_5"), "deny", (Object)this.getTaskWithIdAndDatasource("id_5", "deny")), (Object)new TaskInfo("id_6", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_6"), "allow", (Object)this.getTaskWithIdAndDatasource("id_6", "allow")), (Object)new TaskInfo("id_7", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_7"), "allow", (Object)this.getTaskWithIdAndDatasource("id_7", "allow")), (Object)new TaskInfo("id_5", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_5"), "deny", (Object)this.getTaskWithIdAndDatasource("id_5", "deny")), (Object)new TaskInfo("id_6", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_6"), "allow", (Object)this.getTaskWithIdAndDatasource("id_6", "allow")), (Object)new TaskInfo("id_7", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_7"), "allow", (Object)this.getTaskWithIdAndDatasource("id_7", "allow"))));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1")), (Object)((Object)new MockTaskRunnerWorkItem("id_4")))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks(null, null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)4L, (long)responseObjects.size());
    }

    @Test
    public void testGetTasksFilterDataSource() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null), (Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), "allow")).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_5", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_5"), "allow", (Object)this.getTaskWithIdAndDatasource("id_5", "allow")), (Object)new TaskInfo("id_6", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_6"), "allow", (Object)this.getTaskWithIdAndDatasource("id_6", "allow")), (Object)new TaskInfo("id_7", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_7"), "allow", (Object)this.getTaskWithIdAndDatasource("id_7", "allow")), (Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "allow", (Object)this.getTaskWithIdAndDatasource("id_1", "allow")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow")), (Object)new TaskInfo("id_4", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_4"), "allow", (Object)this.getTaskWithIdAndDatasource("id_4", "allow"))));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1")), (Object)((Object)new MockTaskRunnerWorkItem("id_4")))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks(null, "allow", null, null, null, this.req).getEntity();
        Assert.assertEquals((long)7L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_5", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertEquals((String)"DataSource Check", (Object)"allow", (Object)((TaskStatusPlus)responseObjects.get(0)).getDataSource());
    }

    @Test
    public void testGetTasksFilterWaitingState() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "allow", (Object)this.getTaskWithIdAndDatasource("id_1", "allow")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_3"), "deny", (Object)this.getTaskWithIdAndDatasource("id_3", "deny")), (Object)new TaskInfo("id_4", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_4"), "deny", (Object)this.getTaskWithIdAndDatasource("id_4", "deny"))));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1")), (Object)((Object)new MockTaskRunnerWorkItem("id_4"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks("waiting", null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)1L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_2", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
    }

    @Test
    public void testGetTasksFilterRunningState() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), "allow")).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "allow", (Object)this.getTaskWithIdAndDatasource("id_1", "allow")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow")), (Object)new TaskInfo("id_4", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_4"), "deny", (Object)this.getTaskWithIdAndDatasource("id_4", "deny"))));
        ImmutableList tasksIds = ImmutableList.of((Object)"id_1", (Object)"id_2");
        EasyMock.expect((Object)this.taskRunner.getRunningTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(0), "allow", "test")), (Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(1), "allow", "test"))));
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_1")).andReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_2")).andReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks("running", "allow", null, null, null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        Assert.assertEquals(tasksIds.get(0), (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertEquals((String)"DataSource Check", (Object)"allow", (Object)((TaskStatusPlus)responseObjects.get(0)).getDataSource());
    }

    @Test
    public void testGetTasksFilterPendingState() {
        this.expectAuthorizationTokenCheck();
        ImmutableList tasksIds = ImmutableList.of((Object)"id_1", (Object)"id_2");
        EasyMock.expect((Object)this.taskRunner.getPendingTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(0))), (Object)((Object)new MockTaskRunnerWorkItem((String)tasksIds.get(1)))));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_1"), "deny", (Object)this.getTaskWithIdAndDatasource("id_1", "deny")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow")), (Object)new TaskInfo("id_4", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.running((String)"id_4"), "deny", (Object)this.getTaskWithIdAndDatasource("id_4", "deny"))));
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_1")).andStubReturn((Object)RunnerTaskState.PENDING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_2")).andStubReturn((Object)RunnerTaskState.PENDING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_3")).andStubReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_4")).andStubReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks("pending", null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)1L, (long)responseObjects.size());
        Assert.assertEquals(tasksIds.get(1), (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertEquals((String)"DataSource Check", (Object)"allow", (Object)((TaskStatusPlus)responseObjects.get(0)).getDataSource());
    }

    @Test
    public void testGetTasksFilterCompleteState() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, (Duration)null)), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_1"), "allow", (Object)this.getTaskWithIdAndDatasource("id_1", "allow")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "deny", (Object)this.getTaskWithIdAndDatasource("id_2", "deny")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks("complete", null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_1", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertTrue((String)"DataSource Check", (boolean)"allow".equals(((TaskStatusPlus)responseObjects.get(0)).getDataSource()));
    }

    @Test
    public void testGetTasksFilterCompleteStateWithInterval() {
        this.expectAuthorizationTokenCheck();
        Duration duration = new Period((Object)"PT86400S").toStandardDuration();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)EasyMock.anyObject(), (String)EasyMock.anyObject())).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_1"), "deny", (Object)this.getTaskWithIdAndDatasource("id_1", "deny")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "allow", (Object)this.getTaskWithIdAndDatasource("id_2", "allow")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        String interval = "2010-01-01_P1D";
        List responseObjects = (List)this.overlordResource.getTasks("complete", null, interval, null, null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_2", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        Assert.assertTrue((String)"DataSource Check", (boolean)"allow".equals(((TaskStatusPlus)responseObjects.get(0)).getDataSource()));
    }

    @Test
    public void testGetTasksRequiresDatasourceRead() {
        this.expectAuthorizationTokenCheck("Wiki Reader");
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null), (Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of(this.createTaskInfo("id_5", "wikipedia"), this.createTaskInfo("id_6", "buzzfeed"), this.createTaskInfo("id_1", "wikipedia", TaskState.RUNNING, "test"), this.createTaskInfo("id_4", "buzzfeed", TaskState.RUNNING, "test")));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1", "wikipedia", "test")), (Object)((Object)new MockTaskRunnerWorkItem("id_4", "buzzfeed", "test")))).atLeastOnce();
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_4")).andReturn((Object)RunnerTaskState.PENDING);
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_1")).andReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks(null, null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        for (TaskStatusPlus taskStatus : responseObjects) {
            Assert.assertEquals((Object)"wikipedia", (Object)taskStatus.getDataSource());
        }
    }

    @Test
    public void testGetTasksFilterByTaskTypeRequiresDatasourceRead() {
        this.expectAuthorizationTokenCheck("Wiki Reader");
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null), (Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance()), null)).andStubReturn((Object)ImmutableList.of(this.createTaskInfo("id_5", "wikipedia"), this.createTaskInfo("id_6", "buzzfeed"), this.createTaskInfo("id_1", "wikipedia", TaskState.RUNNING, "to-return"), this.createTaskInfo("id_4", "wikipedia", TaskState.RUNNING, "test")));
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of((Object)((Object)new MockTaskRunnerWorkItem("id_1", "wikipedia", "to-return")), (Object)((Object)new MockTaskRunnerWorkItem("id_4", "wikipedia", "test")))).atLeastOnce();
        EasyMock.expect((Object)this.taskRunner.getRunnerTaskState("id_1")).andReturn((Object)RunnerTaskState.RUNNING);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks(null, null, null, null, "to-return", this.req).getEntity();
        Assert.assertEquals((long)1L, (long)responseObjects.size());
        for (TaskStatusPlus taskStatus : responseObjects) {
            Assert.assertEquals((Object)"to-return", (Object)taskStatus.getType());
        }
    }

    @Test
    public void testGetTasksFilterByDatasourceRequiresReadAccess() {
        this.expectAuthorizationTokenCheck("Wiki Reader");
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        this.expectedException.expect(WebApplicationException.class);
        this.overlordResource.getTasks(null, "buzzfeed", null, null, null, this.req);
    }

    @Test
    public void testGetNullCompleteTask() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfos((Map)ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of(null, null)), null)).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_1"), "allow", null), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "deny", (Object)this.getTaskWithIdAndDatasource("id_2", "deny")), (Object)new TaskInfo("id_3", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_3"), "allow", (Object)this.getTaskWithIdAndDatasource("id_3", "allow"))));
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        List responseObjects = (List)this.overlordResource.getTasks("complete", null, null, null, null, this.req).getEntity();
        Assert.assertEquals((long)2L, (long)responseObjects.size());
        Assert.assertEquals((Object)"id_1", (Object)((TaskStatusPlus)responseObjects.get(0)).getId());
        TaskStatusPlus tsp = (TaskStatusPlus)responseObjects.get(0);
        Assert.assertEquals(null, (Object)tsp.getType());
        Assert.assertTrue((String)"DataSource Check", (boolean)"allow".equals(((TaskStatusPlus)responseObjects.get(0)).getDataSource()));
    }

    @Test
    public void testGetTasksNegativeState() {
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Object responseObject = this.overlordResource.getTasks("blah", "ds_test", null, null, null, this.req).getEntity();
        Assert.assertEquals((Object)"Invalid state : blah, valid values are: [pending, waiting, running, complete]", (Object)responseObject.toString());
    }

    @Test
    public void testSecuredTaskPost() {
        this.expectedException.expect(ForbiddenException.class);
        this.expectAuthorizationTokenCheck();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        NoopTask task = NoopTask.create();
        this.overlordResource.taskPost((Task)task, this.req);
    }

    @Test
    public void testTaskPostDeniesDatasourceReadUser() {
        this.expectAuthorizationTokenCheck("Wiki Reader");
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        NoopTask task = NoopTask.create((String)"wikipedia");
        this.expectedException.expect(ForbiddenException.class);
        this.expectedException.expect(ForbiddenException.class);
        this.overlordResource.taskPost((Task)task, this.req);
    }

    @Test
    public void testKillPendingSegments() {
        this.expectAuthorizationTokenCheck();
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true);
        EasyMock.expect((Object)this.indexerMetadataStorageAdapter.deletePendingSegments((String)EasyMock.eq((Object)"allow"), (Interval)EasyMock.anyObject(Interval.class))).andReturn((Object)2);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Map response = (Map)this.overlordResource.killPendingSegments("allow", new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.nowUtc()).toString(), this.req).getEntity();
        Assert.assertEquals((long)2L, (long)((Integer)response.get("numDeleted")).intValue());
    }

    @Test
    public void testGetTaskPayload() throws Exception {
        NoopTask task = NoopTask.create((String)"mydatasource");
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTask("mytask")).andReturn((Object)Optional.of((Object)task));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTask("othertask")).andReturn((Object)Optional.absent());
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response1 = this.overlordResource.getTaskPayload("mytask");
        TaskPayloadResponse taskPayloadResponse1 = (TaskPayloadResponse)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString(response1.getEntity()), TaskPayloadResponse.class);
        Assert.assertEquals((Object)new TaskPayloadResponse("mytask", (Task)task), (Object)taskPayloadResponse1);
        Response response2 = this.overlordResource.getTaskPayload("othertask");
        TaskPayloadResponse taskPayloadResponse2 = (TaskPayloadResponse)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString(response2.getEntity()), TaskPayloadResponse.class);
        Assert.assertEquals((Object)new TaskPayloadResponse("othertask", null), (Object)taskPayloadResponse2);
    }

    @Test
    public void testGetTaskStatus() throws Exception {
        NoopTask task = NoopTask.create((String)"mytask", (int)0);
        TaskStatus status = TaskStatus.running((String)"mytask");
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfo("mytask")).andReturn((Object)new TaskInfo(task.getId(), DateTimes.of((String)"2018-01-01"), (Object)status, task.getDataSource(), (Object)task));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTaskInfo("othertask")).andReturn(null);
        EasyMock.expect((Object)this.taskRunner.getKnownTasks()).andReturn((Object)ImmutableList.of());
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response1 = this.overlordResource.getTaskStatus("mytask");
        TaskStatusResponse taskStatusResponse1 = (TaskStatusResponse)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString(response1.getEntity()), TaskStatusResponse.class);
        TaskStatusPlus tsp = taskStatusResponse1.getStatus();
        Assert.assertEquals((Object)tsp.getStatusCode(), (Object)tsp.getStatus());
        Assert.assertEquals((Object)new TaskStatusResponse("mytask", new TaskStatusPlus("mytask", "mytask", "noop", DateTimes.of((String)"2018-01-01"), DateTimes.EPOCH, TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(-1L), TaskLocation.unknown(), task.getDataSource(), null)), (Object)taskStatusResponse1);
        Response response2 = this.overlordResource.getTaskStatus("othertask");
        TaskStatusResponse taskStatusResponse2 = (TaskStatusResponse)TestHelper.makeJsonMapper().readValue(TestHelper.makeJsonMapper().writeValueAsString(response2.getEntity()), TaskStatusResponse.class);
        Assert.assertEquals((Object)new TaskStatusResponse("othertask", null), (Object)taskStatusResponse2);
    }

    @Test
    public void testGetLockedIntervals() throws Exception {
        Map<String, Integer> minTaskPriority = Collections.singletonMap("ds1", 0);
        Map<String, List<Interval>> expectedLockedIntervals = Collections.singletonMap("ds1", Arrays.asList(Intervals.of((String)"2012-01-01/2012-01-02"), Intervals.of((String)"2012-01-02/2012-01-03")));
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getLockedIntervals(minTaskPriority)).andReturn(expectedLockedIntervals);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.getDatasourceLockedIntervals(minTaskPriority);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Map observedLockedIntervals = (Map)jsonMapper.readValue(jsonMapper.writeValueAsString(response.getEntity()), (TypeReference)new TypeReference<Map<String, List<Interval>>>(){});
        Assert.assertEquals(expectedLockedIntervals, (Object)observedLockedIntervals);
    }

    @Test
    public void testGetLockedIntervalsWithEmptyBody() {
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.getDatasourceLockedIntervals(null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response = this.overlordResource.getDatasourceLockedIntervals(Collections.emptyMap());
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testShutdownTask() {
        TaskQueue mockQueue = (TaskQueue)EasyMock.createMock(TaskQueue.class);
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)this.taskRunner)).anyTimes();
        EasyMock.expect((Object)this.taskMaster.getTaskQueue()).andReturn((Object)Optional.of((Object)mockQueue)).anyTimes();
        mockQueue.shutdown("id_1", "Shutdown request from user", new Object[0]);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, mockQueue, this.workerTaskRunnerQueryAdapter});
        Map response = (Map)this.overlordResource.doShutdown("id_1").getEntity();
        Assert.assertEquals((Object)"id_1", response.get("task"));
    }

    @Test
    public void testShutdownAllTasks() {
        TaskQueue mockQueue = (TaskQueue)EasyMock.createMock(TaskQueue.class);
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)this.taskRunner)).anyTimes();
        EasyMock.expect((Object)this.taskMaster.getTaskQueue()).andReturn((Object)Optional.of((Object)mockQueue)).anyTimes();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getActiveTaskInfo("datasource")).andStubReturn((Object)ImmutableList.of((Object)new TaskInfo("id_1", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_1"), "datasource", (Object)this.getTaskWithIdAndDatasource("id_1", "datasource")), (Object)new TaskInfo("id_2", DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.success((String)"id_2"), "datasource", (Object)this.getTaskWithIdAndDatasource("id_2", "datasource"))));
        mockQueue.shutdown("id_1", "Shutdown request from user", new Object[0]);
        EasyMock.expectLastCall();
        mockQueue.shutdown("id_2", "Shutdown request from user", new Object[0]);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, mockQueue, this.workerTaskRunnerQueryAdapter});
        Map response = (Map)this.overlordResource.shutdownTasksForDataSource("datasource").getEntity();
        Assert.assertEquals((Object)"datasource", response.get("dataSource"));
    }

    @Test
    public void testShutdownAllTasksForNonExistingDataSource() {
        TaskQueue taskQueue = (TaskQueue)EasyMock.createMock(TaskQueue.class);
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.taskMaster.getTaskQueue()).andReturn((Object)Optional.of((Object)taskQueue)).anyTimes();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getActiveTaskInfo(EasyMock.anyString())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.shutdownTasksForDataSource("notExisting");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testEnableWorker() {
        String host = "worker-host";
        this.workerTaskRunnerQueryAdapter.enableWorker("worker-host");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.enableWorker("worker-host");
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"worker-host", (Object)"enabled"), (Object)response.getEntity());
    }

    @Test
    public void testDisableWorker() {
        String host = "worker-host";
        this.workerTaskRunnerQueryAdapter.disableWorker("worker-host");
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.disableWorker("worker-host");
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"worker-host", (Object)"disabled"), (Object)response.getEntity());
    }

    @Test
    public void testEnableWorkerWhenWorkerAPIRaisesError() {
        String host = "worker-host";
        this.workerTaskRunnerQueryAdapter.enableWorker("worker-host");
        EasyMock.expectLastCall().andThrow((Throwable)new RE("Worker API returns error!", new Object[0])).once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.enableWorker("worker-host");
        Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode(), (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Worker API returns error!"), (Object)response.getEntity());
    }

    @Test
    public void testDisableWorkerWhenWorkerAPIRaisesError() {
        String host = "worker-host";
        this.workerTaskRunnerQueryAdapter.disableWorker("worker-host");
        EasyMock.expectLastCall().andThrow((Throwable)new RE("Worker API returns error!", new Object[0])).once();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter});
        Response response = this.overlordResource.disableWorker("worker-host");
        Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode(), (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Worker API returns error!"), (Object)response.getEntity());
    }

    @Test
    public void testGetTotalWorkerCapacityNotLeader() {
        EasyMock.reset((Object[])new Object[]{this.taskMaster});
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.absent()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.SERVICE_UNAVAILABLE.getCode(), (long)response.getStatus());
    }

    @Test
    public void testGetTotalWorkerCapacityWithUnknown() {
        WorkerBehaviorConfig workerBehaviorConfig = (WorkerBehaviorConfig)EasyMock.createMock(WorkerBehaviorConfig.class);
        AtomicReference<WorkerBehaviorConfig> workerBehaviorConfigAtomicReference = new AtomicReference<WorkerBehaviorConfig>(workerBehaviorConfig);
        EasyMock.expect((Object)this.configManager.watch("worker.config", WorkerBehaviorConfig.class)).andReturn(workerBehaviorConfigAtomicReference);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getCurrentClusterCapacity());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getMaximumCapacityWithAutoScale());
    }

    @Test
    public void testGetTotalWorkerCapacityWithWorkerTaskRunnerButWorkerBehaviorConfigNotConfigured() {
        AtomicReference<Object> workerBehaviorConfigAtomicReference = new AtomicReference<Object>(null);
        EasyMock.expect((Object)this.configManager.watch("worker.config", WorkerBehaviorConfig.class)).andReturn(workerBehaviorConfigAtomicReference);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getCurrentClusterCapacity());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getMaximumCapacityWithAutoScale());
    }

    @Test
    public void testGetTotalWorkerCapacityWithWorkerTaskRunnerButAutoScaleNotConfigured() {
        DefaultWorkerBehaviorConfig workerBehaviorConfig = new DefaultWorkerBehaviorConfig(null, null);
        AtomicReference<DefaultWorkerBehaviorConfig> workerBehaviorConfigAtomicReference = new AtomicReference<DefaultWorkerBehaviorConfig>(workerBehaviorConfig);
        EasyMock.expect((Object)this.configManager.watch("worker.config", WorkerBehaviorConfig.class)).andReturn(workerBehaviorConfigAtomicReference);
        EasyMock.replay((Object[])new Object[]{this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getCurrentClusterCapacity());
        Assert.assertEquals((long)-1L, (long)((TotalWorkerCapacityResponse)response.getEntity()).getMaximumCapacityWithAutoScale());
    }

    @Test
    public void testGetTotalWorkerCapacityWithAutoScaleConfiguredAndProvisioningStrategySupportExpectedWorkerCapacity() {
        int expectedWorkerCapacity = 3;
        int maxNumWorkers = 2;
        WorkerTaskRunner workerTaskRunner = (WorkerTaskRunner)EasyMock.createMock(WorkerTaskRunner.class);
        ImmutableList workerInfos = ImmutableList.of((Object)new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", expectedWorkerCapacity, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")));
        EasyMock.expect((Object)workerTaskRunner.getWorkers()).andReturn((Object)workerInfos);
        EasyMock.reset((Object[])new Object[]{this.taskMaster});
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)workerTaskRunner)).anyTimes();
        EasyMock.expect((Object)this.provisioningStrategy.getExpectedWorkerCapacity((Collection)workerInfos)).andReturn((Object)expectedWorkerCapacity).anyTimes();
        AutoScaler autoScaler = (AutoScaler)EasyMock.createMock(AutoScaler.class);
        EasyMock.expect((Object)autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)autoScaler.getMaxNumWorkers()).andReturn((Object)maxNumWorkers);
        DefaultWorkerBehaviorConfig workerBehaviorConfig = new DefaultWorkerBehaviorConfig(null, autoScaler);
        AtomicReference<DefaultWorkerBehaviorConfig> workerBehaviorConfigAtomicReference = new AtomicReference<DefaultWorkerBehaviorConfig>(workerBehaviorConfig);
        EasyMock.expect((Object)this.configManager.watch("worker.config", WorkerBehaviorConfig.class)).andReturn(workerBehaviorConfigAtomicReference);
        EasyMock.replay((Object[])new Object[]{workerTaskRunner, autoScaler, this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager, this.provisioningStrategy});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((long)expectedWorkerCapacity, (long)((TotalWorkerCapacityResponse)response.getEntity()).getCurrentClusterCapacity());
        Assert.assertEquals((long)(expectedWorkerCapacity * maxNumWorkers), (long)((TotalWorkerCapacityResponse)response.getEntity()).getMaximumCapacityWithAutoScale());
    }

    @Test
    public void testGetTotalWorkerCapacityWithAutoScaleConfiguredAndProvisioningStrategyNotSupportExpectedWorkerCapacity() {
        int invalidExpectedCapacity = -1;
        int maxNumWorkers = 2;
        WorkerTaskRunner workerTaskRunner = (WorkerTaskRunner)EasyMock.createMock(WorkerTaskRunner.class);
        ImmutableList workerInfos = ImmutableList.of((Object)new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 3, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")));
        EasyMock.expect((Object)workerTaskRunner.getWorkers()).andReturn((Object)workerInfos);
        EasyMock.reset((Object[])new Object[]{this.taskMaster});
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)workerTaskRunner)).anyTimes();
        EasyMock.expect((Object)this.provisioningStrategy.getExpectedWorkerCapacity((Collection)workerInfos)).andReturn((Object)invalidExpectedCapacity).anyTimes();
        AutoScaler autoScaler = (AutoScaler)EasyMock.createMock(AutoScaler.class);
        EasyMock.expect((Object)autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)autoScaler.getMaxNumWorkers()).andReturn((Object)maxNumWorkers);
        DefaultWorkerBehaviorConfig workerBehaviorConfig = new DefaultWorkerBehaviorConfig(null, autoScaler);
        AtomicReference<DefaultWorkerBehaviorConfig> workerBehaviorConfigAtomicReference = new AtomicReference<DefaultWorkerBehaviorConfig>(workerBehaviorConfig);
        EasyMock.expect((Object)this.configManager.watch("worker.config", WorkerBehaviorConfig.class)).andReturn(workerBehaviorConfigAtomicReference);
        EasyMock.replay((Object[])new Object[]{workerTaskRunner, autoScaler, this.taskRunner, this.taskMaster, this.taskStorageQueryAdapter, this.indexerMetadataStorageAdapter, this.req, this.workerTaskRunnerQueryAdapter, this.configManager, this.provisioningStrategy});
        Response response = this.overlordResource.getTotalWorkerCapacity();
        Assert.assertEquals((long)HttpResponseStatus.OK.getCode(), (long)response.getStatus());
        Assert.assertEquals((long)((ImmutableWorkerInfo)workerInfos.stream().findFirst().get()).getWorker().getCapacity(), (long)((TotalWorkerCapacityResponse)response.getEntity()).getCurrentClusterCapacity());
        Assert.assertEquals((long)invalidExpectedCapacity, (long)((TotalWorkerCapacityResponse)response.getEntity()).getMaximumCapacityWithAutoScale());
    }

    private void expectAuthorizationTokenCheck() {
        this.expectAuthorizationTokenCheck("druid");
    }

    private void expectAuthorizationTokenCheck(String username) {
        AuthenticationResult authenticationResult = new AuthenticationResult(username, "druid", null, null);
        EasyMock.expect((Object)this.req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).atLeastOnce();
        this.req.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().anyTimes();
        this.req.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
    }

    private Task getTaskWithIdAndDatasource(String id, String datasource) {
        return this.getTaskWithIdAndDatasource(id, datasource, "test");
    }

    private Task getTaskWithIdAndDatasource(String id, String datasource, final String taskType) {
        return new AbstractTask(id, datasource, null){

            public String getType() {
                return taskType;
            }

            public boolean isReady(TaskActionClient taskActionClient) {
                return false;
            }

            public void stopGracefully(TaskConfig taskConfig) {
            }

            public TaskStatus run(TaskToolbox toolbox) {
                return null;
            }
        };
    }

    private TaskInfo<Task, TaskStatus> createTaskInfo(String taskId, String datasource) {
        return this.createTaskInfo(taskId, datasource, TaskState.SUCCESS, "test");
    }

    private TaskInfo<Task, TaskStatus> createTaskInfo(String taskId, String datasource, TaskState state, String taskType) {
        return new TaskInfo(taskId, DateTime.now((Chronology)ISOChronology.getInstanceUTC()), (Object)TaskStatus.fromCode((String)taskId, (TaskState)state), datasource, (Object)this.getTaskWithIdAndDatasource(taskId, datasource, taskType));
    }

    private static class MockTaskRunnerWorkItem
    extends TaskRunnerWorkItem {
        private final String dataSource;
        private final String type;

        public MockTaskRunnerWorkItem(String taskId) {
            this(taskId, "ds_test", "test");
        }

        public MockTaskRunnerWorkItem(String taskId, String dataSource, String type) {
            super(taskId, null);
            this.dataSource = dataSource;
            this.type = type;
        }

        public TaskLocation getLocation() {
            return TaskLocation.unknown();
        }

        public String getTaskType() {
            return this.type;
        }

        public String getDataSource() {
            return this.dataSource;
        }
    }

    private static class Datasources {
        private static final String WIKIPEDIA = "wikipedia";
        private static final String BUZZFEED = "buzzfeed";

        private Datasources() {
        }
    }

    private static class Users {
        private static final String DRUID = "druid";
        private static final String WIKI_READER = "Wiki Reader";
        private static final String BUZZ_READER = "Buzz Reader";

        private Users() {
        }
    }
}

