/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.indexing.overlord.http.security.TaskResourceFilter;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.server.security.AuthorizerMapper;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskResourceFilterTest {
    private AuthorizerMapper authorizerMapper;
    private TaskStorageQueryAdapter taskStorageQueryAdapter;
    private ContainerRequest containerRequest;
    private TaskResourceFilter resourceFilter;

    @Before
    public void setup() {
        this.authorizerMapper = (AuthorizerMapper)EasyMock.createMock(AuthorizerMapper.class);
        this.taskStorageQueryAdapter = (TaskStorageQueryAdapter)EasyMock.createMock(TaskStorageQueryAdapter.class);
        this.containerRequest = (ContainerRequest)EasyMock.createMock(ContainerRequest.class);
        this.resourceFilter = new TaskResourceFilter(this.taskStorageQueryAdapter, this.authorizerMapper);
    }

    @Test
    public void testTaskNotFound() {
        String taskId = "not_exist_task_id";
        EasyMock.expect((Object)this.containerRequest.getPathSegments()).andReturn(this.getPathSegments("/task/" + taskId)).anyTimes();
        EasyMock.expect((Object)this.containerRequest.getMethod()).andReturn((Object)"POST").anyTimes();
        SupervisorSpec supervisorSpec = (SupervisorSpec)EasyMock.createMock(SupervisorSpec.class);
        EasyMock.expect((Object)supervisorSpec.getDataSources()).andReturn(Collections.singletonList(taskId)).anyTimes();
        EasyMock.expect((Object)this.taskStorageQueryAdapter.getTask(taskId)).andReturn((Object)Optional.absent()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.containerRequest});
        EasyMock.replay((Object[])new Object[]{this.taskStorageQueryAdapter});
        WebApplicationException expected = null;
        try {
            this.resourceFilter.filter(this.containerRequest);
        }
        catch (WebApplicationException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)((Object)expected));
        Assert.assertEquals((long)expected.getResponse().getStatus(), (long)Response.Status.NOT_FOUND.getStatusCode());
        EasyMock.verify((Object[])new Object[]{this.containerRequest});
        EasyMock.verify((Object[])new Object[]{this.taskStorageQueryAdapter});
    }

    private List<PathSegment> getPathSegments(String path) {
        String[] segments = path.split("/");
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (final String segment : segments) {
            pathSegments.add(new PathSegment(){

                public String getPath() {
                    return segment;
                }

                public MultivaluedMap<String, String> getMatrixParameters() {
                    return null;
                }
            });
        }
        return pathSegments;
    }
}

