/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.thisptr.jackson.jq.internal.misc.Lists;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.overlord.sampler.SamplerException;
import org.apache.druid.indexing.overlord.sampler.SamplerTestUtils;
import org.apache.druid.indexing.seekablestream.RecordSupplierInputSource;
import org.apache.druid.indexing.seekablestream.common.OrderedPartitionableRecord;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.firehose.InlineFirehoseFactory;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputSourceSamplerTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final List<String> STR_JSON_ROWS = ImmutableList.of((Object)"{ \"t\": \"2019-04-22T12:00\", \"dim1\": \"foo\", \"met1\": 1 }", (Object)"{ \"t\": \"2019-04-22T12:00\", \"dim1\": \"foo\", \"met1\": 2 }", (Object)"{ \"t\": \"2019-04-22T12:01\", \"dim1\": \"foo\", \"met1\": 3 }", (Object)"{ \"t\": \"2019-04-22T12:00\", \"dim1\": \"foo2\", \"met1\": 4 }", (Object)"{ \"t\": \"2019-04-22T12:00\", \"dim1\": \"foo\", \"dim2\": \"bar\", \"met1\": 5 }", (Object)"{ \"t\": \"bad_timestamp\", \"dim1\": \"foo\", \"met1\": 6 }");
    private static final List<String> STR_CSV_ROWS = ImmutableList.of((Object)"2019-04-22T12:00,foo,,1", (Object)"2019-04-22T12:00,foo,,2", (Object)"2019-04-22T12:01,foo,,3", (Object)"2019-04-22T12:00,foo2,,4", (Object)"2019-04-22T12:00,foo,bar,5", (Object)"bad_timestamp,foo,,6");
    private List<Map<String, Object>> mapOfRows;
    private InputSourceSampler inputSourceSampler;
    private ParserType parserType;
    private boolean useInputFormatApi;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters(name="parserType = {0}, useInputFormatApi={1}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ParserType.STR_JSON, false}, (Object)new Object[]{ParserType.STR_JSON, true}, (Object)new Object[]{ParserType.STR_CSV, false}, (Object)new Object[]{ParserType.STR_CSV, true});
    }

    public InputSourceSamplerTest(ParserType parserType, boolean useInputFormatApi) {
        this.parserType = parserType;
        this.useInputFormatApi = useInputFormatApi;
    }

    @Before
    public void setupTest() {
        this.inputSourceSampler = new InputSourceSampler();
        this.mapOfRows = new ArrayList<Map<String, Object>>();
        ImmutableList columns = ImmutableList.of((Object)"t", (Object)"dim1", (Object)"dim2", (Object)"met1");
        for (String row : STR_CSV_ROWS) {
            ArrayList<Object> values = new ArrayList<Object>();
            String[] tokens = row.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                if (i < tokens.length - 1) {
                    values.add("".equals(tokens[i]) ? null : tokens[i]);
                    continue;
                }
                values.add(Integer.parseInt(tokens[i]));
            }
            this.mapOfRows.add(Utils.zipMapPartial((Iterable)columns, values));
        }
    }

    @Test
    public void testNoParams() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("inputSource required");
        this.inputSourceSampler.sample(null, null, null, null);
    }

    @Test
    public void testNoDataSchema() {
        InputSource inputSource = this.createInputSource(this.getTestRows(), null);
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, this.createInputFormat(), null, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)0L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)6L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(0)).getInput(), 1)), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(1)).getInput(), 2)), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(2)).getInput(), 3)), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(3)).getInput(), 4)), (SamplerResponse.SamplerResponseRow)data.get(3));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(4)).getInput(), 5)), (SamplerResponse.SamplerResponseRow)data.get(4));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(5)).getInput(), 6)), (SamplerResponse.SamplerResponseRow)data.get(5));
    }

    @Test
    public void testNoDataSchemaNumRows() {
        InputSource inputSource = this.createInputSource(this.getTestRows(), null);
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, this.createInputFormat(), null, new SamplerConfig(Integer.valueOf(3), null));
        Assert.assertEquals((long)3L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)0L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)3L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(0)).getInput(), 1)), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(1)).getInput(), 2)), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), null, Boolean.valueOf(true), this.unparseableTimestampErrorString(((SamplerResponse.SamplerResponseRow)data.get(2)).getInput(), 3)), (SamplerResponse.SamplerResponseRow)data.get(2));
    }

    @Test
    public void testMissingValueTimestampSpec() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec(null, null, DateTimes.of((String)"1970"));
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, null, null, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)6L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)6L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"2019-04-22T12:00")).put("dim2", null).put("dim1", "foo").put("met1", "1").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"2019-04-22T12:00")).put("dim2", null).put("dim1", "foo").put("met1", "2").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"2019-04-22T12:01")).put("dim2", null).put("dim1", "foo").put("met1", "3").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"2019-04-22T12:00")).put("dim2", null).put("dim1", "foo2").put("met1", "4").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(3));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"2019-04-22T12:00")).put("dim2", (Long)((Object)"bar")).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"5")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(4));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 0L).put("t", (Long)((Object)"bad_timestamp")).put("dim2", null).put("dim1", "foo").put("met1", "6").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(5));
    }

    @Test
    public void testWithTimestampSpec() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, null, null, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)6L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim2", null).put("dim1", "foo").put("met1", "1").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim2", null).put("dim1", "foo").put("met1", "2").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934460000L).put("dim2", null).put("dim1", "foo").put("met1", "3").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim2", null).put("dim1", "foo2").put("met1", "4").build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(3));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim2", (Long)((Object)"bar")).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"5")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(4));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(5));
    }

    @Test
    public void testWithDimensionSpec() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"dim1"), (Object)StringDimensionSchema.create((String)"met1")));
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, null, null, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)6L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"1")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"2")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934460000L).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"3")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo2")).put("met1", (Long)((Object)"4")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(3));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("met1", (Long)((Object)"5")).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(4));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(5));
    }

    @Test
    public void testWithNoRollup() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(false), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)6L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 1L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(1), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 2L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(2), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 3L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo2")).put("dim2", null).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(3));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", (Long)((Object)"bar")).put("met1", 5L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(4));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(5));
    }

    @Test
    public void testWithRollup() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)4L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 6L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo2")).put("dim2", null).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", (Long)((Object)"bar")).put("met1", 5L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(3));
    }

    @Test
    public void testWithMoreRollup() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"dim1")));
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, null);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)3L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("met1", 11L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo2")).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(2));
    }

    @Test
    public void testWithTransformsAutoDimensions() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim1PlusBar", "concat(dim1, 'bar')", TestExprMacroTable.INSTANCE)));
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, transformSpec);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)4L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 6L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo2")).put("dim2", null).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", (Long)((Object)"bar")).put("met1", 5L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(2));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(3));
    }

    @Test
    public void testWithTransformsDimensionsSpec() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"dim1PlusBar")));
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim1PlusBar", "concat(dim1 + 'bar')", TestExprMacroTable.INSTANCE)));
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, transformSpec);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)6L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)3L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foobar")).put("met1", 11L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foo2bar")).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(2));
    }

    @Test
    public void testWithFilter() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(null);
        TransformSpec transformSpec = new TransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null), null);
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, transformSpec);
        InputSource inputSource = this.createInputSource(this.getTestRows(), dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)5L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)4L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)3L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", null).put("met1", 6L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(4), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1", (Long)((Object)"foo")).put("dim2", (Long)((Object)"bar")).put("met1", 5L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(2));
    }

    @Test
    public void testIndexParseException() throws IOException {
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"dim1PlusBar")));
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim1PlusBar", "concat(dim1 + 'bar')", TestExprMacroTable.INSTANCE)));
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, transformSpec);
        ImmutableMap rawColumns4ParseExceptionRow = ImmutableMap.of((Object)"t", (Object)"2019-04-22T12:00", (Object)"dim1", (Object)"foo2", (Object)"met1", (Object)"invalidNumber");
        List inputTestRows = Lists.newArrayList(this.getTestRows());
        inputTestRows.add(ParserType.STR_CSV.equals((Object)this.parserType) ? "2019-04-22T12:00,foo2,,invalidNumber" : OBJECT_MAPPER.writeValueAsString((Object)rawColumns4ParseExceptionRow));
        InputSource inputSource = this.createInputSource(inputTestRows, dataSchema);
        InputFormat inputFormat = this.createInputFormat();
        SamplerResponse response = this.inputSourceSampler.sample(inputSource, inputFormat, dataSchema, null);
        Assert.assertEquals((long)7L, (long)response.getNumRowsRead());
        Assert.assertEquals((long)5L, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)4L, (long)response.getData().size());
        List data = response.getData();
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foobar")).put("met1", 11L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(0));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foo2bar")).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(1));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(this.getRawColumns().get(5), null, Boolean.valueOf(true), this.getUnparseableTimestampString()), (SamplerResponse.SamplerResponseRow)data.get(2));
        String indexParseExceptioMessage = ParserType.STR_CSV.equals((Object)this.parserType) ? "Found unparseable columns in row: [SamplerInputRow{row=TransformedInputRow{row=MapBasedInputRow{timestamp=2019-04-22T12:00:00.000Z, event={t=2019-04-22T12:00, dim1=foo2, dim2=null, met1=invalidNumber}, dimensions=[dim1PlusBar]}}}], exceptions: [Unable to parse value[invalidNumber] for field[met1]]" : "Found unparseable columns in row: [SamplerInputRow{row=TransformedInputRow{row=MapBasedInputRow{timestamp=2019-04-22T12:00:00.000Z, event={t=2019-04-22T12:00, dim1=foo2, met1=invalidNumber}, dimensions=[dim1PlusBar]}}}], exceptions: [Unable to parse value[invalidNumber] for field[met1]]";
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow((Map)rawColumns4ParseExceptionRow, null, Boolean.valueOf(true), indexParseExceptioMessage), (SamplerResponse.SamplerResponseRow)data.get(3));
    }

    @Test
    public void testMultipleJsonStringInOneBlock() throws IOException {
        int index;
        if (!ParserType.STR_JSON.equals((Object)this.parserType) || !this.useInputFormatApi) {
            return;
        }
        TimestampSpec timestampSpec = new TimestampSpec("t", null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"dim1PlusBar")));
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("dim1PlusBar", "concat(dim1 + 'bar')", TestExprMacroTable.INSTANCE)));
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[]{new LongSumAggregatorFactory("met1", "met1")};
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true), null);
        DataSchema dataSchema = this.createDataSchema(timestampSpec, dimensionsSpec, aggregatorFactories, (GranularitySpec)granularitySpec, transformSpec);
        ImmutableList jsonBlockList = ImmutableList.of((Object)String.join((CharSequence)"", STR_JSON_ROWS), (Object)STR_JSON_ROWS.stream().limit(STR_JSON_ROWS.size() - 1).collect(Collectors.joining()));
        SamplerResponse response = this.inputSourceSampler.sample((InputSource)new RecordSupplierInputSource("topicName", (RecordSupplier)new TestRecordSupplier((List<String>)jsonBlockList), true), this.createInputFormat(), dataSchema, new SamplerConfig(Integer.valueOf(200), Integer.valueOf(3000)));
        int illegalRows = STR_JSON_ROWS.size();
        int legalRows = STR_JSON_ROWS.size() - 1;
        Assert.assertEquals((long)(illegalRows + legalRows), (long)response.getNumRowsRead());
        Assert.assertEquals((long)legalRows, (long)response.getNumRowsIndexed());
        Assert.assertEquals((long)(illegalRows + 2), (long)response.getData().size());
        List data = response.getData();
        List<Map<String, Object>> rawColumnList = this.getRawColumns();
        String parseExceptionMessage = this.useInputFormatApi ? "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, met1=6}" : "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, met1=6}";
        for (index = 0; index < illegalRows; ++index) {
            InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(rawColumnList.get(index), null, Boolean.valueOf(true), parseExceptionMessage), (SamplerResponse.SamplerResponseRow)data.get(index));
        }
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(rawColumnList.get(0), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foobar")).put("met1", 11L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(index++));
        InputSourceSamplerTest.assertEqualsSamplerResponseRow(new SamplerResponse.SamplerResponseRow(rawColumnList.get(3), new SamplerTestUtils.MapAllowingNullValuesBuilder<String, Long>().put("__time", 1555934400000L).put("dim1PlusBar", (Long)((Object)"foo2bar")).put("met1", 4L).build(), null, null), (SamplerResponse.SamplerResponseRow)data.get(index));
    }

    @Test(expected=SamplerException.class)
    public void testReaderCreationException() {
        InputSource failingReaderInputSource = new InputSource(){

            public boolean isSplittable() {
                return false;
            }

            public boolean needsFormat() {
                return false;
            }

            public InputSourceReader reader(InputRowSchema inputRowSchema, @Nullable InputFormat inputFormat, File temporaryDirectory) {
                throw new RuntimeException();
            }
        };
        this.inputSourceSampler.sample(failingReaderInputSource, null, null, null);
    }

    private List<String> getTestRows() {
        switch (this.parserType) {
            case STR_JSON: {
                return STR_JSON_ROWS;
            }
            case STR_CSV: {
                return STR_CSV_ROWS;
            }
        }
        throw new IAE("Unknown parser type: %s", new Object[]{this.parserType});
    }

    private List<Map<String, Object>> getRawColumns() {
        switch (this.parserType) {
            case STR_JSON: {
                return this.mapOfRows.stream().map(this::removeEmptyValues).collect(Collectors.toList());
            }
            case STR_CSV: {
                return this.mapOfRows;
            }
        }
        throw new IAE("Unknown parser type: %s", new Object[]{this.parserType});
    }

    private InputFormat createInputFormat() {
        switch (this.parserType) {
            case STR_JSON: {
                return new JsonInputFormat(null, null, null);
            }
            case STR_CSV: {
                return new CsvInputFormat((List)ImmutableList.of((Object)"t", (Object)"dim1", (Object)"dim2", (Object)"met1"), null, null, Boolean.valueOf(false), 0);
            }
        }
        throw new IAE("Unknown parser type: %s", new Object[]{this.parserType});
    }

    private InputRowParser createInputRowParser(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec) {
        switch (this.parserType) {
            case STR_JSON: {
                return new StringInputRowParser((ParseSpec)new JSONParseSpec(timestampSpec, dimensionsSpec, null, null, null));
            }
            case STR_CSV: {
                return new StringInputRowParser((ParseSpec)new DelimitedParseSpec(timestampSpec, dimensionsSpec, ",", null, (List)ImmutableList.of((Object)"t", (Object)"dim1", (Object)"dim2", (Object)"met1"), false, 0));
            }
        }
        throw new IAE("Unknown parser type: %s", new Object[]{this.parserType});
    }

    private DataSchema createDataSchema(@Nullable TimestampSpec timestampSpec, @Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] aggregators, @Nullable GranularitySpec granularitySpec, @Nullable TransformSpec transformSpec) throws IOException {
        if (this.useInputFormatApi) {
            return new DataSchema("sampler", timestampSpec, dimensionsSpec, aggregators, granularitySpec, transformSpec);
        }
        Map<String, Object> parserMap = this.getParserMap(this.createInputRowParser(timestampSpec, dimensionsSpec));
        return new DataSchema("sampler", parserMap, aggregators, granularitySpec, transformSpec, OBJECT_MAPPER);
    }

    private Map<String, Object> getParserMap(InputRowParser parser) throws IOException {
        if (this.useInputFormatApi) {
            throw new RuntimeException("Don't call this if useInputFormatApi = true");
        }
        return (Map)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsBytes((Object)parser), Map.class);
    }

    private InputSource createInputSource(List<String> rows, DataSchema dataSchema) {
        String data = String.join((CharSequence)"\n", rows);
        if (this.useInputFormatApi) {
            return new InlineInputSource(data);
        }
        return new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)new InlineFirehoseFactory(data), this.createInputRowParser(dataSchema == null ? new TimestampSpec(null, null, null) : dataSchema.getTimestampSpec(), dataSchema == null ? new DimensionsSpec(null) : dataSchema.getDimensionsSpec()));
    }

    private String getUnparseableTimestampString() {
        if (this.useInputFormatApi) {
            return ParserType.STR_CSV.equals((Object)this.parserType) ? "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, dim2=null, met1=6} (Line: 6)" : "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, met1=6} (Line: 6)";
        }
        return ParserType.STR_CSV.equals((Object)this.parserType) ? "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, dim2=null, met1=6}" : "Timestamp[bad_timestamp] is unparseable! Event: {t=bad_timestamp, dim1=foo, met1=6}";
    }

    private String unparseableTimestampErrorString(Map<String, Object> rawColumns, int line) {
        if (this.useInputFormatApi) {
            return StringUtils.format((String)"Timestamp[null] is unparseable! Event: %s (Line: %d)", (Object[])new Object[]{rawColumns, line});
        }
        return StringUtils.format((String)"Timestamp[null] is unparseable! Event: %s", (Object[])new Object[]{rawColumns});
    }

    @Nullable
    private Map<String, Object> removeEmptyValues(Map<String, Object> data) {
        return data == null ? null : data.entrySet().stream().filter(x -> x.getValue() != null).filter(x -> !(x.getValue() instanceof String) || !((String)x.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void assertEqualsSamplerResponseRow(SamplerResponse.SamplerResponseRow row1, SamplerResponse.SamplerResponseRow row2) {
        Assert.assertTrue((boolean)InputSourceSamplerTest.equalsIgnoringType(row1.getInput(), row2.getInput()));
        Assert.assertEquals((Object)row1.getParsed(), (Object)row2.getParsed());
        Assert.assertEquals((Object)row1.getError(), (Object)row2.getError());
        Assert.assertEquals((Object)row1.isUnparseable(), (Object)row2.isUnparseable());
    }

    private static boolean equalsIgnoringType(Map<String, Object> map1, Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry1 : map1.entrySet()) {
            Object val2;
            Object val1 = entry1.getValue();
            if (InputSourceSamplerTest.equalsStringOrInteger(val1, val2 = map2.get(entry1.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsStringOrInteger(Object val1, Object val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        if (val1.equals(val2)) {
            return true;
        }
        if (val1 instanceof Number || val2 instanceof Number) {
            Integer int1 = val1 instanceof String ? Integer.valueOf(Integer.parseInt((String)val1)) : (val1 instanceof Number ? Integer.valueOf(((Number)val1).intValue()) : null);
            Integer int2 = val2 instanceof String ? Integer.valueOf(Integer.parseInt((String)val2)) : (val2 instanceof Number ? Integer.valueOf(((Number)val2).intValue()) : null);
            return Objects.equals(int1, int2);
        }
        return false;
    }

    private static class TestRecordSupplier
    implements RecordSupplier<Integer, Long, ByteEntity> {
        private final List<String> jsonList;
        private final Set<Integer> partitions;
        private boolean polled;

        public TestRecordSupplier(List<String> jsonList) {
            this.jsonList = jsonList;
            this.partitions = ImmutableSet.of((Object)5);
            this.polled = false;
        }

        public void assign(Set<StreamPartition<Integer>> set) {
        }

        public void seek(StreamPartition<Integer> partition, Long sequenceNumber) {
        }

        public void seekToEarliest(Set<StreamPartition<Integer>> set) {
        }

        public void seekToLatest(Set<StreamPartition<Integer>> set) {
        }

        public Collection<StreamPartition<Integer>> getAssignment() {
            return null;
        }

        @Nonnull
        public List<OrderedPartitionableRecord<Integer, Long, ByteEntity>> poll(long timeout) {
            if (this.polled) {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return Collections.emptyList();
            }
            this.polled = true;
            return this.jsonList.stream().map(jsonText -> new OrderedPartitionableRecord("topic", (Object)0, (Object)0L, Collections.singletonList(new ByteEntity(StringUtils.toUtf8((String)jsonText))))).collect(Collectors.toList());
        }

        @Nullable
        public Long getLatestSequenceNumber(StreamPartition<Integer> partition) {
            return null;
        }

        @Nullable
        public Long getEarliestSequenceNumber(StreamPartition<Integer> partition) {
            return null;
        }

        public Long getPosition(StreamPartition<Integer> partition) {
            return null;
        }

        public Set<Integer> getPartitionIds(String stream) {
            return this.partitions;
        }

        public void close() {
        }
    }

    private static enum ParserType {
        STR_JSON,
        STR_CSV;

    }
}

