/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMockSupport;
import org.joda.time.Interval;
import org.junit.Assert;

public class SeekableStreamIndexTaskTestBase
extends EasyMockSupport {
    protected static final ObjectMapper OBJECT_MAPPER;
    protected static final DataSchema OLD_DATA_SCHEMA;
    protected static final DataSchema NEW_DATA_SCHEMA;
    protected static final InputFormat INPUT_FORMAT;
    protected static final Logger LOG;
    protected static ListeningExecutorService taskExec;
    protected final List<Task> runningTasks = new ArrayList<Task>();
    protected final LockGranularity lockGranularity;
    protected File directory;
    protected File reportsFile;
    protected TaskToolboxFactory toolboxFactory;
    protected TaskStorage taskStorage;
    protected TaskLockbox taskLockbox;
    protected IndexerMetadataStorageCoordinator metadataStorageCoordinator;

    public SeekableStreamIndexTaskTestBase(LockGranularity lockGranularity) {
        this.lockGranularity = lockGranularity;
    }

    protected static ByteEntity jb(String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        return SeekableStreamIndexTaskTestBase.jb(false, timestamp, dim1, dim2, dimLong, dimFloat, met1);
    }

    protected static byte[] jbb(String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        return SeekableStreamIndexTaskTestBase.jbb(false, timestamp, dim1, dim2, dimLong, dimFloat, met1);
    }

    protected static ByteEntity jb(boolean prettyPrint, String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        return new ByteEntity(SeekableStreamIndexTaskTestBase.jbb(prettyPrint, timestamp, dim1, dim2, dimLong, dimFloat, met1));
    }

    protected static byte[] jbb(boolean prettyPrint, String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        return StringUtils.toUtf8((String)SeekableStreamIndexTaskTestBase.toJsonString(prettyPrint, timestamp, dim1, dim2, dimLong, dimFloat, met1));
    }

    protected static List<ByteEntity> jbl(String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        return Collections.singletonList(SeekableStreamIndexTaskTestBase.jb(timestamp, dim1, dim2, dimLong, dimFloat, met1));
    }

    protected static String toJsonString(boolean prettyPrint, String timestamp, String dim1, String dim2, String dimLong, String dimFloat, String met1) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (prettyPrint) {
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
            }
            return mapper.writeValueAsString((Object)ImmutableMap.builder().put((Object)"timestamp", (Object)timestamp).put((Object)"dim1", (Object)dim1).put((Object)"dim2", (Object)dim2).put((Object)"dimLong", (Object)dimLong).put((Object)"dimFloat", (Object)dimFloat).put((Object)"met1", (Object)met1).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File getSegmentDirectory() {
        return new File(this.directory, "segments");
    }

    protected List<String> readSegmentColumn(String column, SegmentDescriptor descriptor) throws IOException {
        File indexBasePath = new File(StringUtils.format((String)"%s/%s/%s_%s/%s/%d", (Object[])new Object[]{this.getSegmentDirectory(), OLD_DATA_SCHEMA.getDataSource(), descriptor.getInterval().getStart(), descriptor.getInterval().getEnd(), descriptor.getVersion(), descriptor.getPartitionNumber()}));
        File outputLocation = new File(this.directory, StringUtils.format((String)"%s_%s_%s_%s", (Object[])new Object[]{descriptor.getInterval().getStart(), descriptor.getInterval().getEnd(), descriptor.getVersion(), descriptor.getPartitionNumber()}));
        outputLocation.mkdir();
        CompressionUtils.unzip((ByteSource)Files.asByteSource((File)new File(indexBasePath.listFiles()[0], "index.zip")), (File)outputLocation, (Predicate)Predicates.alwaysFalse(), (boolean)false);
        IndexIO indexIO = new TestUtils().getTestIndexIO();
        QueryableIndex index = indexIO.loadIndex(outputLocation);
        DictionaryEncodedColumn theColumn = (DictionaryEncodedColumn)index.getColumnHolder(column).getColumn();
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < theColumn.length(); ++i) {
            int id = theColumn.getSingleValueRow(i);
            String value = (String)((Object)theColumn.lookupName(id));
            values.add(value);
        }
        return values;
    }

    protected SegmentDescriptor sd(String intervalString, int partitionNum) {
        Interval interval = Intervals.of((String)intervalString);
        return new SegmentDescriptor(interval, "fakeVersion", partitionNum);
    }

    protected void assertEqualsExceptVersion(List<SegmentDescriptorAndExpectedDim1Values> expectedDescriptors, List<SegmentDescriptor> actualDescriptors) throws IOException {
        Assert.assertEquals((long)expectedDescriptors.size(), (long)actualDescriptors.size());
        Comparator comparator = (s1, s2) -> {
            int intervalCompare = Comparators.intervalsByStartThenEnd().compare(s1.getInterval(), s2.getInterval());
            if (intervalCompare == 0) {
                return Integer.compare(s1.getPartitionNumber(), s2.getPartitionNumber());
            }
            return intervalCompare;
        };
        ArrayList<SegmentDescriptorAndExpectedDim1Values> expectedDescsCopy = new ArrayList<SegmentDescriptorAndExpectedDim1Values>(expectedDescriptors);
        ArrayList<SegmentDescriptor> actualDescsCopy = new ArrayList<SegmentDescriptor>(actualDescriptors);
        expectedDescsCopy.sort(Comparator.comparing(SegmentDescriptorAndExpectedDim1Values::getSegmentDescriptor, comparator));
        actualDescsCopy.sort(comparator);
        for (int i = 0; i < expectedDescsCopy.size(); ++i) {
            SegmentDescriptorAndExpectedDim1Values expectedDesc = (SegmentDescriptorAndExpectedDim1Values)expectedDescsCopy.get(i);
            SegmentDescriptor actualDesc = (SegmentDescriptor)actualDescsCopy.get(i);
            Assert.assertEquals((Object)expectedDesc.segmentDescriptor.getInterval(), (Object)actualDesc.getInterval());
            Assert.assertEquals((long)expectedDesc.segmentDescriptor.getPartitionNumber(), (long)actualDesc.getPartitionNumber());
            if (expectedDesc.expectedDim1Values.isEmpty()) continue;
            Assertions.assertThat(this.readSegmentColumn("dim1", actualDesc)).isIn(expectedDesc.expectedDim1Values);
        }
    }

    protected SegmentDescriptorAndExpectedDim1Values sdd(String interval, int partitionNum, List<String> ... expectedDim1Values) {
        return new SegmentDescriptorAndExpectedDim1Values(interval, partitionNum, expectedDim1Values);
    }

    protected IngestionStatsAndErrorsTaskReportData getTaskReportData() throws IOException {
        Map taskReports = (Map)OBJECT_MAPPER.readValue(this.reportsFile, (TypeReference)new TypeReference<Map<String, TaskReport>>(){});
        return IngestionStatsAndErrorsTaskReportData.getPayloadFromTaskReports((Map)taskReports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<TaskStatus> runTask(Task task) {
        try {
            this.taskStorage.insert(task, TaskStatus.running((String)task.getId()));
        }
        catch (EntryExistsException entryExistsException) {
            // empty catch block
        }
        this.taskLockbox.syncFromStorage();
        TaskToolbox toolbox = this.toolboxFactory.build(task);
        List<Task> list = this.runningTasks;
        synchronized (list) {
            this.runningTasks.add(task);
        }
        return taskExec.submit(() -> {
            try {
                task.addToContext("forceTimeChunkLock", (Object)(this.lockGranularity == LockGranularity.TIME_CHUNK ? 1 : 0));
                if (task.isReady(toolbox.getTaskActionClient())) {
                    return task.run(toolbox);
                }
                throw new ISE("Task is not ready", new Object[0]);
            }
            catch (Throwable e) {
                LOG.warn(e, "Task failed", new Object[0]);
                return TaskStatus.failure((String)task.getId(), (String)Throwables.getStackTraceAsString((Throwable)e));
            }
        });
    }

    protected long countEvents(Task task) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(OLD_DATA_SCHEMA.getDataSource()).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("rows", "rows"))).granularity(Granularities.ALL).intervals("0000/3000").build();
        List results = task.getQueryRunner((Query)query).run(QueryPlus.wrap((Query)query)).toList();
        return results.isEmpty() ? 0L : DimensionHandlerUtils.nullToZero((Long)((TimeseriesResultValue)((Result)results.get(0)).getValue()).getLongMetric("rows"));
    }

    protected void unlockAppenderatorBasePersistDirForTask(SeekableStreamIndexTask task) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method unlockBasePersistDir = ((StreamAppenderator)task.getAppenderator()).getClass().getDeclaredMethod("unlockBasePersistDirectory", new Class[0]);
        unlockBasePersistDir.setAccessible(true);
        unlockBasePersistDir.invoke((Object)task.getAppenderator(), new Object[0]);
    }

    protected Collection<DataSegment> publishedSegments() {
        return this.metadataStorageCoordinator.retrieveAllUsedSegments(OLD_DATA_SCHEMA.getDataSource(), Segments.ONLY_VISIBLE);
    }

    protected List<SegmentDescriptor> publishedDescriptors() {
        return this.publishedSegments().stream().map(DataSegment::toDescriptor).collect(Collectors.toList());
    }

    protected void destroyToolboxFactory() {
        this.toolboxFactory = null;
        this.taskStorage = null;
        this.taskLockbox = null;
        this.metadataStorageCoordinator = null;
    }

    static {
        NEW_DATA_SCHEMA = new DataSchema("test_ds", new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dim1"), new StringDimensionSchema("dim1t"), new StringDimensionSchema("dim2"), new LongDimensionSchema("dimLong"), new FloatDimensionSchema("dimFloat"))), new AggregatorFactory[]{new DoubleSumAggregatorFactory("met1sum", "met1"), new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, null), null);
        INPUT_FORMAT = new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of()), (Map)ImmutableMap.of(), null);
        LOG = new Logger(SeekableStreamIndexTaskTestBase.class);
        NullHandling.initializeForTests();
        OBJECT_MAPPER = new TestUtils().getTestObjectMapper();
        OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(JSONParseSpec.class, "json")});
        OLD_DATA_SCHEMA = new DataSchema("test_ds", (Map)OBJECT_MAPPER.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dim1"), new StringDimensionSchema("dim1t"), new StringDimensionSchema("dim2"), new LongDimensionSchema("dimLong"), new FloatDimensionSchema("dimFloat"))), new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of()), (Map)ImmutableMap.of(), Boolean.valueOf(false)), StandardCharsets.UTF_8.name()), Map.class), new AggregatorFactory[]{new DoubleSumAggregatorFactory("met1sum", "met1"), new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, null), null, OBJECT_MAPPER);
    }

    protected class SegmentDescriptorAndExpectedDim1Values {
        final SegmentDescriptor segmentDescriptor;
        final Set<List<String>> expectedDim1Values;

        protected SegmentDescriptorAndExpectedDim1Values(String interval, int partitionNum, List<String> ... expectedDim1Values) {
            this.segmentDescriptor = SeekableStreamIndexTaskTestBase.this.sd(interval, partitionNum);
            this.expectedDim1Values = ImmutableSet.copyOf(Arrays.asList(expectedDim1Values));
        }

        public SegmentDescriptor getSegmentDescriptor() {
            return this.segmentDescriptor;
        }
    }
}

